/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.api.item.IUpgradeAcceptor;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerItem;
import me.desht.pneumaticcraft.client.ColorHandlers;
import me.desht.pneumaticcraft.client.sound.MovingSounds;
import me.desht.pneumaticcraft.common.PneumaticCraftTags;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.core.ModContainers;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.inventory.ContainerChargingStationUpgradeManager;
import me.desht.pneumaticcraft.common.inventory.ContainerJackhammerSetup;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.item.IChargeableContainerProvider;
import me.desht.pneumaticcraft.common.item.ItemDrillBit;
import me.desht.pneumaticcraft.common.item.ItemPressurizable;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlayMovingSound;
import me.desht.pneumaticcraft.common.tileentity.TileEntityChargingStation;
import me.desht.pneumaticcraft.common.util.NBTUtils;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.UpgradableItemUtils;
import me.desht.pneumaticcraft.common.util.upgrade.ApplicableUpgradesDB;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.NetworkHooks;

public class ItemJackHammer
extends ItemPressurizable
implements IChargeableContainerProvider,
IUpgradeAcceptor,
ColorHandlers.ITintableItem {
    private static final float[] SPEED_MULT = new float[]{1.0f, 2.0f, 2.4142137f, 2.732051f, 3.0f, 3.236068f, 3.4494898f, 3.6457512f, 3.828427f, 4.0f, 4.1622777f};
    private static final String NBT_DIG_MODE = "DigMode";

    public ItemJackHammer() {
        super(ModItems.toolProps(), 120000, 12000);
    }

    public static DrillBitHandler getDrillBitHandler(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemJackHammer) {
            return new DrillBitHandler(stack);
        }
        return null;
    }

    public static EnchantmentHandler getEnchantmentHandler(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemJackHammer) {
            return new EnchantmentHandler(stack);
        }
        return null;
    }

    public ItemDrillBit.DrillBitType getDrillBit(ItemStack stack) {
        DrillBitHandler handler = new DrillBitHandler(stack);
        ItemStack bitStack = handler.getStackInSlot(0);
        if (bitStack.func_77973_b() instanceof ItemDrillBit) {
            return ((ItemDrillBit)bitStack.func_77973_b()).getType();
        }
        return ItemDrillBit.DrillBitType.NONE;
    }

    public boolean canHarvestBlock(ItemStack stack, BlockState blockIn) {
        ItemDrillBit.DrillBitType drillBitType = this.getDrillBit(stack);
        return drillBitType.getHarvestLevel() >= blockIn.getHarvestLevel();
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        ItemDrillBit.DrillBitType bitType = this.getDrillBit(stack);
        int speed = bitType == ItemDrillBit.DrillBitType.NONE ? 0 : UpgradableItemUtils.getUpgrades(stack, EnumUpgrade.SPEED);
        return (float)ItemJackHammer.getAir(stack) > 0.0f ? (float)bitType.getBaseEfficiency() * SPEED_MULT[speed] : 1.0f;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, final Hand handIn) {
        final ItemStack stack = playerIn.func_184586_b(handIn);
        if (!playerIn.func_213453_ef() || stack.func_190916_E() != 1) {
            return ActionResult.func_226250_c_((Object)stack);
        }
        if (!worldIn.field_72995_K) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerIn), (INamedContainerProvider)new INamedContainerProvider(){

                public ITextComponent func_145748_c_() {
                    return stack.func_200301_q();
                }

                @Nullable
                public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
                    return new ContainerJackhammerSetup(windowId, inv, handIn);
                }
            }, buf -> buf.writeBoolean(handIn == Hand.MAIN_HAND));
        }
        return ActionResult.func_226248_a_((Object)stack);
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (entityLiving instanceof PlayerEntity && ((PlayerEntity)entityLiving).func_184812_l_()) {
            return true;
        }
        int speed = UpgradableItemUtils.getUpgrades(stack, EnumUpgrade.SPEED);
        ((IAirHandlerItem)stack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).orElseThrow(RuntimeException::new)).addAir(-50 * speed);
        return true;
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return this.getDrillBit(stack) != ItemDrillBit.DrillBitType.NONE && (float)ItemJackHammer.getAir(stack) > 0.0f;
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, PlayerEntity player) {
        if (!player.func_130014_f_().field_72995_K && !player.func_213453_ef()) {
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
            World world = serverPlayer.func_130014_f_();
            RayTraceResult brtr = PneumaticCraftUtils.getEntityLookedObject((LivingEntity)player);
            if (brtr instanceof BlockRayTraceResult) {
                itemstack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).ifPresent(airHandler -> {
                    float air;
                    List<Integer> upgrades = UpgradableItemUtils.getUpgradeList(itemstack, EnumUpgrade.SPEED, EnumUpgrade.RANGE, EnumUpgrade.MAGNET);
                    int speed = upgrades.get(0);
                    DigMode digMode = ItemJackHammer.getDigMode(itemstack);
                    ItemDrillBit.DrillBitType bitType = this.getDrillBit(itemstack);
                    if (digMode.getBitType().getTier() > bitType.getTier()) {
                        digMode = DigMode.MODE_1X1;
                    }
                    Set<BlockPos> brokenPos = this.getBreakPositions(world, pos, ((BlockRayTraceResult)brtr).func_216354_b(), player.func_174811_aO(), digMode);
                    brokenPos.remove(pos);
                    float air0 = air = (float)airHandler.getAir();
                    float usage = 50.0f * SPEED_MULT[speed];
                    for (BlockPos pos1 : brokenPos) {
                        int exp;
                        BlockState state1 = world.func_180495_p(pos1);
                        if (state1.func_185887_b((IBlockReader)world, pos1) < 0.0f || (exp = ForgeHooks.onBlockBreakEvent((World)serverPlayer.field_70170_p, (GameType)serverPlayer.field_71134_c.func_73081_b(), (ServerPlayerEntity)serverPlayer, (BlockPos)pos1)) == -1 || world.func_175625_s(pos1) != null) continue;
                        Block block = state1.func_177230_c();
                        boolean removed = state1.removedByPlayer(world, pos1, player, true, world.func_204610_c(pos1));
                        if (removed) {
                            block.func_176206_d((IWorld)world, pos1, state1);
                            block.func_180657_a(world, player, pos1, state1, null, itemstack);
                            if (exp > 0 && world instanceof ServerWorld) {
                                block.func_180637_b((ServerWorld)world, pos1, exp);
                            }
                            if (!player.func_184812_l_()) {
                                air -= usage;
                            }
                            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
                        }
                        if (!(air < usage)) continue;
                        break;
                    }
                    if (air != air0) {
                        airHandler.addAir((int)(air - air0));
                    }
                });
            }
        }
        return super.onBlockStartBreak(itemstack, pos, player);
    }

    private Set<BlockPos> getBreakPositions(World world, BlockPos pos, Direction dir, Direction playerHoriz, DigMode digMode) {
        if (digMode.isVeinMining()) {
            return new HashSet<BlockPos>(this.getVeinPositions(world, pos, digMode));
        }
        HashSet<BlockPos> res = new HashSet<BlockPos>();
        if (digMode.atLeast(DigMode.MODE_1X2)) {
            res.add(dir.func_176740_k() == Direction.Axis.Y ? pos.func_177972_a(playerHoriz) : pos.func_177977_b());
        }
        if (digMode.atLeast(DigMode.MODE_1X3)) {
            res.add(dir.func_176740_k() == Direction.Axis.Y ? pos.func_177972_a(playerHoriz.func_176734_d()) : pos.func_177984_a());
        }
        if (digMode.atLeast(DigMode.MODE_3X3_CROSS)) {
            switch (dir.func_176740_k()) {
                case X: {
                    res.add(pos.func_177978_c());
                    res.add(pos.func_177968_d());
                    res.add(pos.func_177984_a());
                    res.add(pos.func_177977_b());
                    break;
                }
                case Y: {
                    res.add(pos.func_177978_c());
                    res.add(pos.func_177968_d());
                    res.add(pos.func_177976_e());
                    res.add(pos.func_177974_f());
                    break;
                }
                case Z: {
                    res.add(pos.func_177984_a());
                    res.add(pos.func_177977_b());
                    res.add(pos.func_177976_e());
                    res.add(pos.func_177974_f());
                }
            }
        }
        if (digMode.atLeast(DigMode.MODE_3X3_FULL)) {
            switch (dir.func_176740_k()) {
                case X: {
                    res.add(pos.func_177984_a().func_177978_c());
                    res.add(pos.func_177984_a().func_177968_d());
                    res.add(pos.func_177977_b().func_177978_c());
                    res.add(pos.func_177977_b().func_177968_d());
                    break;
                }
                case Y: {
                    res.add(pos.func_177978_c().func_177974_f());
                    res.add(pos.func_177978_c().func_177976_e());
                    res.add(pos.func_177968_d().func_177974_f());
                    res.add(pos.func_177968_d().func_177976_e());
                    break;
                }
                case Z: {
                    res.add(pos.func_177984_a().func_177974_f());
                    res.add(pos.func_177984_a().func_177976_e());
                    res.add(pos.func_177977_b().func_177974_f());
                    res.add(pos.func_177977_b().func_177976_e());
                }
            }
        }
        return res;
    }

    private List<BlockPos> getVeinPositions(World world, BlockPos startPos, DigMode mode) {
        BlockState state = world.func_180495_p(startPos);
        if (!mode.okToVeinMine(state)) {
            return Collections.emptyList();
        }
        int maxRange = PNCConfig.Common.Jackhammer.maxVeinMinerRange;
        int maxRangeSq = maxRange * maxRange;
        ArrayList<BlockPos> found = new ArrayList<BlockPos>();
        found.add(startPos);
        ObjectOpenHashSet checked = new ObjectOpenHashSet();
        Block startBlock = state.func_177230_c();
        int maxBlocks = mode.getBlocksDug();
        for (int i = 0; i < found.size(); ++i) {
            BlockPos blockPos = (BlockPos)found.get(i);
            for (BlockPos pos : BlockPos.func_218278_a((BlockPos)blockPos.func_177982_a(-1, -1, -1), (BlockPos)blockPos.func_177982_a(1, 1, 1))) {
                if (checked.contains(pos) || mode == DigMode.MODE_VEIN_PLUS && startPos.func_177951_i((Vector3i)pos) > (double)maxRangeSq || !world.func_195588_v(pos) || startBlock != world.func_180495_p(pos).func_177230_c()) continue;
                BlockPos pos1 = pos.func_185334_h();
                found.add(pos1);
                checked.add(pos1);
                if (found.size() <= maxBlocks) continue;
                return found;
            }
        }
        return found;
    }

    @Override
    public Map<EnumUpgrade, Integer> getApplicableUpgrades() {
        return ApplicableUpgradesDB.getInstance().getApplicableUpgrades(this);
    }

    @Override
    public String getUpgradeAcceptorTranslationKey() {
        return this.func_77658_a();
    }

    @Override
    public INamedContainerProvider getContainerProvider(TileEntityChargingStation te) {
        return new IChargeableContainerProvider.Provider(te, (ContainerType<? extends ContainerChargingStationUpgradeManager>)((ContainerType)ModContainers.CHARGING_JACKHAMMER.get()));
    }

    @Override
    public int getTintColor(ItemStack stack, int tintIndex) {
        if (tintIndex == 0) {
            return this.getDrillBit(stack).getTint();
        }
        return -1;
    }

    public static DigMode getDigMode(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemJackHammer && stack.func_77942_o()) {
            try {
                return stack.func_77978_p().func_74764_b(NBT_DIG_MODE) ? DigMode.valueOf(stack.func_77978_p().func_74779_i(NBT_DIG_MODE)) : DigMode.MODE_1X1;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return DigMode.MODE_1X1;
    }

    public static void setDigMode(ItemStack stack, DigMode mode) {
        stack.func_196082_o().func_74778_a(NBT_DIG_MODE, mode.toString());
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    @Mod.EventBusSubscriber(modid="pneumaticcraft")
    public static class Listener {
        @SubscribeEvent
        public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
            PlayerEntity player = event.getPlayer();
            ItemStack stack = player.func_184586_b(event.getHand());
            if (stack.func_77973_b() == ModItems.JACKHAMMER.get() && (float)ItemPressurizable.getAir(stack) > 0.0f) {
                if (event.getWorld().field_72995_K) {
                    MovingSounds.playMovingSound(MovingSounds.Sound.JACKHAMMER, event.getPlayer(), new Object[0]);
                } else {
                    NetworkHandler.sendToAllTracking(new PacketPlayMovingSound(MovingSounds.Sound.JACKHAMMER, player), (Entity)player);
                }
            }
        }
    }

    public static class EnchantmentHandler
    extends BaseItemStackHandler {
        private final ItemStack jackhammerStack;

        public EnchantmentHandler(ItemStack jackhammerStack) {
            super(1);
            this.jackhammerStack = jackhammerStack;
            Map ench = EnchantmentHelper.func_82781_a((ItemStack)jackhammerStack);
            if (ench.size() == 1 && (ench.containsKey(Enchantments.field_185306_r) || ench.containsKey(Enchantments.field_185308_t))) {
                ItemStack book = new ItemStack((IItemProvider)Items.field_151134_bR);
                EnchantmentHelper.func_82782_a((Map)ench, (ItemStack)book);
                this.setStackInSlot(0, book);
            }
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return stack.func_190926_b() || EnchantmentHandler.validateBook(stack);
        }

        public void save() {
            ItemStack bookStack = this.getStackInSlot(0);
            if (EnchantmentHandler.validateBook(bookStack)) {
                EnchantmentHelper.func_82782_a((Map)EnchantmentHelper.func_82781_a((ItemStack)bookStack), (ItemStack)this.jackhammerStack);
            } else {
                EnchantmentHelper.func_82782_a(Collections.emptyMap(), (ItemStack)this.jackhammerStack);
            }
        }

        public static boolean validateBook(ItemStack bookStack) {
            if (bookStack.func_77973_b() == Items.field_151134_bR) {
                Map ench = EnchantmentHelper.func_82781_a((ItemStack)bookStack);
                if (ench.size() != 1) {
                    return false;
                }
                return ench.containsKey(Enchantments.field_185308_t) || ench.containsKey(Enchantments.field_185306_r);
            }
            return false;
        }
    }

    public static class DrillBitHandler
    extends BaseItemStackHandler {
        private static final String NBT_DRILL_BIT = "DrillBit";
        private final ItemStack jackhammerStack;

        public DrillBitHandler(ItemStack jackhammerStack) {
            super(1);
            this.jackhammerStack = jackhammerStack;
            if (jackhammerStack.func_77942_o() && jackhammerStack.func_77978_p().func_150297_b(NBT_DRILL_BIT, 8)) {
                String name = jackhammerStack.func_77978_p().func_74779_i(NBT_DRILL_BIT);
                try {
                    ItemDrillBit.DrillBitType type = ItemDrillBit.DrillBitType.valueOf(name);
                    this.setStackInSlot(0, type.asItemStack());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }

        public boolean isItemValid(int slot, ItemStack itemStack) {
            return itemStack.func_190926_b() || itemStack.func_77973_b() instanceof ItemDrillBit;
        }

        public void save() {
            ItemStack bitStack = this.getStackInSlot(0);
            if (bitStack.func_77973_b() instanceof ItemDrillBit) {
                NBTUtils.setString(this.jackhammerStack, NBT_DRILL_BIT, ((ItemDrillBit)bitStack.func_77973_b()).getType().toString());
            } else {
                NBTUtils.setString(this.jackhammerStack, NBT_DRILL_BIT, ItemDrillBit.DrillBitType.NONE.toString());
            }
        }
    }

    public static enum DigMode {
        MODE_1X1("1x1", 1, ItemDrillBit.DrillBitType.IRON),
        MODE_1X2("1x2", 2, ItemDrillBit.DrillBitType.COMPRESSED_IRON),
        MODE_1X3("1x3", 3, ItemDrillBit.DrillBitType.COMPRESSED_IRON),
        MODE_3X3_CROSS("3x3_cross", 5, ItemDrillBit.DrillBitType.DIAMOND),
        MODE_VEIN("vein", 128, ItemDrillBit.DrillBitType.DIAMOND),
        MODE_3X3_FULL("3x3_full", 9, ItemDrillBit.DrillBitType.NETHERITE),
        MODE_VEIN_PLUS("vein_plus", 128, ItemDrillBit.DrillBitType.NETHERITE);

        private final String name;
        private final int blocksDug;
        private final ItemDrillBit.DrillBitType bitType;

        private DigMode(String name, int blocksDug, ItemDrillBit.DrillBitType bitType) {
            this.name = name;
            this.blocksDug = blocksDug;
            this.bitType = bitType;
        }

        public String getName() {
            return this.name;
        }

        public ItemDrillBit.DrillBitType getBitType() {
            return this.bitType;
        }

        public int getBlocksDug() {
            return this.blocksDug;
        }

        public ResourceLocation getGuiIcon() {
            return Textures.guiIconTexture("gui_" + this.name + ".png");
        }

        public boolean atLeast(DigMode type) {
            return type.ordinal() <= this.ordinal();
        }

        public boolean isVeinMining() {
            return this == MODE_VEIN || this == MODE_VEIN_PLUS;
        }

        public boolean okToVeinMine(BlockState state) {
            switch (this) {
                case MODE_VEIN: {
                    return state.func_235714_a_(PneumaticCraftTags.Blocks.JACKHAMMER_ORES);
                }
                case MODE_VEIN_PLUS: {
                    return true;
                }
            }
            return false;
        }
    }
}

