/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.client.ColorHandlers;
import me.desht.pneumaticcraft.common.XPFluidManager;
import me.desht.pneumaticcraft.common.capabilities.FluidItemWrapper;
import me.desht.pneumaticcraft.common.core.ModFluids;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.item.ILeftClickableItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketLeftClickEmpty;
import me.desht.pneumaticcraft.common.thirdparty.curios.Curios;
import me.desht.pneumaticcraft.common.util.EnchantmentUtils;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

public class ItemMemoryStick
extends Item
implements ColorHandlers.ITintableItem,
ILeftClickableItem {
    private static final String TANK_NAME = "Tank";
    private static final String NBT_ABSORB_ORBS = "AbsorbXPOrbs";
    private static final int XP_FLUID_CAPACITY = 512000;
    private static final int[] TINT_COLORS = new int[]{0xF7FFBF, 0xF2FF99, 15597427, 15269709, 14941990, 14614272};

    public ItemMemoryStick() {
        super(ModItems.defaultProps());
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (!worldIn.field_72995_K) {
            stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(handler -> {
                int ratio = XPFluidManager.getInstance().getXPRatio((Fluid)ModFluids.MEMORY_ESSENCE.get());
                int playerXp = EnchantmentUtils.getPlayerXP(playerIn);
                if (playerIn.func_225608_bj_()) {
                    int xpToGive = EnchantmentUtils.getExperienceForLevel(playerIn.field_71068_ca + 1) - playerXp;
                    int fluidAmount = xpToGive * ratio;
                    FluidStack toDrain = handler.drain(fluidAmount, IFluidHandler.FluidAction.SIMULATE);
                    if (!toDrain.isEmpty()) {
                        EnchantmentUtils.addPlayerXP(playerIn, toDrain.getAmount() / ratio);
                        handler.drain(toDrain.getAmount(), IFluidHandler.FluidAction.EXECUTE);
                        playerIn.func_184611_a(handIn, handler.getContainer());
                    }
                } else if (playerXp > 0) {
                    int xpToTake = playerXp - EnchantmentUtils.getExperienceForLevel(playerIn.field_71068_ca);
                    if (xpToTake == 0) {
                        xpToTake = playerXp - EnchantmentUtils.getExperienceForLevel(playerIn.field_71068_ca - 1);
                    }
                    int fluidAmount = xpToTake * ratio;
                    FluidStack toFill = new FluidStack((Fluid)ModFluids.MEMORY_ESSENCE.get(), fluidAmount);
                    int filled = handler.fill(toFill, IFluidHandler.FluidAction.SIMULATE);
                    if (filled >= ratio) {
                        EnchantmentUtils.addPlayerXP(playerIn, -(filled / ratio));
                        handler.fill(new FluidStack((Fluid)ModFluids.MEMORY_ESSENCE.get(), filled), IFluidHandler.FluidAction.EXECUTE);
                        playerIn.func_184611_a(handIn, handler.getContainer());
                    }
                }
            });
        } else {
            stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(handler -> {
                int amount = handler.getFluidInTank(0).getAmount();
                if (EnchantmentUtils.getPlayerXP(playerIn) > 0 && amount < handler.getTankCapacity(0) && !playerIn.func_225608_bj_() || handler.getFluidInTank(0).getAmount() > 0 && playerIn.func_225608_bj_()) {
                    playerIn.func_184185_a(SoundEvents.field_187604_bf, 0.1f, (worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) * 0.35f + 0.9f);
                }
            });
        }
        return ActionResult.func_226248_a_((Object)stack);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (worldIn != null) {
            stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(handler -> {
                int ratio = XPFluidManager.getInstance().getXPRatio((Fluid)ModFluids.MEMORY_ESSENCE.get());
                FluidStack fluidStack = handler.getFluidInTank(0);
                int amount = fluidStack.getAmount();
                int levels = EnchantmentUtils.getLevelForExperience(amount / ratio);
                tooltip.add((ITextComponent)new TranslationTextComponent("pneumaticcraft.gui.tooltip.memory_stick.xp_stored", new Object[]{amount / ratio, levels}).func_240699_a_(TextFormatting.GREEN));
            });
            boolean absorb = ItemMemoryStick.shouldAbsorbXPOrbs(stack);
            tooltip.add((ITextComponent)new TranslationTextComponent("pneumaticcraft.message.memory_stick.absorb." + absorb).func_240699_a_(TextFormatting.YELLOW));
        }
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).map(handler -> {
            FluidStack fluidStack = handler.getFluidInTank(0);
            return 1.0 - (double)fluidStack.getAmount() / (double)handler.getTankCapacity(0);
        }).orElse(1.0);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        if (this.getClass() == ItemMemoryStick.class) {
            return new FluidItemWrapper(stack, TANK_NAME, 512000, fluid -> fluid == ModFluids.MEMORY_ESSENCE.get());
        }
        return super.initCapabilities(stack, nbt);
    }

    public static boolean shouldAbsorbXPOrbs(ItemStack stack) {
        return stack.func_77973_b() == ModItems.MEMORY_STICK.get() && stack.func_77942_o() && stack.func_77978_p().func_74767_n(NBT_ABSORB_ORBS);
    }

    public static void setAbsorbXPOrbs(ItemStack stack, boolean absorb) {
        if (stack.func_77973_b() == ModItems.MEMORY_STICK.get()) {
            stack.func_196082_o().func_74757_a(NBT_ABSORB_ORBS, absorb);
        }
    }

    @Override
    public int getTintColor(ItemStack stack, int tintIndex) {
        switch (tintIndex) {
            case 1: {
                return stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).map(handler -> {
                    FluidStack fluidStack = handler.getFluidInTank(0);
                    if (fluidStack.isEmpty()) {
                        return 0xFFFFFF;
                    }
                    float f = (float)fluidStack.getAmount() / (float)handler.getTankCapacity(0);
                    return TINT_COLORS[(int)(f * 5.0f)];
                }).orElse(-1);
            }
            case 2: {
                return ItemMemoryStick.shouldAbsorbXPOrbs(stack) ? -16711936 : -8355712;
            }
        }
        return -1;
    }

    @Override
    public void onLeftClickEmpty(ServerPlayerEntity sender) {
        ItemMemoryStick.toggleXPAbsorption((PlayerEntity)sender, sender.func_184614_ca());
    }

    private static void toggleXPAbsorption(PlayerEntity player, ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemMemoryStick) {
            boolean absorb = ItemMemoryStick.shouldAbsorbXPOrbs(stack);
            ItemMemoryStick.setAbsorbXPOrbs(stack, !absorb);
            player.func_146105_b((ITextComponent)new TranslationTextComponent("pneumaticcraft.message.memory_stick.absorb." + !absorb).func_240699_a_(TextFormatting.YELLOW), true);
            player.func_130014_f_().func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_193808_ex, SoundCategory.PLAYERS, 1.0f, absorb ? 1.5f : 2.0f);
        }
    }

    @Mod.EventBusSubscriber
    public static class Listener {
        private static final Map<PlayerEntity, Long> lastEvent = new HashMap<PlayerEntity, Long>();
        private static final Map<PlayerEntity, Pair<String, Integer>> memoryStickCache = new HashMap<PlayerEntity, Pair<String, Integer>>();

        @SubscribeEvent
        public static void onLeftClick(PlayerInteractEvent.LeftClickBlock event) {
            if (event.getItemStack().func_77973_b() instanceof ItemMemoryStick) {
                long last;
                long now;
                if (!event.getWorld().field_72995_K && (now = event.getWorld().func_82737_E()) - (last = lastEvent.getOrDefault(event.getPlayer(), 0L).longValue()) > 5L) {
                    ItemMemoryStick.toggleXPAbsorption(event.getPlayer(), event.getItemStack());
                    lastEvent.put(event.getPlayer(), now);
                }
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onLeftClickEmpty(PlayerInteractEvent.LeftClickEmpty event) {
            if (event.getWorld().field_72995_K && event.getItemStack().func_77973_b() instanceof ItemMemoryStick) {
                NetworkHandler.sendToServer(new PacketLeftClickEmpty());
            }
        }

        @SubscribeEvent
        public static void onXpOrbPickup(PlayerXpEvent.PickupXp event) {
            ItemStack stack = Listener.findMemoryStick(event.getPlayer());
            if (!stack.func_190926_b()) {
                stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(handler -> {
                    if (PneumaticCraftUtils.fillTankWithOrb((IFluidHandler)handler, event.getOrb(), IFluidHandler.FluidAction.EXECUTE)) {
                        stack.func_77982_d(handler.getContainer().func_77978_p());
                        event.getOrb().func_70106_y();
                        event.setCanceled(true);
                    }
                });
            }
        }

        private static ItemStack findMemoryStick(PlayerEntity player) {
            ItemStack stack;
            Pair<String, Integer> p = memoryStickCache.get(player);
            ItemStack itemStack = stack = p == null ? ItemStack.field_190927_a : Listener.getMemoryStick(player, (String)p.getLeft(), (Integer)p.getRight());
            if (!ItemMemoryStick.shouldAbsorbXPOrbs(stack)) {
                memoryStickCache.remove(player);
                for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                    ItemStack stack1 = player.field_71071_by.func_70301_a(i);
                    if (stack1.func_77973_b() != ModItems.MEMORY_STICK.get() || !ItemMemoryStick.shouldAbsorbXPOrbs(stack1)) continue;
                    stack = stack1;
                    memoryStickCache.put(player, (Pair<String, Integer>)Pair.of((Object)"", (Object)i));
                    break;
                }
                if (stack.func_190926_b() && Curios.available) {
                    Pair<String, Integer> p1 = Curios.findStack(player, ItemMemoryStick::shouldAbsorbXPOrbs);
                    if (p1 == Curios.NONE) {
                        stack = ItemStack.field_190927_a;
                    } else {
                        stack = Curios.getStack(player, (String)p1.getKey(), (Integer)p1.getValue());
                        memoryStickCache.put(player, (Pair<String, Integer>)Pair.of((Object)p1.getKey(), (Object)p1.getValue()));
                    }
                }
            }
            return stack;
        }

        @Nonnull
        private static ItemStack getMemoryStick(PlayerEntity player, String inv, int slot) {
            if (inv.isEmpty()) {
                return player.field_71071_by.func_70301_a(slot);
            }
            if (Curios.available) {
                return Curios.getStack(player, inv, slot);
            }
            return ItemStack.field_190927_a;
        }
    }
}

