/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.block.IPneumaticWrenchable;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.item.ItemPressurizable;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemPneumaticWrench
extends ItemPressurizable {
    public ItemPneumaticWrench() {
        super(ModItems.toolProps(), 30000, 3000);
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext ctx) {
        Hand hand = ctx.func_221531_n();
        World world = ctx.func_195991_k();
        BlockPos pos = ctx.func_195995_a();
        if (!world.field_72995_K) {
            BlockState state = world.func_180495_p(pos);
            boolean didWork = stack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).map(h -> {
                float pressure = h.getPressure();
                IPneumaticWrenchable wrenchable = IPneumaticWrenchable.forBlock(state.func_177230_c());
                if (wrenchable != null && pressure > 0.1f) {
                    if (wrenchable.onWrenched(world, ctx.func_195999_j(), pos, ctx.func_196000_l(), hand)) {
                        if (ctx.func_195999_j() != null && !ctx.func_195999_j().func_184812_l_()) {
                            h.addAir(-50);
                        }
                        return true;
                    }
                    return false;
                }
                BlockState rotated = state.func_185907_a(Rotation.CLOCKWISE_90);
                if (rotated != state) {
                    world.func_175656_a(pos, rotated);
                    return true;
                }
                return false;
            }).orElse(false);
            if (didWork) {
                this.playWrenchSound(world, pos);
            }
            return didWork ? ActionResultType.SUCCESS : ActionResultType.PASS;
        }
        return ActionResultType.SUCCESS;
    }

    private void playWrenchSound(World world, BlockPos pos) {
        NetworkHandler.sendToAllAround(new PacketPlaySound((SoundEvent)ModSounds.PNEUMATIC_WRENCH.get(), SoundCategory.PLAYERS, pos, 1.0f, 1.0f, false), world);
    }

    public ActionResultType func_111207_a(ItemStack iStack, PlayerEntity player, LivingEntity target, Hand hand) {
        if (player.field_70170_p.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (target.func_70089_S() && target instanceof IPneumaticWrenchable) {
            return (ActionResultType)iStack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).map(h -> {
                if (!player.func_184812_l_() && h.getAir() < 50) {
                    return ActionResultType.FAIL;
                }
                if (((IPneumaticWrenchable)target).onWrenched(target.field_70170_p, player, null, null, hand)) {
                    if (!player.func_184812_l_()) {
                        h.addAir(-50);
                    }
                    this.playWrenchSound(target.field_70170_p, target.func_233580_cy_());
                    return ActionResultType.SUCCESS;
                }
                return ActionResultType.PASS;
            }).orElseThrow(RuntimeException::new);
        }
        return ActionResultType.PASS;
    }
}

