/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.item.ITagFilteringItem;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.GuiConstants;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemTagFilter
extends Item
implements ITagFilteringItem {
    private static final String NBT_TAG_LIST = "TagList";

    public ItemTagFilter() {
        super(ModItems.defaultProps().func_200917_a(1));
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (worldIn != null) {
            tooltip.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.tag_filter.header", new Object[0]).func_240699_a_(TextFormatting.YELLOW));
            for (ResourceLocation rl : ItemTagFilter.getConfiguredTagList(stack)) {
                tooltip.add((ITextComponent)GuiConstants.bullet().func_240702_b_(rl.toString()).func_240699_a_(TextFormatting.GOLD));
            }
        }
    }

    public static Set<ResourceLocation> getConfiguredTagList(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_74764_b(NBT_TAG_LIST)) {
            ListNBT l = nbt.func_150295_c(NBT_TAG_LIST, 8);
            HashSet<ResourceLocation> res = new HashSet<ResourceLocation>();
            for (int i = 0; i < l.size(); ++i) {
                res.add(new ResourceLocation(l.func_150307_f(i)));
            }
            return res;
        }
        return new HashSet<ResourceLocation>();
    }

    public static void setConfiguredTagList(ItemStack stack, Set<ResourceLocation> tags) {
        ListNBT l = new ListNBT();
        tags.forEach(rl -> l.add((Object)StringNBT.func_229705_a_((String)rl.toString())));
        stack.func_196082_o().func_218657_a(NBT_TAG_LIST, (INBT)l);
    }

    @Override
    public boolean matchTags(ItemStack filterStack, Item item) {
        Set<ResourceLocation> tags = ItemTagFilter.getConfiguredTagList(filterStack);
        return !Sets.intersection(tags, (Set)item.getTags()).isEmpty();
    }
}

