/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.common.network.ILargePayload;
import me.desht.pneumaticcraft.common.network.LocationDoublePacket;
import me.desht.pneumaticcraft.common.network.LocationIntPacket;
import me.desht.pneumaticcraft.common.network.PacketAbstractAmadronTrade;
import me.desht.pneumaticcraft.common.network.PacketAmadronInvSync;
import me.desht.pneumaticcraft.common.network.PacketAmadronOrderUpdate;
import me.desht.pneumaticcraft.common.network.PacketAmadronTradeAddCustom;
import me.desht.pneumaticcraft.common.network.PacketAmadronTradeNotifyDeal;
import me.desht.pneumaticcraft.common.network.PacketAmadronTradeRemoved;
import me.desht.pneumaticcraft.common.network.PacketAphorismTileUpdate;
import me.desht.pneumaticcraft.common.network.PacketChangeGPSToolCoordinate;
import me.desht.pneumaticcraft.common.network.PacketChestplateLauncher;
import me.desht.pneumaticcraft.common.network.PacketClearRecipeCache;
import me.desht.pneumaticcraft.common.network.PacketCommandGetGlobalVariableOutput;
import me.desht.pneumaticcraft.common.network.PacketCoordTrackUpdate;
import me.desht.pneumaticcraft.common.network.PacketDebugBlock;
import me.desht.pneumaticcraft.common.network.PacketDescription;
import me.desht.pneumaticcraft.common.network.PacketDescriptionPacketRequest;
import me.desht.pneumaticcraft.common.network.PacketGuiButton;
import me.desht.pneumaticcraft.common.network.PacketHackingBlockFinish;
import me.desht.pneumaticcraft.common.network.PacketHackingBlockStart;
import me.desht.pneumaticcraft.common.network.PacketHackingEntityFinish;
import me.desht.pneumaticcraft.common.network.PacketHackingEntityStart;
import me.desht.pneumaticcraft.common.network.PacketJetBootsActivate;
import me.desht.pneumaticcraft.common.network.PacketJetBootsStateSync;
import me.desht.pneumaticcraft.common.network.PacketLeftClickEmpty;
import me.desht.pneumaticcraft.common.network.PacketModWrenchBlock;
import me.desht.pneumaticcraft.common.network.PacketMultiHeader;
import me.desht.pneumaticcraft.common.network.PacketMultiPart;
import me.desht.pneumaticcraft.common.network.PacketNotifyVariablesRemote;
import me.desht.pneumaticcraft.common.network.PacketOpenTubeModuleGui;
import me.desht.pneumaticcraft.common.network.PacketPlayMovingSound;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.network.PacketPneumaticKick;
import me.desht.pneumaticcraft.common.network.PacketProgrammerUpdate;
import me.desht.pneumaticcraft.common.network.PacketRenderRangeLines;
import me.desht.pneumaticcraft.common.network.PacketSecurityStation;
import me.desht.pneumaticcraft.common.network.PacketSecurityStationAddHacker;
import me.desht.pneumaticcraft.common.network.PacketSecurityStationAddUser;
import me.desht.pneumaticcraft.common.network.PacketSecurityStationFailedHack;
import me.desht.pneumaticcraft.common.network.PacketSendArmorHUDMessage;
import me.desht.pneumaticcraft.common.network.PacketSendDroneDebugEntry;
import me.desht.pneumaticcraft.common.network.PacketSendNBTPacket;
import me.desht.pneumaticcraft.common.network.PacketServerTickTime;
import me.desht.pneumaticcraft.common.network.PacketSetEntityMotion;
import me.desht.pneumaticcraft.common.network.PacketSetGlobalVariable;
import me.desht.pneumaticcraft.common.network.PacketShowArea;
import me.desht.pneumaticcraft.common.network.PacketShowWireframe;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import me.desht.pneumaticcraft.common.network.PacketSpawnRing;
import me.desht.pneumaticcraft.common.network.PacketSyncAmadronOffers;
import me.desht.pneumaticcraft.common.network.PacketSyncDroneEntityProgWidgets;
import me.desht.pneumaticcraft.common.network.PacketSyncRedstoneModuleToClient;
import me.desht.pneumaticcraft.common.network.PacketSyncRedstoneModuleToServer;
import me.desht.pneumaticcraft.common.network.PacketSyncSemiblock;
import me.desht.pneumaticcraft.common.network.PacketSyncSmartChest;
import me.desht.pneumaticcraft.common.network.PacketToggleArmorFeature;
import me.desht.pneumaticcraft.common.network.PacketTubeModuleColor;
import me.desht.pneumaticcraft.common.network.PacketUpdateAirGrateModule;
import me.desht.pneumaticcraft.common.network.PacketUpdateArmorExtraData;
import me.desht.pneumaticcraft.common.network.PacketUpdateDebuggingDrone;
import me.desht.pneumaticcraft.common.network.PacketUpdateGPSAreaTool;
import me.desht.pneumaticcraft.common.network.PacketUpdateGui;
import me.desht.pneumaticcraft.common.network.PacketUpdateLogisticsModule;
import me.desht.pneumaticcraft.common.network.PacketUpdateMicromissileSettings;
import me.desht.pneumaticcraft.common.network.PacketUpdatePressureBlock;
import me.desht.pneumaticcraft.common.network.PacketUpdatePressureModule;
import me.desht.pneumaticcraft.common.network.PacketUpdateRemoteLayout;
import me.desht.pneumaticcraft.common.network.PacketUpdateSearchItem;
import me.desht.pneumaticcraft.common.network.PacketUpdateTextfield;
import me.desht.pneumaticcraft.common.network.PacketUpdateTubeModule;
import me.desht.pneumaticcraft.common.network.PacketUseItem;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class NetworkHandler {
    private static final String PROTOCOL_VERSION = "1";
    private static final SimpleChannel NETWORK = NetworkRegistry.ChannelBuilder.named((ResourceLocation)PneumaticCraftUtils.RL("main_channel")).clientAcceptedVersions("1"::equals).serverAcceptedVersions("1"::equals).networkProtocolVersion(() -> "1").simpleChannel();
    private static int det = 0;

    private static int nextId() {
        return det++;
    }

    public static void init() {
        NetworkHandler.registerMessage(PacketAphorismTileUpdate.class, PacketAphorismTileUpdate::toBytes, PacketAphorismTileUpdate::new, PacketAphorismTileUpdate::handle);
        NetworkHandler.registerMessage(PacketChangeGPSToolCoordinate.class, PacketChangeGPSToolCoordinate::toBytes, PacketChangeGPSToolCoordinate::new, PacketChangeGPSToolCoordinate::handle);
        NetworkHandler.registerMessage(PacketUpdateGPSAreaTool.class, PacketUpdateGPSAreaTool::toBytes, PacketUpdateGPSAreaTool::new, PacketUpdateGPSAreaTool::handle);
        NetworkHandler.registerMessage(PacketCoordTrackUpdate.class, PacketCoordTrackUpdate::toBytes, PacketCoordTrackUpdate::new, PacketCoordTrackUpdate::handle);
        NetworkHandler.registerMessage(PacketDescription.class, PacketDescription::toBytes, PacketDescription::new, PacketDescription::process);
        NetworkHandler.registerMessage(PacketDescriptionPacketRequest.class, LocationIntPacket::toBytes, PacketDescriptionPacketRequest::new, PacketDescriptionPacketRequest::handle);
        NetworkHandler.registerMessage(PacketGuiButton.class, PacketGuiButton::toBytes, PacketGuiButton::new, PacketGuiButton::handle);
        NetworkHandler.registerMessage(PacketPlaySound.class, PacketPlaySound::toBytes, PacketPlaySound::new, PacketPlaySound::handle);
        NetworkHandler.registerMessage(PacketProgrammerUpdate.class, PacketProgrammerUpdate::toBytes, PacketProgrammerUpdate::new, PacketProgrammerUpdate::handle);
        NetworkHandler.registerMessage(PacketRenderRangeLines.class, LocationIntPacket::toBytes, PacketRenderRangeLines::new, PacketRenderRangeLines::handle);
        NetworkHandler.registerMessage(PacketSecurityStationAddHacker.class, PacketSecurityStation::toBytes, PacketSecurityStationAddHacker::new, PacketSecurityStation::handle);
        NetworkHandler.registerMessage(PacketSecurityStationAddUser.class, PacketSecurityStation::toBytes, PacketSecurityStationAddUser::new, PacketSecurityStation::handle);
        NetworkHandler.registerMessage(PacketSecurityStationFailedHack.class, LocationIntPacket::toBytes, PacketSecurityStationFailedHack::new, PacketSecurityStationFailedHack::handle);
        NetworkHandler.registerMessage(PacketSendNBTPacket.class, PacketSendNBTPacket::toBytes, PacketSendNBTPacket::new, PacketSendNBTPacket::handle);
        NetworkHandler.registerMessage(PacketShowWireframe.class, PacketShowWireframe::toBytes, PacketShowWireframe::new, PacketShowWireframe::handle);
        NetworkHandler.registerMessage(PacketSpawnParticle.class, PacketSpawnParticle::toBytes, PacketSpawnParticle::new, PacketSpawnParticle::handle);
        NetworkHandler.registerMessage(PacketUpdateSearchItem.class, PacketUpdateSearchItem::toBytes, PacketUpdateSearchItem::new, PacketUpdateSearchItem::handle);
        NetworkHandler.registerMessage(PacketUpdateTextfield.class, PacketUpdateTextfield::toBytes, PacketUpdateTextfield::new, PacketUpdateTextfield::handle);
        NetworkHandler.registerMessage(PacketUseItem.class, PacketUseItem::toBytes, PacketUseItem::new, PacketUseItem::handle);
        NetworkHandler.registerMessage(PacketUpdatePressureModule.class, PacketUpdatePressureModule::toBytes, PacketUpdatePressureModule::new, PacketUpdateTubeModule::handle);
        NetworkHandler.registerMessage(PacketUpdateAirGrateModule.class, PacketUpdateAirGrateModule::toBytes, PacketUpdateAirGrateModule::new, PacketUpdateTubeModule::handle);
        NetworkHandler.registerMessage(PacketUpdateGui.class, PacketUpdateGui::toBytes, PacketUpdateGui::new, PacketUpdateGui::handle);
        NetworkHandler.registerMessage(PacketUpdateRemoteLayout.class, PacketUpdateRemoteLayout::toBytes, PacketUpdateRemoteLayout::new, PacketUpdateRemoteLayout::handle);
        NetworkHandler.registerMessage(PacketSetGlobalVariable.class, PacketSetGlobalVariable::toBytes, PacketSetGlobalVariable::new, PacketSetGlobalVariable::handle);
        NetworkHandler.registerMessage(PacketServerTickTime.class, PacketServerTickTime::toBytes, PacketServerTickTime::new, PacketServerTickTime::handle);
        NetworkHandler.registerMessage(PacketUpdatePressureBlock.class, PacketUpdatePressureBlock::toBytes, PacketUpdatePressureBlock::new, PacketUpdatePressureBlock::handle);
        NetworkHandler.registerMessage(PacketSyncAmadronOffers.class, PacketSyncAmadronOffers::toBytes, PacketSyncAmadronOffers::new, PacketSyncAmadronOffers::handle);
        NetworkHandler.registerMessage(PacketAmadronOrderUpdate.class, PacketAmadronOrderUpdate::toBytes, PacketAmadronOrderUpdate::new, PacketAmadronOrderUpdate::handle);
        NetworkHandler.registerMessage(PacketAmadronTradeAddCustom.class, PacketAbstractAmadronTrade::toBytes, PacketAmadronTradeAddCustom::new, PacketAmadronTradeAddCustom::handle);
        NetworkHandler.registerMessage(PacketAmadronTradeNotifyDeal.class, PacketAmadronTradeNotifyDeal::toBytes, PacketAmadronTradeNotifyDeal::new, PacketAmadronTradeNotifyDeal::handle);
        NetworkHandler.registerMessage(PacketAmadronTradeRemoved.class, PacketAbstractAmadronTrade::toBytes, PacketAmadronTradeRemoved::new, PacketAmadronTradeRemoved::handle);
        NetworkHandler.registerMessage(PacketUpdateLogisticsModule.class, PacketUpdateLogisticsModule::toBytes, PacketUpdateLogisticsModule::new, PacketUpdateLogisticsModule::handle);
        NetworkHandler.registerMessage(PacketTubeModuleColor.class, PacketTubeModuleColor::toBytes, PacketTubeModuleColor::new, PacketTubeModuleColor::handle);
        NetworkHandler.registerMessage(PacketSyncRedstoneModuleToClient.class, PacketSyncRedstoneModuleToClient::toBytes, PacketSyncRedstoneModuleToClient::new, PacketSyncRedstoneModuleToClient::handle);
        NetworkHandler.registerMessage(PacketSyncRedstoneModuleToServer.class, PacketSyncRedstoneModuleToServer::toBytes, PacketSyncRedstoneModuleToServer::new, PacketSyncRedstoneModuleToServer::handle);
        NetworkHandler.registerMessage(PacketCommandGetGlobalVariableOutput.class, PacketCommandGetGlobalVariableOutput::toBytes, PacketCommandGetGlobalVariableOutput::new, PacketCommandGetGlobalVariableOutput::handle);
        NetworkHandler.registerMessage(PacketNotifyVariablesRemote.class, PacketNotifyVariablesRemote::toBytes, PacketNotifyVariablesRemote::new, PacketNotifyVariablesRemote::handle);
        NetworkHandler.registerMessage(PacketHackingBlockStart.class, LocationIntPacket::toBytes, PacketHackingBlockStart::new, PacketHackingBlockStart::handle);
        NetworkHandler.registerMessage(PacketHackingBlockFinish.class, LocationIntPacket::toBytes, PacketHackingBlockFinish::new, PacketHackingBlockFinish::handle);
        NetworkHandler.registerMessage(PacketHackingEntityStart.class, PacketHackingEntityStart::toBytes, PacketHackingEntityStart::new, PacketHackingEntityStart::handle);
        NetworkHandler.registerMessage(PacketHackingEntityFinish.class, PacketHackingEntityFinish::toBytes, PacketHackingEntityFinish::new, PacketHackingEntityFinish::handle);
        NetworkHandler.registerMessage(PacketToggleArmorFeature.class, PacketToggleArmorFeature::toBytes, PacketToggleArmorFeature::new, PacketToggleArmorFeature::handle);
        NetworkHandler.registerMessage(PacketUpdateDebuggingDrone.class, PacketUpdateDebuggingDrone::toBytes, PacketUpdateDebuggingDrone::new, PacketUpdateDebuggingDrone::handle);
        NetworkHandler.registerMessage(PacketSendDroneDebugEntry.class, PacketSendDroneDebugEntry::toBytes, PacketSendDroneDebugEntry::new, PacketSendDroneDebugEntry::handle);
        NetworkHandler.registerMessage(PacketSyncDroneEntityProgWidgets.class, PacketSyncDroneEntityProgWidgets::toBytes, PacketSyncDroneEntityProgWidgets::new, PacketSyncDroneEntityProgWidgets::handle);
        NetworkHandler.registerMessage(PacketOpenTubeModuleGui.class, PacketOpenTubeModuleGui::toBytes, PacketOpenTubeModuleGui::new, PacketOpenTubeModuleGui::handle);
        NetworkHandler.registerMessage(PacketSpawnRing.class, PacketSpawnRing::toBytes, PacketSpawnRing::new, PacketSpawnRing::handle);
        NetworkHandler.registerMessage(PacketShowArea.class, PacketShowArea::toBytes, PacketShowArea::new, PacketShowArea::handle);
        NetworkHandler.registerMessage(PacketSetEntityMotion.class, PacketSetEntityMotion::toBytes, PacketSetEntityMotion::new, PacketSetEntityMotion::handle);
        NetworkHandler.registerMessage(PacketDebugBlock.class, LocationIntPacket::toBytes, PacketDebugBlock::new, PacketDebugBlock::handle);
        NetworkHandler.registerMessage(PacketAmadronInvSync.class, PacketAmadronInvSync::toBytes, PacketAmadronInvSync::new, PacketAmadronInvSync::handle);
        NetworkHandler.registerMessage(PacketMultiHeader.class, PacketMultiHeader::toBytes, PacketMultiHeader::new, PacketMultiHeader::handle);
        NetworkHandler.registerMessage(PacketMultiPart.class, PacketMultiPart::toBytes, PacketMultiPart::new, PacketMultiPart::handle);
        NetworkHandler.registerMessage(PacketPneumaticKick.class, PacketPneumaticKick::toBytes, PacketPneumaticKick::new, PacketPneumaticKick::handle);
        NetworkHandler.registerMessage(PacketJetBootsActivate.class, PacketJetBootsActivate::toBytes, PacketJetBootsActivate::new, PacketJetBootsActivate::handle);
        NetworkHandler.registerMessage(PacketPlayMovingSound.class, PacketPlayMovingSound::toBytes, PacketPlayMovingSound::new, PacketPlayMovingSound::handle);
        NetworkHandler.registerMessage(PacketJetBootsStateSync.class, PacketJetBootsStateSync::toBytes, PacketJetBootsStateSync::new, PacketJetBootsStateSync::handle);
        NetworkHandler.registerMessage(PacketModWrenchBlock.class, PacketModWrenchBlock::toBytes, PacketModWrenchBlock::new, PacketModWrenchBlock::handle);
        NetworkHandler.registerMessage(PacketUpdateArmorExtraData.class, PacketUpdateArmorExtraData::toBytes, PacketUpdateArmorExtraData::new, PacketUpdateArmorExtraData::handle);
        NetworkHandler.registerMessage(PacketUpdateMicromissileSettings.class, PacketUpdateMicromissileSettings::toBytes, PacketUpdateMicromissileSettings::new, PacketUpdateMicromissileSettings::handle);
        NetworkHandler.registerMessage(PacketSendArmorHUDMessage.class, PacketSendArmorHUDMessage::toBytes, PacketSendArmorHUDMessage::new, PacketSendArmorHUDMessage::handle);
        NetworkHandler.registerMessage(PacketChestplateLauncher.class, PacketChestplateLauncher::toBytes, PacketChestplateLauncher::new, PacketChestplateLauncher::handle);
        NetworkHandler.registerMessage(PacketSyncSemiblock.class, PacketSyncSemiblock::toBytes, PacketSyncSemiblock::new, PacketSyncSemiblock::handle);
        NetworkHandler.registerMessage(PacketSyncSmartChest.class, PacketSyncSmartChest::toBytes, PacketSyncSmartChest::new, PacketSyncSmartChest::handle);
        NetworkHandler.registerMessage(PacketClearRecipeCache.class, PacketClearRecipeCache::toBytes, PacketClearRecipeCache::new, PacketClearRecipeCache::handle);
        NetworkHandler.registerMessage(PacketLeftClickEmpty.class, PacketLeftClickEmpty::toBytes, PacketLeftClickEmpty::new, PacketLeftClickEmpty::handle);
    }

    public static <MSG> void registerMessage(Class<MSG> messageType, BiConsumer<MSG, PacketBuffer> encoder, Function<PacketBuffer, MSG> decoder, BiConsumer<MSG, Supplier<NetworkEvent.Context>> messageConsumer) {
        NETWORK.registerMessage(NetworkHandler.nextId(), messageType, encoder, decoder, messageConsumer);
    }

    public static void sendToAll(Object message) {
        if (message instanceof ILargePayload) {
            NetworkHandler.getSplitMessages((ILargePayload)message).forEach(part -> NETWORK.send(PacketDistributor.ALL.noArg(), part));
        } else {
            NETWORK.send(PacketDistributor.ALL.noArg(), message);
        }
    }

    public static void sendToPlayer(Object message, ServerPlayerEntity player) {
        if (message instanceof ILargePayload) {
            NetworkHandler.getSplitMessages((ILargePayload)message).forEach(part -> NETWORK.send(PacketDistributor.PLAYER.with(() -> player), part));
        } else {
            NETWORK.send(PacketDistributor.PLAYER.with(() -> player), message);
        }
    }

    public static void sendToAllAround(LocationIntPacket message, World world, double distance) {
        NetworkHandler.sendToAllAround((Object)message, message.getTargetPoint(world, distance));
    }

    public static void sendToAllAround(LocationIntPacket message, World world) {
        NetworkHandler.sendToAllAround((Object)message, message.getTargetPoint(world));
    }

    public static void sendToAllAround(LocationDoublePacket message, World world) {
        NetworkHandler.sendToAllAround((Object)message, message.getTargetPoint(world));
    }

    public static void sendToAllAround(Object message, PacketDistributor.TargetPoint point) {
        if (message instanceof ILargePayload) {
            NetworkHandler.getSplitMessages((ILargePayload)message).forEach(part -> NETWORK.send(PacketDistributor.NEAR.with(() -> point), part));
        } else {
            NETWORK.send(PacketDistributor.NEAR.with(() -> point), message);
        }
    }

    public static void sendToAllTracking(Object message, Entity entity) {
        NETWORK.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), message);
    }

    public static void sendToDimension(Object message, RegistryKey<World> world) {
        if (message instanceof ILargePayload) {
            NetworkHandler.getSplitMessages((ILargePayload)message).forEach(part -> NETWORK.send(PacketDistributor.DIMENSION.with(() -> world), part));
        } else {
            NETWORK.send(PacketDistributor.DIMENSION.with(() -> world), message);
        }
    }

    public static void sendToServer(Object message) {
        if (message instanceof ILargePayload) {
            NetworkHandler.getSplitMessages((ILargePayload)message).forEach(arg_0 -> ((SimpleChannel)NETWORK).sendToServer(arg_0));
        } else {
            NETWORK.sendToServer(message);
        }
    }

    public static void sendNonLocal(Object packet) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            if (server.func_71262_S()) {
                NetworkHandler.sendToAll(packet);
            } else {
                for (ServerPlayerEntity player : server.func_184103_al().func_181057_v()) {
                    if (player.func_146103_bH().getName().equals(player.field_71133_b.func_71214_G())) continue;
                    NetworkHandler.sendToPlayer(packet, player);
                }
            }
        }
    }

    public static void sendNonLocal(ServerPlayerEntity player, Object packet) {
        if (player.field_71133_b.func_71262_S() || !player.func_146103_bH().getName().equals(player.field_71133_b.func_71214_G())) {
            NetworkHandler.sendToPlayer(packet, player);
        }
    }

    private static List<Object> getSplitMessages(ILargePayload message) {
        PacketBuffer buf = message.dumpToBuffer();
        byte[] bytes = buf.array();
        if (buf.writerIndex() < 32000) {
            return Collections.singletonList(message);
        }
        ArrayList<Object> messages = new ArrayList<Object>();
        messages.add(new PacketMultiHeader(buf.writerIndex(), message.getClass().getName()));
        for (int offset = 0; offset < buf.writerIndex(); offset += 32000) {
            messages.add(new PacketMultiPart(Arrays.copyOfRange(bytes, offset, Math.min(offset + 32000, buf.writerIndex()))));
        }
        return messages;
    }
}

