/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.util.ItemLaunching;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.items.ItemHandlerHelper;

public class PacketChestplateLauncher {
    private static final float SCALE_FACTOR = 0.7f;
    private float amount;

    public PacketChestplateLauncher() {
    }

    public PacketChestplateLauncher(float amount) {
        this.amount = amount;
    }

    PacketChestplateLauncher(PacketBuffer buffer) {
        this.amount = buffer.readFloat();
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeFloat(this.amount);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> this.handleLaunch(((NetworkEvent.Context)ctx.get()).getSender()));
        ctx.get().setPacketHandled(true);
    }

    private void handleLaunch(ServerPlayerEntity player) {
        if (player == null) {
            return;
        }
        ItemStack stack = player.func_184592_cb();
        CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer((PlayerEntity)player);
        int upgrades = handler.getUpgradeCount(EquipmentSlotType.CHEST, EnumUpgrade.DISPENSER, 4);
        if (handler.getArmorPressure(EquipmentSlotType.CHEST) > 0.1f && handler.isArmorReady(EquipmentSlotType.CHEST) && upgrades > 0 && !stack.func_190926_b()) {
            ItemStack toFire = player.func_184812_l_() ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1) : stack.func_77979_a(1);
            Entity launchedEntity = ItemLaunching.getEntityToLaunch(player.func_130014_f_(), toFire, (PlayerEntity)player, true, true);
            if (launchedEntity instanceof AbstractArrowEntity) {
                AbstractArrowEntity arrow = (AbstractArrowEntity)launchedEntity;
                arrow.field_70251_a = player.func_184812_l_() ? AbstractArrowEntity.PickupStatus.CREATIVE_ONLY : AbstractArrowEntity.PickupStatus.ALLOWED;
                arrow.func_70239_b(arrow.func_70242_d() + 0.25 * (double)upgrades * (double)this.amount);
            }
            Vector3d velocity = player.func_70040_Z().func_72432_b().func_186678_a((double)(this.amount * (float)upgrades * 0.7f));
            ItemLaunching.launchEntity(launchedEntity, player.func_174824_e(1.0f).func_72441_c(0.0, -0.1, 0.0), velocity, true);
            if (!player.func_184812_l_()) {
                int usedAir = (int)((float)(20 * upgrades) * this.amount);
                handler.addAir(EquipmentSlotType.CHEST, -usedAir);
            }
        }
    }
}

