/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketToggleArmorFeature {
    private byte featureIndex;
    private boolean state;
    private EquipmentSlotType slot;

    public PacketToggleArmorFeature() {
    }

    public PacketToggleArmorFeature(byte featureIndex, boolean state, EquipmentSlotType slot) {
        this.featureIndex = featureIndex;
        this.state = state;
        this.slot = slot;
    }

    PacketToggleArmorFeature(PacketBuffer buffer) {
        this.featureIndex = buffer.readByte();
        this.state = buffer.readBoolean();
        this.slot = EquipmentSlotType.values()[buffer.readByte()];
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeByte((int)this.featureIndex);
        buf.writeBoolean(this.state);
        buf.writeByte(this.slot.ordinal());
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (this.featureIndex >= 0 && this.featureIndex < ArmorUpgradeRegistry.getInstance().getHandlersForSlot(this.slot).size()) {
                CommonArmorHandler.getHandlerForPlayer((PlayerEntity)((NetworkEvent.Context)ctx.get()).getSender()).setUpgradeEnabled(this.slot, this.featureIndex, this.state);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

