/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.network.LocationIntPacket;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketUpdatePressureBlock
extends LocationIntPacket {
    private static final byte NO_DIRECTION = 127;
    private Direction leakDir;
    private Direction handlerDir;
    private int currentAir;

    public PacketUpdatePressureBlock() {
    }

    public PacketUpdatePressureBlock(TileEntity te, Direction handlerDir, Direction leakDir, int currentAir) {
        super(te.func_174877_v());
        this.handlerDir = handlerDir;
        this.leakDir = leakDir;
        this.currentAir = currentAir;
    }

    public PacketUpdatePressureBlock(PacketBuffer buffer) {
        super(buffer);
        this.currentAir = buffer.readInt();
        byte idx = buffer.readByte();
        this.handlerDir = idx >= 0 && idx < 6 ? Direction.func_82600_a((int)idx) : null;
        idx = buffer.readByte();
        this.leakDir = idx >= 0 && idx < 6 ? Direction.func_82600_a((int)idx) : null;
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        super.toBytes(buf);
        buf.writeInt(this.currentAir);
        buf.writeByte(this.handlerDir == null ? 127 : this.handlerDir.func_176745_a());
        buf.writeByte(this.leakDir == null ? 127 : this.leakDir.func_176745_a());
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            TileEntity te = ClientUtils.getClientTE(this.pos);
            if (te != null) {
                te.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY, this.handlerDir).ifPresent(handler -> {
                    handler.setSideLeaking(this.leakDir);
                    handler.addAir(this.currentAir - handler.getAir());
                    if (this.handlerDir != null && te instanceof TileEntityPneumaticBase) {
                        ((TileEntityPneumaticBase)te).initializeHullAirHandler(this.handlerDir, (IAirHandlerMachine)handler);
                    }
                });
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

