/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.common.network.LocationIntPacket;
import me.desht.pneumaticcraft.common.tileentity.IGUITextFieldSensitive;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketUpdateTextfield
extends LocationIntPacket {
    private int textFieldID;
    private String text;

    public PacketUpdateTextfield() {
    }

    public PacketUpdateTextfield(TileEntity te, int textfieldID) {
        super(te.func_174877_v());
        this.textFieldID = textfieldID;
        this.text = ((IGUITextFieldSensitive)te).getText(textfieldID);
    }

    public PacketUpdateTextfield(PacketBuffer buffer) {
        super(buffer);
        this.textFieldID = buffer.readInt();
        this.text = buffer.func_150789_c(Short.MAX_VALUE);
    }

    @Override
    public void toBytes(PacketBuffer buffer) {
        super.toBytes(buffer);
        buffer.writeInt(this.textFieldID);
        buffer.func_180714_a(this.text);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            TileEntity te = ((NetworkEvent.Context)ctx.get()).getSender().func_71121_q().func_175625_s(this.pos);
            if (te instanceof IGUITextFieldSensitive) {
                ((IGUITextFieldSensitive)te).setText(this.textFieldID, this.text);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

