/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets;

import java.util.List;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.drone.IProgWidgetBase;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;

public interface IProgWidget
extends IProgWidgetBase {
    public int getX();

    public int getY();

    public void setX(int var1);

    public void setY(int var1);

    public int getWidth();

    public int getHeight();

    public ResourceLocation getTexture();

    public Pair<Float, Float> getMaxUV();

    public int getTextureSize();

    public void getTooltip(List<ITextComponent> var1);

    public void addWarnings(List<ITextComponent> var1, List<IProgWidget> var2);

    public void addErrors(List<ITextComponent> var1, List<IProgWidget> var2);

    public boolean hasStepInput();

    public boolean hasStepOutput();

    default public boolean freeToUse() {
        return false;
    }

    public Goal getWidgetAI(IDroneBase var1, IProgWidget var2);

    public Goal getWidgetTargetAI(IDroneBase var1, IProgWidget var2);

    public void setOutputWidget(IProgWidget var1);

    public IProgWidget getOutputWidget();

    public IProgWidget getOutputWidget(IDroneBase var1, List<IProgWidget> var2);

    public ProgWidgetType<?> returnType();

    @Nonnull
    public List<ProgWidgetType<?>> getParameters();

    public void setParameter(int var1, IProgWidget var2);

    public boolean canSetParameter(int var1);

    public IProgWidget[] getConnectedParameters();

    public void setParent(IProgWidget var1);

    public IProgWidget getParent();

    public ResourceLocation getTypeID();

    default public String getTranslationKey() {
        String s = this.getTypeID().toString().replace(':', '.');
        return "programmingPuzzle." + s + ".name";
    }

    public DyeColor getColor();

    public boolean isAvailable();

    public void writeToNBT(CompoundNBT var1);

    public void readFromNBT(CompoundNBT var1);

    public IProgWidget copy();

    public boolean canBeRunByComputers(IDroneBase var1, IProgWidget var2);

    public WidgetDifficulty getDifficulty();

    public ProgWidgetType<?> getType();

    public void readFromPacket(PacketBuffer var1);

    public void writeToPacket(PacketBuffer var1);

    public String getExtraStringInfo();

    public static IProgWidget create(ProgWidgetType type) {
        Object base = type.create();
        Validate.isTrue((boolean)(base instanceof IProgWidget));
        return (IProgWidget)base;
    }

    public static enum WidgetDifficulty {
        EASY("easy"),
        MEDIUM("medium"),
        ADVANCED("advanced");

        private final String name;

        private WidgetDifficulty(String name) {
            this.name = name;
        }

        public String getTranslationKey() {
            return I18n.func_135052_a((String)("pneumaticcraft.gui.progWidget.difficulty." + this.name), (Object[])new Object[0]);
        }
    }
}

