/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.ai.DroneAIManager;
import me.desht.pneumaticcraft.common.core.ModProgWidgets;
import me.desht.pneumaticcraft.common.item.ItemGPSTool;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.IVariableWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class ProgWidgetCoordinate
extends ProgWidget
implements IVariableWidget {
    private int x;
    private int y;
    private int z;
    private String variable = "";
    private boolean useVariable;
    private DroneAIManager aiManager;

    public ProgWidgetCoordinate() {
        super(ModProgWidgets.COORDINATE);
    }

    @Override
    public boolean hasStepInput() {
        return false;
    }

    @Override
    public ProgWidgetType<?> returnType() {
        return ModProgWidgets.COORDINATE;
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of(ModProgWidgets.COORDINATE);
    }

    @Override
    public void addWarnings(List<ITextComponent> curInfo, List<IProgWidget> widgets) {
        super.addWarnings(curInfo, widgets);
        if (!this.useVariable && this.x == 0 && this.y == 0 && this.z == 0) {
            curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.coordinate.warning.noCoordinate", new Object[0]));
        }
    }

    @Override
    public void addErrors(List<ITextComponent> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        if (this.useVariable && this.variable.equals("")) {
            curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.general.error.emptyVariable", new Object[0]));
        }
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.GREEN;
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.ADVANCED;
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_COORDINATE;
    }

    @Override
    public void writeToNBT(CompoundNBT tag) {
        super.writeToNBT(tag);
        tag.func_74768_a("posX", this.x);
        tag.func_74768_a("posY", this.y);
        tag.func_74768_a("posZ", this.z);
        tag.func_74778_a("variable", this.variable);
        tag.func_74757_a("useVariable", this.useVariable);
    }

    @Override
    public void readFromNBT(CompoundNBT tag) {
        super.readFromNBT(tag);
        this.x = tag.func_74762_e("posX");
        this.y = tag.func_74762_e("posY");
        this.z = tag.func_74762_e("posZ");
        this.variable = tag.func_74779_i("variable");
        this.useVariable = tag.func_74767_n("useVariable");
    }

    @Override
    public void writeToPacket(PacketBuffer buf) {
        super.writeToPacket(buf);
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.func_180714_a(this.variable);
        buf.writeBoolean(this.useVariable);
    }

    @Override
    public void readFromPacket(PacketBuffer buf) {
        super.readFromPacket(buf);
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.variable = buf.func_150789_c(64);
        this.useVariable = buf.readBoolean();
    }

    @Override
    public void setAIManager(DroneAIManager aiManager) {
        this.aiManager = aiManager;
    }

    public BlockPos getCoordinate() {
        if (this.useVariable) {
            return this.aiManager.getCoordinate(this.variable);
        }
        return this.getRawCoordinate();
    }

    public BlockPos getRawCoordinate() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public void setCoordinate(BlockPos pos) {
        if (pos != null) {
            this.x = pos.func_177958_n();
            this.y = pos.func_177956_o();
            this.z = pos.func_177952_p();
        } else {
            this.z = 0;
            this.y = 0;
            this.x = 0;
        }
    }

    public void setVariable(String varName) {
        this.variable = varName;
    }

    public String getVariable() {
        return this.variable;
    }

    public boolean isUsingVariable() {
        return this.useVariable;
    }

    public void setUsingVariable(boolean useVariable) {
        this.useVariable = useVariable;
    }

    public void loadFromGPSTool(ItemStack gpsTool) {
        String variable = ItemGPSTool.getVariable(gpsTool);
        if ("".equals(variable)) {
            this.setCoordinate(ItemGPSTool.getGPSLocation(gpsTool));
            this.setUsingVariable(false);
        } else {
            this.setVariable("#" + variable);
            this.setUsingVariable(true);
        }
    }

    @Override
    public void getTooltip(List<ITextComponent> curTooltip) {
        super.getTooltip(curTooltip);
        if (this.useVariable) {
            curTooltip.add((ITextComponent)new StringTextComponent("XYZ: '" + this.variable + "'"));
        } else if (this.x != 0 || this.y != 0 || this.z != 0) {
            curTooltip.add((ITextComponent)new StringTextComponent("X: " + this.x + ", Y: " + this.y + ", Z: " + this.z));
        }
    }

    @Override
    public String getExtraStringInfo() {
        if (this.useVariable) {
            return "\"" + this.variable + "\"";
        }
        return this.x != 0 || this.y != 0 || this.z != 0 ? this.x + ", " + this.y + ", " + this.z : null;
    }

    @Override
    public void addVariables(Set<String> variables) {
        variables.add(this.variable);
    }
}

