/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets;

import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.progwidgets.ICondition;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetConditionBase;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;

public abstract class ProgWidgetDroneCondition
extends ProgWidgetConditionBase
implements ICondition {
    private boolean isAndFunction;
    private ICondition.Operator operator = ICondition.Operator.GE;
    private int requiredCount = 1;

    public ProgWidgetDroneCondition(ProgWidgetType<?> type) {
        super(type);
    }

    @Override
    public boolean isAndFunction() {
        return this.isAndFunction;
    }

    @Override
    public void setAndFunction(boolean isAndFunction) {
        this.isAndFunction = isAndFunction;
    }

    @Override
    public boolean evaluate(IDroneBase drone, IProgWidget widget) {
        return this.getOperator().evaluate(this.getCount(drone, widget), this.getRequiredCount());
    }

    protected abstract int getCount(IDroneBase var1, IProgWidget var2);

    @Override
    public Goal getWidgetAI(IDroneBase drone, IProgWidget widget) {
        if (widget instanceof ProgWidgetDroneCondition) {
            return null;
        }
        return new Goal(){

            public boolean func_75250_a() {
                return false;
            }
        };
    }

    @Override
    public int getRequiredCount() {
        return this.requiredCount;
    }

    @Override
    public void setRequiredCount(int count) {
        this.requiredCount = count;
    }

    @Override
    public ICondition.Operator getOperator() {
        return this.operator;
    }

    @Override
    public void setOperator(ICondition.Operator operator) {
        this.operator = operator;
    }

    @Override
    public void writeToNBT(CompoundNBT tag) {
        super.writeToNBT(tag);
        tag.func_74757_a("isAndFunction", this.isAndFunction);
        tag.func_74774_a("operator", (byte)this.operator.ordinal());
        tag.func_74768_a("requiredCount", this.requiredCount);
    }

    @Override
    public void readFromNBT(CompoundNBT tag) {
        super.readFromNBT(tag);
        this.isAndFunction = tag.func_74767_n("isAndFunction");
        this.operator = ICondition.Operator.values()[tag.func_74771_c("operator")];
        this.requiredCount = tag.func_74762_e("requiredCount");
    }

    @Override
    public void writeToPacket(PacketBuffer buf) {
        super.writeToPacket(buf);
        buf.writeBoolean(this.isAndFunction);
        buf.writeByte(this.operator.ordinal());
        buf.func_150787_b(this.requiredCount);
    }

    @Override
    public void readFromPacket(PacketBuffer buf) {
        super.readFromPacket(buf);
        this.isAndFunction = buf.readBoolean();
        this.operator = ICondition.Operator.values()[buf.readByte()];
        this.requiredCount = buf.func_150792_a();
    }

    @Override
    public String getExtraStringInfo() {
        String anyAll = I18n.func_135052_a((String)(this.isAndFunction() ? "pneumaticcraft.gui.progWidget.condition.all" : "pneumaticcraft.gui.progWidget.condition.any"), (Object[])new Object[0]);
        return anyAll + " " + this.getOperator().toString() + " " + this.getRequiredCount();
    }
}

