/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets;

import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.ai.DroneEntityBase;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.core.ModProgWidgets;
import me.desht.pneumaticcraft.common.progwidgets.EntityFilterPair;
import me.desht.pneumaticcraft.common.progwidgets.IAreaProvider;
import me.desht.pneumaticcraft.common.progwidgets.IEntityProvider;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetArea;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetEntityAttack;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;

public class ProgWidgetEntityRightClick
extends ProgWidget
implements IAreaProvider,
IEntityProvider {
    private EntityFilterPair<ProgWidgetEntityRightClick> entityFilters;

    public ProgWidgetEntityRightClick() {
        super(ModProgWidgets.ENTITY_RIGHT_CLICK);
    }

    @Override
    public void addErrors(List<ITextComponent> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        if (this.getConnectedParameters()[0] == null) {
            curInfo.add((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.area.error.noArea", new Object[0]));
        }
        EntityFilterPair.addErrors(this, curInfo);
    }

    @Override
    public boolean hasStepInput() {
        return true;
    }

    @Override
    public ProgWidgetType<?> returnType() {
        return null;
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of(ModProgWidgets.AREA, ModProgWidgets.TEXT);
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.YELLOW;
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.EASY;
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_ENTITY_RIGHT_CLICK;
    }

    @Override
    public Goal getWidgetAI(IDroneBase drone, IProgWidget progWidget) {
        return new DroneEntityBase<IEntityProvider, LivingEntity>(drone, (IEntityProvider)((Object)progWidget)){
            private final Set<Entity> visitedEntities;
            {
                this.visitedEntities = new HashSet<Entity>();
            }

            @Override
            protected boolean isEntityValid(Entity entity) {
                return entity instanceof LivingEntity && !this.visitedEntities.contains(entity);
            }

            @Override
            protected boolean doAction() {
                this.visitedEntities.add(this.targetedEntity);
                ItemStack stack = this.drone.getInv().getStackInSlot(0);
                FakePlayer fakePlayer = this.drone.getFakePlayer();
                if (stack.func_77973_b().func_111207_a(stack, (PlayerEntity)fakePlayer, (LivingEntity)this.targetedEntity, Hand.MAIN_HAND).func_226246_a_() || ((LivingEntity)this.targetedEntity).func_184230_a((PlayerEntity)fakePlayer, Hand.MAIN_HAND).func_226246_a_()) {
                    for (int i = 0; i < fakePlayer.field_71071_by.field_70462_a.size(); ++i) {
                        ItemStack fakePlayerStack = (ItemStack)fakePlayer.field_71071_by.field_70462_a.get(i);
                        if (i < this.drone.getInv().getSlots()) {
                            this.drone.getInv().setStackInSlot(i, fakePlayerStack);
                            continue;
                        }
                        if (fakePlayerStack.func_190926_b()) continue;
                        this.drone.dropItem(fakePlayerStack);
                        fakePlayer.field_71071_by.field_70462_a.set(i, (Object)ItemStack.field_190927_a);
                    }
                }
                return false;
            }
        };
    }

    @Override
    public List<Entity> getValidEntities(World world) {
        if (this.entityFilters == null) {
            this.entityFilters = new EntityFilterPair<ProgWidgetEntityRightClick>(this);
        }
        return this.entityFilters.getValidEntities(world);
    }

    @Override
    public boolean isEntityValid(Entity entity) {
        if (this.entityFilters == null) {
            this.entityFilters = new EntityFilterPair<ProgWidgetEntityRightClick>(this);
        }
        return this.entityFilters.isEntityValid(entity);
    }

    @Override
    public void getArea(Set<BlockPos> area) {
        ProgWidgetEntityAttack.getArea(area, (ProgWidgetArea)this.getConnectedParameters()[0], (ProgWidgetArea)this.getConnectedParameters()[2]);
    }
}

