/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets.area;

import java.util.List;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.common.progwidgets.area.AreaType;
import me.desht.pneumaticcraft.common.util.LegacyAreaWidgetConverter;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;

public class AreaTypePyramid
extends AreaType {
    public static final String ID = "pyramid";
    private AreaType.EnumAxis axis = AreaType.EnumAxis.X;
    private EnumAreaTypePyramid pyramidType = EnumAreaTypePyramid.FILLED;

    public AreaTypePyramid() {
        super(ID);
    }

    @Override
    public void addArea(Consumer<BlockPos> areaAdder, BlockPos p1, BlockPos p2, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        switch (this.axis) {
            case X: {
                if (p2.func_177958_n() == p1.func_177958_n()) break;
                Vector3d lineVec = new Vector3d((double)(p2.func_177958_n() - p1.func_177958_n()), (double)(p2.func_177956_o() - p1.func_177956_o()), (double)(p2.func_177952_p() - p1.func_177952_p())).func_72432_b();
                lineVec = new Vector3d(lineVec.field_72450_a, lineVec.field_72448_b / lineVec.field_72450_a, lineVec.field_72449_c / lineVec.field_72450_a);
                double curY = (double)p1.func_177956_o() - lineVec.field_72448_b;
                int x = p1.func_177958_n() + (p2.func_177958_n() > p1.func_177958_n() ? -1 : 1);
                double curZ = (double)p1.func_177952_p() - lineVec.field_72449_c;
                int prevDY = -1;
                int prevDZ = -1;
                while (x != p2.func_177958_n()) {
                    x += p2.func_177958_n() > p1.func_177958_n() ? 1 : -1;
                    int dY = Math.abs((int)((curY += lineVec.field_72448_b) - (double)p1.func_177956_o()));
                    int dZ = Math.abs((int)((curZ += lineVec.field_72449_c) - (double)p1.func_177952_p()));
                    if (dY == prevDY) {
                        --prevDY;
                    }
                    if (dZ == prevDZ) {
                        --prevDZ;
                    }
                    for (int y = p1.func_177956_o() - dY; y <= p1.func_177956_o() + dY; ++y) {
                        for (int z = p1.func_177952_p() - dZ; z <= p1.func_177952_p() + dZ; ++z) {
                            if (this.pyramidType != EnumAreaTypePyramid.FILLED && x != p2.func_177958_n() && z >= p1.func_177952_p() - prevDZ && z <= p1.func_177952_p() + prevDZ && y >= p1.func_177956_o() - prevDY && y <= p1.func_177956_o() + prevDY) continue;
                            areaAdder.accept(new BlockPos(x, y, z));
                        }
                    }
                    prevDY = dY;
                    prevDZ = dZ;
                }
                break;
            }
            case Y: {
                if (p2.func_177956_o() == p1.func_177956_o()) break;
                Vector3d lineVec = new Vector3d((double)(p2.func_177958_n() - p1.func_177958_n()), (double)(p2.func_177956_o() - p1.func_177956_o()), (double)(p2.func_177952_p() - p1.func_177952_p())).func_72432_b();
                lineVec = new Vector3d(lineVec.field_72450_a / lineVec.field_72448_b, lineVec.field_72448_b, lineVec.field_72449_c / lineVec.field_72448_b);
                double curX = (double)p1.func_177958_n() - lineVec.field_72450_a;
                int y = p1.func_177956_o() + (p2.func_177956_o() > p1.func_177956_o() ? -1 : 1);
                double curZ = (double)p1.func_177952_p() - lineVec.field_72449_c;
                int prevDX = -1;
                int prevDZ = -1;
                while (y != p2.func_177956_o()) {
                    y += p2.func_177956_o() > p1.func_177956_o() ? 1 : -1;
                    int dX = Math.abs((int)((curX += lineVec.field_72450_a) - (double)p1.func_177958_n()));
                    int dZ = Math.abs((int)((curZ += lineVec.field_72449_c) - (double)p1.func_177952_p()));
                    if (dX == prevDX) {
                        --prevDX;
                    }
                    if (dZ == prevDZ) {
                        --prevDZ;
                    }
                    int miniX = p1.func_177958_n() - dX;
                    int maxiX = p1.func_177958_n() + dX;
                    int miniZ = p1.func_177952_p() - dZ;
                    int maxiZ = p1.func_177952_p() + dZ;
                    for (int x = miniX; x <= maxiX; ++x) {
                        for (int z = miniZ; z <= maxiZ; ++z) {
                            if (this.pyramidType != EnumAreaTypePyramid.FILLED && y != p2.func_177956_o() && z >= p1.func_177952_p() - prevDZ && z <= p1.func_177952_p() + prevDZ && x >= p1.func_177958_n() - prevDX && x <= p1.func_177958_n() + prevDX) continue;
                            areaAdder.accept(new BlockPos(x, y, z));
                        }
                    }
                    prevDX = dX;
                    prevDZ = dZ;
                }
                break;
            }
            case Z: {
                if (p2.func_177952_p() == p1.func_177952_p()) break;
                Vector3d lineVec = new Vector3d((double)(p2.func_177958_n() - p1.func_177958_n()), (double)(p2.func_177956_o() - p1.func_177956_o()), (double)(p2.func_177952_p() - p1.func_177952_p())).func_72432_b();
                lineVec = new Vector3d(lineVec.field_72450_a / lineVec.field_72449_c, lineVec.field_72448_b / lineVec.field_72449_c, lineVec.field_72449_c);
                double curX = (double)p1.func_177958_n() - lineVec.field_72450_a;
                int z = p1.func_177952_p() + (p2.func_177952_p() > p1.func_177952_p() ? -1 : 1);
                double curY = (double)p1.func_177956_o() - lineVec.field_72448_b;
                int prevDX = -1;
                int prevDY = -1;
                while (z != p2.func_177952_p()) {
                    z += p2.func_177952_p() > p1.func_177952_p() ? 1 : -1;
                    int dX = Math.abs((int)((curX += lineVec.field_72450_a) - (double)p1.func_177958_n()));
                    int dY = Math.abs((int)((curY += lineVec.field_72448_b) - (double)p1.func_177956_o()));
                    if (dX == prevDX) {
                        --prevDX;
                    }
                    if (dY == prevDY) {
                        --prevDY;
                    }
                    for (int x = p1.func_177958_n() - dX; x <= p1.func_177958_n() + dX; ++x) {
                        for (int y = p1.func_177956_o() - dY; y <= p1.func_177956_o() + dY; ++y) {
                            if (this.pyramidType != EnumAreaTypePyramid.FILLED && z != p2.func_177952_p() && x >= p1.func_177958_n() - prevDX && x <= p1.func_177958_n() + prevDX && y >= p1.func_177956_o() - prevDY && y <= p1.func_177956_o() + prevDY) continue;
                            areaAdder.accept(new BlockPos(x, y, z));
                        }
                    }
                    prevDX = dX;
                    prevDY = dY;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException(this.axis.toString());
            }
        }
    }

    @Override
    public void addUIWidgets(List<AreaType.AreaTypeWidget> widgets) {
        super.addUIWidgets(widgets);
        widgets.add(new AreaType.AreaTypeWidgetEnum<AreaType.EnumAxis>("pneumaticcraft.gui.progWidget.area.type.general.axis", AreaType.EnumAxis.class, () -> this.axis, axis -> {
            this.axis = axis;
        }));
        widgets.add(new AreaType.AreaTypeWidgetEnum<EnumAreaTypePyramid>("pneumaticcraft.gui.progWidget.area.type.pyramid.pyramidType", EnumAreaTypePyramid.class, () -> this.pyramidType, pyramidType -> {
            this.pyramidType = pyramidType;
        }));
    }

    @Override
    public void writeToNBT(CompoundNBT tag) {
        super.writeToNBT(tag);
        tag.func_74774_a("axis", (byte)this.axis.ordinal());
        tag.func_74774_a("pyramidType", (byte)this.pyramidType.ordinal());
    }

    @Override
    public void readFromNBT(CompoundNBT tag) {
        super.readFromNBT(tag);
        this.axis = AreaType.EnumAxis.values()[tag.func_74771_c("axis")];
        this.pyramidType = EnumAreaTypePyramid.values()[tag.func_74771_c("pyramidType")];
    }

    @Override
    public void writeToPacket(PacketBuffer buffer) {
        super.writeToPacket(buffer);
        buffer.writeByte(this.axis.ordinal());
        buffer.writeByte(this.pyramidType.ordinal());
    }

    @Override
    public void readFromPacket(PacketBuffer buf) {
        super.readFromPacket(buf);
        this.axis = AreaType.EnumAxis.values()[buf.readByte()];
        this.pyramidType = EnumAreaTypePyramid.values()[buf.readByte()];
    }

    @Override
    public void convertFromLegacy(LegacyAreaWidgetConverter.EnumOldAreaType oldAreaType, int typeInfo) {
        switch (oldAreaType) {
            case X_PYRAMID: {
                this.axis = AreaType.EnumAxis.X;
                break;
            }
            case Y_PYRAMID: {
                this.axis = AreaType.EnumAxis.Y;
                break;
            }
            case Z_PYRAMID: {
                this.axis = AreaType.EnumAxis.Z;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private static enum EnumAreaTypePyramid {
        FILLED("filled"),
        HOLLOW("hollow");

        private final String name;

        private EnumAreaTypePyramid(String name) {
            this.name = "pneumaticcraft.gui.progWidget.area.type.pyramid.pyramidType." + name;
        }

        public String toString() {
            return I18n.func_135052_a((String)this.name, (Object[])new Object[0]);
        }
    }
}

