/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets.area;

import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.common.progwidgets.area.AreaType;
import me.desht.pneumaticcraft.common.util.LegacyAreaWidgetConverter;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;

public class AreaTypeRandom
extends AreaType {
    public static final String ID = "random";
    private int pickedAmount;

    public AreaTypeRandom() {
        super(ID);
    }

    @Override
    public void addArea(Consumer<BlockPos> areaAdder, BlockPos p1, BlockPos p2, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        int size = (maxX - minX) * (maxY - minY) * (maxZ - minZ);
        if (this.pickedAmount >= size) {
            BlockPos.func_218287_a((int)minX, (int)minY, (int)minZ, (int)maxX, (int)maxY, (int)maxZ).forEach(pos -> areaAdder.accept(pos.func_185334_h()));
        } else {
            Random rand = new Random();
            for (int i = 0; i < this.pickedAmount; ++i) {
                int x = minX + rand.nextInt(maxX - minX);
                int y = minY + rand.nextInt(maxY - minY);
                int z = minZ + rand.nextInt(maxZ - minZ);
                areaAdder.accept(new BlockPos(x, y, z));
            }
        }
    }

    @Override
    public boolean isDeterministic() {
        return false;
    }

    @Override
    public void addUIWidgets(List<AreaType.AreaTypeWidget> widgets) {
        super.addUIWidgets(widgets);
        widgets.add(new AreaType.AreaTypeWidgetInteger("pneumaticcraft.gui.progWidget.area.type.random.blocksSelected", () -> this.pickedAmount, amount -> {
            this.pickedAmount = amount;
        }));
    }

    @Override
    public void writeToNBT(CompoundNBT tag) {
        super.writeToNBT(tag);
        tag.func_74768_a("pickedAmount", this.pickedAmount);
    }

    @Override
    public void readFromNBT(CompoundNBT tag) {
        super.readFromNBT(tag);
        this.pickedAmount = tag.func_74762_e("pickedAmount");
    }

    @Override
    public void writeToPacket(PacketBuffer buffer) {
        super.writeToPacket(buffer);
        buffer.func_150787_b(this.pickedAmount);
    }

    @Override
    public void readFromPacket(PacketBuffer buf) {
        super.readFromPacket(buf);
        this.pickedAmount = buf.func_150792_a();
    }

    @Override
    public void convertFromLegacy(LegacyAreaWidgetConverter.EnumOldAreaType oldAreaType, int typeInfo) {
        this.pickedAmount = typeInfo;
    }
}

