/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.amadron;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.IntStream;
import me.desht.pneumaticcraft.api.crafting.AmadronTradeResource;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.config.subconfig.AmadronPlayerOffers;
import me.desht.pneumaticcraft.common.entity.living.EntityAmadrone;
import me.desht.pneumaticcraft.common.inventory.ContainerAmadron;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSyncAmadronOffers;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronOffer;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronPlayerOffer;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.MerchantOffer;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.exception.ExceptionUtils;

public enum AmadronOfferManager {
    INSTANCE;

    private final List<AmadronOffer> staticOffers = new ArrayList<AmadronOffer>();
    private final Map<Integer, List<AmadronOffer>> periodicOffers = new HashMap<Integer, List<AmadronOffer>>();
    private final Map<String, List<AmadronOffer>> villagerTrades = new HashMap<String, List<AmadronOffer>>();
    private final List<VillagerProfession> validProfessions = new ArrayList<VillagerProfession>();
    private final Map<ResourceLocation, AmadronOffer> allOffers = new HashMap<ResourceLocation, AmadronOffer>();
    private final Map<ResourceLocation, AmadronOffer> activeOffers = new LinkedHashMap<ResourceLocation, AmadronOffer>();

    public static AmadronOfferManager getInstance() {
        return INSTANCE;
    }

    public AmadronOffer getOffer(ResourceLocation offerId) {
        return this.allOffers.get(offerId);
    }

    public Collection<AmadronOffer> getActiveOffers() {
        return this.activeOffers.values();
    }

    public boolean addPlayerOffer(AmadronPlayerOffer offer) {
        if (this.hasSimilarPlayerOffer(offer)) {
            return false;
        }
        if (offer.input.isEmpty() || offer.output.isEmpty()) {
            return false;
        }
        this.getPlayerOffers().put(offer.func_199560_c(), offer);
        this.addOffer(this.activeOffers, offer);
        this.addOffer(this.allOffers, offer);
        this.addOffer(this.allOffers, offer.getReversedOffer());
        NetworkHandler.sendNonLocal(new PacketSyncAmadronOffers());
        this.saveAll();
        return true;
    }

    public boolean removePlayerOffer(AmadronPlayerOffer offer) {
        if (this.getPlayerOffers().remove(offer.func_199560_c()) != null) {
            this.activeOffers.remove(offer.func_199560_c());
            this.allOffers.remove(offer.func_199560_c());
            this.allOffers.remove(AmadronPlayerOffer.getReversedId(offer.func_199560_c()));
            NetworkHandler.sendNonLocal(new PacketSyncAmadronOffers());
            this.saveAll();
            return true;
        }
        return false;
    }

    public boolean hasSimilarPlayerOffer(AmadronPlayerOffer offer) {
        for (AmadronPlayerOffer existing : this.getPlayerOffers().values()) {
            if (!existing.equivalentTo(offer)) continue;
            return true;
        }
        return false;
    }

    private Map<ResourceLocation, AmadronPlayerOffer> getPlayerOffers() {
        return AmadronPlayerOffers.INSTANCE.getPlayerOffers();
    }

    public void syncOffers(Collection<AmadronOffer> newStaticOffers) {
        this.activeOffers.clear();
        newStaticOffers.forEach(offer -> this.addOffer(this.activeOffers, offer));
        Log.info("Received " + this.activeOffers.size() + " active Amadron offers from server", new Object[0]);
    }

    public int countOffers(String playerId) {
        int count = 0;
        for (AmadronOffer offer : this.activeOffers.values()) {
            if (!(offer instanceof AmadronPlayerOffer) || !((AmadronPlayerOffer)offer).getPlayerId().equals(playerId)) continue;
            ++count;
        }
        return count;
    }

    public void tryRestockPlayerOffers() {
        boolean needSave = false;
        for (AmadronPlayerOffer offer : this.getPlayerOffers().values()) {
            EntityAmadrone drone;
            AmadronPlayerOffer reversed = offer.getReversedOffer();
            TileEntity provider = offer.getProvidingTileEntity();
            int possiblePickups = 0;
            switch (offer.getOutput().getType()) {
                case ITEM: {
                    possiblePickups = offer.getOutput().countTradesInInventory(IOHelper.getInventoryForTE(provider));
                    break;
                }
                case FLUID: {
                    possiblePickups = offer.getOutput().countTradesInTank(IOHelper.getFluidHandlerForTE(provider));
                }
            }
            if (possiblePickups > 0 && (drone = ContainerAmadron.retrieveOrderItems(offer.getReversedOffer(), possiblePickups, offer.getProvidingPos(), offer.getProvidingPos())) != null) {
                drone.setHandlingOffer(reversed.func_199560_c(), possiblePickups, ItemStack.field_190927_a, "Restock", EntityAmadrone.AmadronAction.RESTOCKING);
            }
            if (!offer.payout()) continue;
            needSave = true;
        }
        if (needSave) {
            this.saveAll();
        }
    }

    public void initOffers(Map<ResourceLocation, JsonElement> resourceList) {
        this.loadRecipeOffers(resourceList);
        this.setupVillagerTrades();
        this.compileActiveOffersList();
    }

    public void saveAll() {
        AmadronPlayerOffers.save();
    }

    private <T extends AmadronOffer> void addOffer(Map<ResourceLocation, T> map, T offer) {
        map.put(offer.func_199560_c(), offer);
    }

    public void compileActiveOffersList() {
        this.activeOffers.clear();
        this.allOffers.clear();
        this.staticOffers.forEach(offer -> {
            this.addOffer(this.activeOffers, offer);
            this.addOffer(this.allOffers, offer);
        });
        this.periodicOffers.values().forEach(offers -> offers.forEach(offer -> this.addOffer(this.allOffers, offer)));
        this.villagerTrades.values().forEach(offers -> offers.forEach(offer -> this.addOffer(this.allOffers, offer)));
        int nProfessions = this.validProfessions.size() + (this.periodicOffers.isEmpty() ? 0 : 1);
        if (nProfessions > 0) {
            Random rand = new Random();
            for (int i = 0; i < PNCConfig.Common.Amadron.numPeriodicOffers; ++i) {
                AmadronOffer offer2;
                int p = rand.nextInt(nProfessions);
                if (!this.periodicOffers.isEmpty() && p == this.validProfessions.size()) {
                    offer2 = this.pickRandomPeriodicTrade(rand);
                } else {
                    if (p == this.validProfessions.size()) {
                        p = rand.nextInt(this.validProfessions.size());
                    }
                    offer2 = this.pickRandomVillagerTrade(this.validProfessions.get(p), rand);
                }
                if (offer2 == null) continue;
                this.addOffer(this.activeOffers, offer2);
            }
        }
        this.getPlayerOffers().forEach((id, playerOffer) -> {
            this.addOffer(this.activeOffers, playerOffer);
            this.addOffer(this.allOffers, playerOffer);
            this.addOffer(this.allOffers, playerOffer.getReversedOffer());
        });
        NetworkHandler.sendNonLocal(new PacketSyncAmadronOffers());
    }

    private AmadronOffer pickRandomPeriodicTrade(Random rand) {
        int level = this.getWeightedTradeLevel();
        do {
            List<AmadronOffer> offers;
            if ((offers = this.periodicOffers.get(level)) == null || offers.isEmpty()) continue;
            int idx = rand.nextInt(offers.size());
            return offers.get(idx);
        } while (--level > 0);
        Log.debug("Amadron: no periodic offers of level %d or lower", level);
        return null;
    }

    private AmadronOffer pickRandomVillagerTrade(VillagerProfession profession, Random rand) {
        int level = this.getWeightedTradeLevel();
        do {
            String key;
            List<AmadronOffer> offers;
            if ((offers = this.villagerTrades.get(key = profession.toString() + "_" + level)) == null || offers.isEmpty()) continue;
            int idx = rand.nextInt(offers.size());
            return offers.get(idx);
        } while (--level > 0);
        Log.warning("Amadron: failed to find any trades for profession %s ?", profession.toString());
        return null;
    }

    private int getWeightedTradeLevel() {
        int n = new Random().nextInt(100);
        if (n < 50) {
            return 1;
        }
        if (n < 75) {
            return 2;
        }
        if (n < 90) {
            return 3;
        }
        if (n < 97) {
            return 4;
        }
        return 5;
    }

    private void loadRecipeOffers(Map<ResourceLocation, JsonElement> resourceList) {
        this.staticOffers.clear();
        this.periodicOffers.clear();
        resourceList.forEach((id, jsonElement) -> {
            JsonObject json;
            if (jsonElement.isJsonObject() && JSONUtils.func_151219_a((JsonObject)(json = jsonElement.getAsJsonObject()), (String)"type", (String)"").equals("pneumaticcraft:amadron")) {
                try {
                    AmadronOffer offer = AmadronOffer.fromJson(id, json);
                    if (offer.isStaticOffer()) {
                        this.staticOffers.add(offer);
                    } else {
                        this.periodicOffers.computeIfAbsent(offer.getTradeLevel(), l -> new ArrayList()).add(offer);
                    }
                }
                catch (JsonSyntaxException | CommandSyntaxException e) {
                    Log.error("Syntax error for offer id " + id + ": " + e.getMessage(), new Object[0]);
                    Log.error(ExceptionUtils.getStackTrace((Throwable)e), new Object[0]);
                }
            }
        });
    }

    private void setupVillagerTrades() {
        if (this.villagerTrades.isEmpty()) {
            HashSet validSet = new HashSet();
            Random rand = new Random();
            VillagerTrades.field_221239_a.forEach((profession, tradeMap) -> tradeMap.forEach((level, trades) -> IntStream.range(0, ((VillagerTrades.ITrade[])trades).length).forEach(i -> {
                try {
                    String key = profession.toString() + "_" + level;
                    MerchantOffer offer = trades[i].func_221182_a(null, rand);
                    ResourceLocation offerId = new ResourceLocation(profession.toString() + "_" + level + "_" + i);
                    this.villagerTrades.computeIfAbsent(key, k -> new ArrayList()).add(new AmadronOffer(offerId, AmadronTradeResource.of(offer.func_222218_a()), AmadronTradeResource.of(offer.func_222200_d()), false, (int)level));
                    validSet.add(profession);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            })));
            this.validProfessions.addAll(validSet);
        }
    }

    @Mod.EventBusSubscriber(modid="pneumaticcraft")
    public static class EventListener {
        @SubscribeEvent
        public static void serverLogin(PlayerEvent.PlayerLoggedInEvent evt) {
            NetworkHandler.sendNonLocal((ServerPlayerEntity)evt.getPlayer(), new PacketSyncAmadronOffers());
        }
    }

    public static class ReloadListener
    extends JsonReloadListener {
        private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

        public ReloadListener() {
            super(GSON, "recipes");
        }

        protected void apply(Map<ResourceLocation, JsonElement> resourceList, IResourceManager resourceManagerIn, IProfiler profilerIn) {
            AmadronOfferManager.getInstance().initOffers(resourceList);
        }
    }
}

