/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.machine;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.crafting.ingredient.FluidIngredient;
import me.desht.pneumaticcraft.api.crafting.recipe.FluidMixerRecipe;
import me.desht.pneumaticcraft.api.crafting.recipe.PneumaticCraftRecipe;
import me.desht.pneumaticcraft.common.core.ModRecipes;
import me.desht.pneumaticcraft.common.recipes.ModCraftingHelper;
import me.desht.pneumaticcraft.common.recipes.PneumaticCraftRecipeType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class FluidMixerRecipeImpl
extends FluidMixerRecipe {
    private final FluidIngredient input1;
    private final FluidIngredient input2;
    private final FluidStack outputFluid;
    private final ItemStack outputItem;
    private final float pressure;
    private final int processingTime;

    public FluidMixerRecipeImpl(ResourceLocation id, FluidIngredient input1, FluidIngredient input2, FluidStack outputFluid, ItemStack outputItem, float pressure, int processingTime) {
        super(id);
        this.input1 = input1;
        this.input2 = input2;
        this.outputFluid = outputFluid;
        this.outputItem = outputItem;
        this.pressure = pressure;
        this.processingTime = processingTime;
    }

    @Override
    public boolean matches(FluidStack fluid1, FluidStack fluid2) {
        return this.input1.testFluid(fluid1) && this.input2.testFluid(fluid2) || this.input2.testFluid(fluid1) && this.input1.testFluid(fluid2);
    }

    @Override
    public FluidIngredient getInput1() {
        return this.input1;
    }

    @Override
    public FluidIngredient getInput2() {
        return this.input2;
    }

    @Override
    public FluidStack getOutputFluid() {
        return this.outputFluid;
    }

    @Override
    public ItemStack getOutputItem() {
        return this.outputItem;
    }

    @Override
    public int getProcessingTime() {
        return this.processingTime;
    }

    @Override
    public float getRequiredPressure() {
        return this.pressure;
    }

    @Override
    public void write(PacketBuffer buffer) {
        this.input1.func_199564_a(buffer);
        this.input2.func_199564_a(buffer);
        this.outputFluid.writeToPacket(buffer);
        buffer.func_150788_a(this.outputItem);
        buffer.writeFloat(this.pressure);
        buffer.func_150787_b(this.processingTime);
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipes.FLUID_MIXER.get();
    }

    public IRecipeType<?> func_222127_g() {
        return PneumaticCraftRecipeType.FLUID_MIXER;
    }

    public static class Serializer<T extends FluidMixerRecipe>
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<T> {
        private final IFactory<T> factory;

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
        }

        public T read(ResourceLocation recipeId, JsonObject json) {
            Ingredient input1 = FluidIngredient.func_199802_a((JsonElement)json.get("input1"));
            Ingredient input2 = FluidIngredient.func_199802_a((JsonElement)json.get("input2"));
            FluidStack outputFluid = json.has("fluid_output") ? ModCraftingHelper.fluidStackFromJson(json.getAsJsonObject("fluid_output")) : FluidStack.EMPTY;
            ItemStack outputItem = json.has("item_output") ? ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"item_output")) : ItemStack.field_190927_a;
            float pressure = JSONUtils.func_151217_k((JsonObject)json, (String)"pressure");
            int processingTime = JSONUtils.func_151208_a((JsonObject)json, (String)"time", (int)200);
            return this.factory.create(recipeId, (FluidIngredient)input1, (FluidIngredient)input2, outputFluid, outputItem, pressure, processingTime);
        }

        @Nullable
        public T read(ResourceLocation recipeId, PacketBuffer buffer) {
            FluidIngredient input1 = (FluidIngredient)Ingredient.func_199566_b((PacketBuffer)buffer);
            FluidIngredient input2 = (FluidIngredient)Ingredient.func_199566_b((PacketBuffer)buffer);
            FluidStack outputFluid = FluidStack.readFromPacket((PacketBuffer)buffer);
            ItemStack outputItem = buffer.func_150791_c();
            float pressure = buffer.readFloat();
            int processingTime = buffer.func_150792_a();
            return this.factory.create(recipeId, input1, input2, outputFluid, outputItem, pressure, processingTime);
        }

        public void write(PacketBuffer buffer, T recipe) {
            ((PneumaticCraftRecipe)recipe).write(buffer);
        }

        public static interface IFactory<T extends FluidMixerRecipe> {
            public T create(ResourceLocation var1, FluidIngredient var2, FluidIngredient var3, FluidStack var4, ItemStack var5, float var6, int var7);
        }
    }
}

