/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.machine;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.core.ModRecipes;
import me.desht.pneumaticcraft.common.recipes.machine.PressureChamberRecipeImpl;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.IItemHandler;

public class PressureEnchantingRecipe
extends PressureChamberRecipeImpl {
    public static final ResourceLocation ID = PneumaticCraftUtils.RL("pressure_chamber_enchanting");

    public PressureEnchantingRecipe(ResourceLocation id) {
        super(id, Collections.emptyList(), 2.0f, new ItemStack[0]);
    }

    @Override
    public Collection<Integer> findIngredients(@Nonnull IItemHandler chamberHandler) {
        ItemStack stack;
        int i;
        ArrayList<Integer> bookSlots = new ArrayList<Integer>();
        for (i = 0; i < chamberHandler.getSlots(); ++i) {
            stack = chamberHandler.getStackInSlot(i);
            if (stack.func_77973_b() != Items.field_151134_bR) continue;
            bookSlots.add(i);
        }
        for (i = 0; i < chamberHandler.getSlots(); ++i) {
            stack = chamberHandler.getStackInSlot(i);
            if (!stack.func_77956_u() && !stack.func_77948_v()) continue;
            Iterator iterator = bookSlots.iterator();
            while (iterator.hasNext()) {
                int bookSlot = (Integer)iterator.next();
                ItemStack enchantedBook = chamberHandler.getStackInSlot(bookSlot);
                if (!this.isApplicable(enchantedBook, stack)) continue;
                return ImmutableList.of((Object)bookSlot, (Object)i);
            }
        }
        return Collections.emptyList();
    }

    private boolean isApplicable(ItemStack enchantedBook, ItemStack enchantable) {
        Map bookMap = EnchantmentHelper.func_82781_a((ItemStack)enchantedBook);
        for (Map.Entry entry : bookMap.entrySet()) {
            if (!((Enchantment)entry.getKey()).func_92089_a(enchantable) || EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)entry.getKey()), (ItemStack)enchantable) >= (Integer)entry.getValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public NonNullList<ItemStack> craftRecipe(@Nonnull IItemHandler chamberHandler, List<Integer> ingredientSlots) {
        ItemStack enchantedBook = chamberHandler.getStackInSlot(ingredientSlots.get(0).intValue());
        ItemStack enchantable = chamberHandler.getStackInSlot(ingredientSlots.get(1).intValue()).func_77946_l();
        Map bookMap = EnchantmentHelper.func_82781_a((ItemStack)enchantedBook);
        bookMap.forEach((enchantment, level) -> {
            if (enchantment.func_92089_a(enchantable)) {
                enchantable.func_77966_a(enchantment, level.intValue());
            }
        });
        chamberHandler.extractItem(ingredientSlots.get(0).intValue(), 1, false);
        chamberHandler.extractItem(ingredientSlots.get(1).intValue(), 1, false);
        return NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{new ItemStack((IItemProvider)Items.field_151122_aG), enchantable});
    }

    @Override
    public List<Ingredient> getInputsForDisplay() {
        ItemStack enchBook = new ItemStack((IItemProvider)Items.field_151134_bR);
        enchBook.func_77966_a(Enchantments.field_185308_t, 1);
        return ImmutableList.of((Object)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151046_w}), (Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{enchBook}));
    }

    @Override
    public NonNullList<ItemStack> getResultsForDisplay() {
        ItemStack pick = new ItemStack((IItemProvider)Items.field_151046_w);
        pick.func_77966_a(Enchantments.field_185308_t, 1);
        ItemStack book = new ItemStack((IItemProvider)Items.field_151122_aG);
        return NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{pick, book});
    }

    @Override
    public boolean isValidInputItem(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151134_bR || stack.func_77956_u();
    }

    @Override
    public String getTooltipKey(boolean input, int slot) {
        switch (slot) {
            case 0: {
                return "pneumaticcraft.gui.nei.tooltip.pressureEnchantItem";
            }
            case 1: {
                return "pneumaticcraft.gui.nei.tooltip.pressureEnchantBook";
            }
            case 2: {
                return "pneumaticcraft.gui.nei.tooltip.pressureEnchantItemOut";
            }
            case 3: {
                return "pneumaticcraft.gui.nei.tooltip.pressureEnchantBookOut";
            }
        }
        return "";
    }

    @Override
    public void write(PacketBuffer buffer) {
    }

    @Override
    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipes.PRESSURE_CHAMBER_ENCHANTING.get();
    }
}

