/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.item.ItemPneumaticWrench;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.registries.ObjectHolder;

public enum ModdedWrenchUtils {
    INSTANCE;

    @ObjectHolder(value="thermalfoundation:wrench")
    private static Item CRESCENT_HAMMER;
    @ObjectHolder(value="rftools:smartwrench")
    private static Item SMART_WRENCH;
    @ObjectHolder(value="immersiveengineering:hammer")
    private static Item IMMERSIVE_HAMMER;
    @ObjectHolder(value="appliedenergistics2:certus_quartz_wrench")
    private static Item AE2_CERTUS_WRENCH;
    @ObjectHolder(value="appliedenergistics2:nether_quartz_wrench")
    private static Item AE2_NETHER_WRENCH;
    @ObjectHolder(value="enderio:item_yeta_wrench")
    private static Item YETA_WRENCH;
    @ObjectHolder(value="buildcraftcore:wrench")
    private static Item BC_WRENCH;
    @ObjectHolder(value="teslacorelib:wrench")
    private static Item TESLA_WRENCH;
    @ObjectHolder(value="ic2:wrench")
    private static Item IC2_WRENCH;
    @ObjectHolder(value="chiselsandbits:wrench_wood")
    private static Item CB_WRENCH_WOOD;
    @ObjectHolder(value="mekanism:configurator")
    private static Item MEK_CONFIGURATOR;
    private final Set<Item> wrenches = new HashSet<Item>();

    public static ModdedWrenchUtils getInstance() {
        return INSTANCE;
    }

    public void registerThirdPartyWrenches() {
        this.registerWrench(CRESCENT_HAMMER);
        this.registerWrench(SMART_WRENCH);
        this.registerWrench(IMMERSIVE_HAMMER);
        this.registerWrench(AE2_CERTUS_WRENCH);
        this.registerWrench(AE2_NETHER_WRENCH);
        this.registerWrench(YETA_WRENCH);
        this.registerWrench(BC_WRENCH);
        this.registerWrench(TESLA_WRENCH);
        this.registerWrench(IC2_WRENCH);
        this.registerWrench(CB_WRENCH_WOOD);
        this.registerWrench(MEK_CONFIGURATOR);
    }

    private void registerWrench(Item wrench) {
        if (wrench != null) {
            this.wrenches.add(wrench);
        }
    }

    public boolean isModdedWrench(@Nonnull ItemStack stack) {
        return this.wrenches.contains(stack.func_77973_b());
    }

    public boolean isWrench(@Nonnull ItemStack stack) {
        return stack.func_77973_b() instanceof ItemPneumaticWrench || this.isModdedWrench(stack);
    }

    static {
        CRESCENT_HAMMER = null;
        SMART_WRENCH = null;
        IMMERSIVE_HAMMER = null;
        AE2_CERTUS_WRENCH = null;
        AE2_NETHER_WRENCH = null;
        YETA_WRENCH = null;
        BC_WRENCH = null;
        TESLA_WRENCH = null;
        IC2_WRENCH = null;
        CB_WRENCH_WOOD = null;
        MEK_CONFIGURATOR = null;
    }
}

