/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.computercraft;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IDynamicPeripheral;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.common.thirdparty.computer_common.ComputerEventManager;
import me.desht.pneumaticcraft.common.tileentity.ILuaMethodProvider;
import net.minecraft.tileentity.TileEntity;

public class PneumaticTilePeripheral
implements IDynamicPeripheral,
ComputerEventManager.IComputerEventSender {
    private final ILuaMethodProvider provider;
    private final CopyOnWriteArrayList<IComputerAccess> attachedComputers = new CopyOnWriteArrayList();

    PneumaticTilePeripheral(ILuaMethodProvider provider) {
        this.provider = provider;
    }

    @Nonnull
    public String[] getMethodNames() {
        return this.provider.getLuaMethodRegistry().getMethodNames();
    }

    @Nonnull
    public MethodResult callMethod(@Nonnull IComputerAccess computer, @Nonnull ILuaContext ctx, int method, @Nonnull IArguments args) throws LuaException {
        try {
            return MethodResult.of((Object[])this.provider.getLuaMethodRegistry().getMethod(method).call(args.getAll()));
        }
        catch (Exception e) {
            throw new LuaException(e.getMessage());
        }
    }

    @Nonnull
    public String getType() {
        return this.provider.getPeripheralType();
    }

    public boolean equals(@Nullable IPeripheral other) {
        return this == other;
    }

    public void attach(@Nonnull IComputerAccess computer) {
        this.attachedComputers.add(computer);
    }

    public void detach(@Nonnull IComputerAccess computer) {
        this.attachedComputers.remove(computer);
    }

    @Override
    public void sendEvent(TileEntity te, String name, Object ... params) {
        this.attachedComputers.forEach(a -> a.queueEvent(name, params));
    }
}

