/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.mekanism;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.thirdparty.mekanism.Mekanism;
import mekanism.api.heat.IHeatHandler;
import mekanism.api.heat.ISidedHeatHandler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class PNC2MekHeatProvider
implements ICapabilityProvider {
    private final List<LazyOptional<IHeatHandler>> handlers = new ArrayList<LazyOptional<IHeatHandler>>();
    private final WeakReference<TileEntity> teRef;

    public PNC2MekHeatProvider(TileEntity te) {
        this.teRef = new WeakReference<TileEntity>(te);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        LazyOptional heatExchanger;
        int idx;
        if (cap != Mekanism.CAPABILITY_HEAT_HANDLER || this.teRef.get() == null || !((TileEntity)this.teRef.get()).getCapability(PNCCapabilities.HEAT_EXCHANGER_CAPABILITY, side).isPresent()) {
            return LazyOptional.empty();
        }
        if (this.handlers.isEmpty()) {
            for (int i = 0; i < 7; ++i) {
                this.handlers.add((LazyOptional<IHeatHandler>)LazyOptional.empty());
            }
        }
        int n = idx = side == null ? 6 : side.func_176745_a();
        if (!this.handlers.get(idx).isPresent() && (heatExchanger = ((TileEntity)this.teRef.get()).getCapability(PNCCapabilities.HEAT_EXCHANGER_CAPABILITY, side)).isPresent()) {
            heatExchanger.addListener(l -> this.handlers.set(idx, (LazyOptional<IHeatHandler>)LazyOptional.empty()));
            PNC2MekHeatAdapter adapter = new PNC2MekHeatAdapter(side, (LazyOptional<IHeatExchangerLogic>)heatExchanger);
            this.handlers.set(idx, (LazyOptional<IHeatHandler>)LazyOptional.of(() -> adapter));
        }
        return this.handlers.get(idx);
    }

    public static class PNC2MekHeatAdapter
    implements ISidedHeatHandler {
        private final Direction side;
        private final LazyOptional<IHeatExchangerLogic> heatExchanger;

        public PNC2MekHeatAdapter(Direction side, LazyOptional<IHeatExchangerLogic> heatExchanger) {
            this.side = side;
            this.heatExchanger = heatExchanger;
        }

        @Nullable
        public Direction getHeatSideFor() {
            return this.side;
        }

        public int getHeatCapacitorCount(@Nullable Direction direction) {
            return this.heatExchanger.isPresent() ? 1 : 0;
        }

        public double getTemperature(int i, @Nullable Direction direction) {
            return this.heatExchanger.map(IHeatExchangerLogic::getTemperature).orElse(0.0);
        }

        public double getInverseConduction(int i, @Nullable Direction direction) {
            return this.heatExchanger.map(h -> h.getThermalResistance() * PNCConfig.Common.Integration.mekThermalResistanceFactor).orElse(1.0);
        }

        public double getHeatCapacity(int i, @Nullable Direction direction) {
            return this.heatExchanger.map(IHeatExchangerLogic::getThermalCapacity).orElse(0.0);
        }

        public void handleHeat(int i, double amount, @Nullable Direction direction) {
            this.heatExchanger.ifPresent(h -> h.addHeat(amount * PNCConfig.Common.Integration.mekThermalEfficiencyFactor));
        }
    }
}

