/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.patchouli;

import me.desht.pneumaticcraft.api.crafting.recipe.PressureChamberRecipe;
import me.desht.pneumaticcraft.common.recipes.PneumaticCraftRecipeType;
import me.desht.pneumaticcraft.common.thirdparty.patchouli.Patchouli;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class ProcessorPressureChamber
implements IComponentProcessor {
    private PressureChamberRecipe recipe = null;

    public void setup(IVariableProvider iVariableProvider) {
        ResourceLocation recipeId = new ResourceLocation(iVariableProvider.get("recipe").asString());
        this.recipe = PneumaticCraftRecipeType.PRESSURE_CHAMBER.getRecipe((World)Minecraft.func_71410_x().field_71441_e, recipeId);
    }

    public IVariable process(String s) {
        if (this.recipe == null) {
            return null;
        }
        if (s.startsWith("input")) {
            int index = Integer.parseInt(s.substring(5)) - 1;
            if (index >= 0 && index < this.recipe.getInputsForDisplay().size()) {
                return Patchouli.Util.getStacks(this.recipe.getInputsForDisplay().get(index));
            }
        } else if (s.startsWith("output")) {
            int index = Integer.parseInt(s.substring(6)) - 1;
            if (index >= 0 && index < this.recipe.getResultsForDisplay().size()) {
                return IVariable.from((Object)this.recipe.getResultsForDisplay().get(index));
            }
        } else if (s.equals("pressure")) {
            String pr = PneumaticCraftUtils.roundNumberTo(this.recipe.getCraftingPressure(), 1);
            return IVariable.wrap((String)I18n.func_135052_a((String)"pneumaticcraft.patchouli.processor.pressureChamber.desc", (Object[])new Object[]{pr}));
        }
        return null;
    }
}

