/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.patchouli;

import me.desht.pneumaticcraft.api.crafting.TemperatureRange;
import me.desht.pneumaticcraft.api.crafting.recipe.ThermoPlantRecipe;
import me.desht.pneumaticcraft.common.recipes.PneumaticCraftRecipeType;
import me.desht.pneumaticcraft.common.thirdparty.patchouli.Patchouli;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class ProcessorThermoPlant
implements IComponentProcessor {
    private ThermoPlantRecipe recipe = null;
    private String header = null;

    public void setup(IVariableProvider iVariableProvider) {
        ResourceLocation recipeId = new ResourceLocation(iVariableProvider.get("recipe").asString());
        this.recipe = PneumaticCraftRecipeType.THERMO_PLANT.getRecipe((World)Minecraft.func_71410_x().field_71441_e, recipeId);
        this.header = iVariableProvider.has("header") ? iVariableProvider.get("header").asString() : "";
    }

    public IVariable process(String s) {
        switch (s) {
            case "header": {
                return IVariable.wrap((String)(this.header.isEmpty() ? this.defaultHeader() : this.header));
            }
            case "item_input": {
                return Patchouli.Util.getStacks(this.recipe.getInputItem());
            }
            case "fluid_input": {
                return Patchouli.Util.getFluidStacks(this.recipe.getInputFluid());
            }
            case "item_output": {
                return IVariable.from((Object)this.recipe.getOutputItem());
            }
            case "fluid_output": {
                return IVariable.from((Object)this.recipe.getOutputFluid());
            }
            case "text": {
                String pr = PneumaticCraftUtils.roundNumberTo(this.recipe.getRequiredPressure(), 1);
                String temp = this.recipe.getOperatingTemperature().asString(TemperatureRange.TemperatureScale.CELSIUS);
                return IVariable.wrap((String)I18n.func_135052_a((String)"pneumaticcraft.patchouli.processor.thermoPlant.desc", (Object[])new Object[]{pr, temp}));
            }
            case "scale": {
                return IVariable.wrap((Number)this.getScale(this.recipe));
            }
        }
        return null;
    }

    private int getScale(ThermoPlantRecipe recipe) {
        int in = recipe.getInputFluid().getAmount();
        int out = recipe.getOutputFluid().getAmount();
        if (in >= 4000 || out >= 4000) {
            return 16000;
        }
        return 2 * Math.max(in, out);
    }

    private String defaultHeader() {
        if (!this.recipe.getOutputFluid().isEmpty()) {
            return this.recipe.getOutputFluid().getDisplayName().getString();
        }
        if (!this.recipe.getOutputItem().func_190926_b()) {
            return this.recipe.getOutputItem().func_200301_q().getString();
        }
        return "";
    }
}

