/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.theoneprobe;

import com.mojang.blaze3d.matrix.MatrixStack;
import io.netty.buffer.ByteBuf;
import mcjty.theoneprobe.api.IElement;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import me.desht.pneumaticcraft.client.render.pressure_gauge.PressureGaugeRenderer2D;
import me.desht.pneumaticcraft.common.thirdparty.theoneprobe.TheOneProbe;
import me.desht.pneumaticcraft.common.tileentity.IMinWorkingPressure;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;

public class ElementPressure
implements IElement {
    private final float min;
    private final float pressure;
    private final float danger;
    private final float crit;
    private static final float SCALE = 0.7f;

    ElementPressure(TileEntity te, IAirHandlerMachine airHandler) {
        this.min = te instanceof IMinWorkingPressure ? ((IMinWorkingPressure)te).getMinWorkingPressure() : 0.0f;
        this.pressure = airHandler.getPressure();
        this.danger = airHandler.getDangerPressure();
        this.crit = airHandler.getCriticalPressure();
    }

    ElementPressure(ByteBuf byteBuf) {
        this.min = byteBuf.readFloat();
        this.pressure = byteBuf.readFloat();
        this.danger = byteBuf.readFloat();
        this.crit = byteBuf.readFloat();
    }

    public void render(MatrixStack matrixStack, int x, int y) {
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(0.7f, 0.7f, 0.7f);
        int x1 = (int)((float)(x + this.getWidth() / 2) / 0.7f);
        int y1 = (int)((float)(y + this.getHeight() / 2) / 0.7f);
        PressureGaugeRenderer2D.drawPressureGauge(matrixStack, Minecraft.func_71410_x().field_71466_p, -1.0f, this.crit, this.danger, this.min, this.pressure, x1, y1, -4144960);
        matrixStack.func_227865_b_();
    }

    public int getWidth() {
        return 40;
    }

    public int getHeight() {
        return 40;
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeFloat(this.min);
        buf.writeFloat(this.pressure);
        buf.writeFloat(this.danger);
        buf.writeFloat(this.crit);
    }

    public int getID() {
        return TheOneProbe.elementPressure;
    }
}

