/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.LazySynced;
import me.desht.pneumaticcraft.common.recipes.PneumaticCraftRecipeType;
import me.desht.pneumaticcraft.common.recipes.assembly.AssemblyProgram;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAssemblyPlatform;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAssemblyRobot;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.items.IItemHandler;

public class TileEntityAssemblyDrill
extends TileEntityAssemblyRobot {
    @DescSynced
    private boolean isDrillOn;
    @DescSynced
    @LazySynced
    private float drillSpeed;
    public float drillRotation;
    public float oldDrillRotation;
    private int drillStep;

    public TileEntityAssemblyDrill() {
        super((TileEntityType)ModTileEntities.ASSEMBLY_DRILL.get());
    }

    @Override
    public void func_73660_a() {
        this.oldDrillRotation = this.drillRotation;
        super.func_73660_a();
        this.drillSpeed = this.isDrillOn ? Math.min(this.drillSpeed + 1.0f * this.speed, 100.0f) : Math.max(this.drillSpeed - 1.0f, 0.0f);
        this.drillRotation += this.drillSpeed;
        while (this.drillRotation >= 360.0f) {
            this.drillRotation -= 360.0f;
        }
        if (!this.func_145831_w().field_72995_K && this.drillStep > 0) {
            Direction[] platformDirection = this.getPlatformDirection();
            if (platformDirection == null) {
                this.drillStep = 1;
            }
            switch (this.drillStep) {
                case 1: 
                case 6: {
                    this.slowMode = false;
                    this.gotoHomePosition();
                    break;
                }
                case 2: {
                    this.hoverOverNeighbour(platformDirection[0], platformDirection[1]);
                    break;
                }
                case 3: {
                    this.isDrillOn = true;
                    break;
                }
                case 4: {
                    this.slowMode = true;
                    this.gotoNeighbour(platformDirection[0], platformDirection[1]);
                    break;
                }
                case 5: {
                    TileEntityAssemblyPlatform platform;
                    ItemStack output;
                    this.hoverOverNeighbour(platformDirection[0], platformDirection[1]);
                    this.isDrillOn = false;
                    TileEntity te = this.getTileEntityForCurrentDirection();
                    if (!(te instanceof TileEntityAssemblyPlatform) || (output = this.getDrilledOutputForItem((platform = (TileEntityAssemblyPlatform)te).getHeldStack())).func_190926_b()) break;
                    platform.setHeldStack(output);
                }
            }
            if (this.isDoneInternal()) {
                ++this.drillStep;
                if (this.drillStep > 6) {
                    this.drillStep = 0;
                }
            }
        }
    }

    public void goDrilling() {
        if (this.drillStep == 0) {
            this.drillStep = 1;
            this.func_70296_d();
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_74757_a("drill", this.isDrillOn);
        tag.func_74776_a("drillSpeed", this.drillSpeed);
        tag.func_74768_a("drillStep", this.drillStep);
        return tag;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.isDrillOn = tag.func_74767_n("drill");
        this.drillSpeed = tag.func_74760_g("drillSpeed");
        this.drillStep = tag.func_74762_e("drillStep");
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return null;
    }

    @Override
    public boolean isIdle() {
        return this.drillStep == 0 && this.isDoneInternal();
    }

    @Override
    public AssemblyProgram.EnumMachine getAssemblyType() {
        return AssemblyProgram.EnumMachine.DRILL;
    }

    private boolean isDoneInternal() {
        if (super.isDoneMoving()) {
            return this.isDrillOn ? this.drillSpeed > 99.0f : PneumaticCraftUtils.areFloatsEqual(this.drillSpeed, 0.0f);
        }
        return false;
    }

    @Override
    public boolean canMoveToDiagonalNeighbours() {
        return false;
    }

    private ItemStack getDrilledOutputForItem(ItemStack input) {
        return PneumaticCraftRecipeType.ASSEMBLY_DRILL.stream(this.field_145850_b).filter(recipe -> recipe.matches(input)).findFirst().map(recipe -> recipe.getOutput().func_77946_l()).orElse(ItemStack.field_190927_a);
    }

    @Override
    public boolean reset() {
        if (this.isIdle()) {
            return true;
        }
        this.isDrillOn = false;
        this.drillStep = 6;
        return false;
    }
}

