/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.recipes.PneumaticCraftRecipeType;
import me.desht.pneumaticcraft.common.recipes.assembly.AssemblyProgram;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAssemblyPlatform;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAssemblyRobot;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.items.IItemHandler;

public class TileEntityAssemblyLaser
extends TileEntityAssemblyRobot {
    @DescSynced
    public boolean isLaserOn;
    private int laserStep;
    private static final float ITEM_SIZE = 10.0f;

    public TileEntityAssemblyLaser() {
        super((TileEntityType)ModTileEntities.ASSEMBLY_LASER.get());
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.laserStep > 0) {
            Direction[] platformDirection = this.getPlatformDirection();
            if (platformDirection == null) {
                this.laserStep = 105;
            }
            switch (this.laserStep) {
                case 1: {
                    this.slowMode = false;
                    break;
                }
                case 2: {
                    this.hoverOverNeighbour(platformDirection[0], platformDirection[1]);
                    break;
                }
                case 3: {
                    this.slowMode = true;
                    this.gotoNeighbour(platformDirection[0], platformDirection[1]);
                    break;
                }
                case 104: {
                    TileEntityAssemblyPlatform platform;
                    ItemStack output;
                    this.hoverOverNeighbour(platformDirection[0], platformDirection[1]);
                    this.isLaserOn = false;
                    this.slowMode = true;
                    TileEntity te = this.getTileEntityForCurrentDirection();
                    if (!(te instanceof TileEntityAssemblyPlatform) || (output = this.getLaseredOutputForItem((platform = (TileEntityAssemblyPlatform)te).getHeldStack())).func_190926_b()) break;
                    platform.setHeldStack(output);
                    break;
                }
                case 105: {
                    this.slowMode = false;
                    this.isLaserOn = false;
                    this.gotoHomePosition();
                    break;
                }
                default: {
                    this.isLaserOn = true;
                    this.slowMode = false;
                    this.targetAngles[TileEntityAssemblyRobot.EnumAngles.BASE.ordinal()] = 100.0f - (float)PneumaticCraftUtils.sin[(this.laserStep - 4) * 500 / 100] * 10.0f;
                    this.targetAngles[TileEntityAssemblyRobot.EnumAngles.MIDDLE.ordinal()] = -10.0f + (float)PneumaticCraftUtils.sin[(this.laserStep - 4) * 500 / 100] * 10.0f;
                    this.targetAngles[TileEntityAssemblyRobot.EnumAngles.TAIL.ordinal()] = 0.0f;
                    int n = TileEntityAssemblyRobot.EnumAngles.TURN.ordinal();
                    this.targetAngles[n] = (float)((double)this.targetAngles[n] + (double)((float)PneumaticCraftUtils.sin[(this.laserStep - 4) * 500 / 100] * 10.0f) * 0.03);
                }
            }
            if (this.isDoneInternal() || this.laserStep >= 4 && this.laserStep <= 103) {
                ++this.laserStep;
                if (this.laserStep > 105) {
                    this.laserStep = 0;
                }
            }
        }
    }

    public void startLasering() {
        if (this.laserStep == 0) {
            this.laserStep = 1;
        }
    }

    @Override
    public boolean gotoNeighbour(Direction primaryDir, Direction secondaryDir) {
        boolean diagonal = super.gotoNeighbour(primaryDir, secondaryDir);
        int n = TileEntityAssemblyRobot.EnumAngles.TURN.ordinal();
        this.targetAngles[n] = (float)((double)this.targetAngles[n] - 4.5);
        return diagonal;
    }

    private boolean isDoneInternal() {
        return super.isDoneMoving();
    }

    @Override
    public boolean isIdle() {
        return this.laserStep == 0 && this.isDoneInternal();
    }

    @Override
    public AssemblyProgram.EnumMachine getAssemblyType() {
        return AssemblyProgram.EnumMachine.LASER;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_74757_a("laser", this.isLaserOn);
        tag.func_74768_a("laserStep", this.laserStep);
        return tag;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.isLaserOn = tag.func_74767_n("laser");
        this.laserStep = tag.func_74762_e("laserStep");
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return null;
    }

    @Override
    public boolean canMoveToDiagonalNeighbours() {
        return false;
    }

    @Nonnull
    private ItemStack getLaseredOutputForItem(ItemStack input) {
        return PneumaticCraftRecipeType.ASSEMBLY_LASER.stream(this.field_145850_b).filter(recipe -> recipe.matches(input)).findFirst().map(recipe -> recipe.getOutput().func_77946_l()).orElse(ItemStack.field_190927_a);
    }

    @Override
    public boolean reset() {
        if (this.isIdle()) {
            return true;
        }
        this.isLaserOn = false;
        this.laserStep = 105;
        return false;
    }
}

