/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.common.block.BlockElectrostaticCompressor;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.inventory.ContainerElectrostaticCompressor;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControl;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ObjectHolder;

public class TileEntityElectrostaticCompressor
extends TileEntityPneumaticBase
implements IRedstoneControl,
INamedContainerProvider {
    @ObjectHolder(value="chisel:ironpane")
    private static Block CHISELED_BARS = null;
    private static final List<String> REDSTONE_LABELS = ImmutableList.of((Object)"pneumaticcraft.gui.tab.redstoneBehaviour.button.never", (Object)"pneumaticcraft.gui.tab.redstoneBehaviour.electrostaticCompressor.button.struckByLightning");
    private static final int MAX_ELECTROSTATIC_GRID_SIZE = 250;
    private static final int MAX_BARS_ABOVE = 10;
    private boolean lastRedstoneState;
    @GuiSynced
    public int redstoneMode = 0;
    public int ironBarsBeneath = 0;
    public int ironBarsAbove = 0;
    private int struckByLightningCooldown;

    public TileEntityElectrostaticCompressor() {
        super((TileEntityType)ModTileEntities.ELECTROSTATIC_COMPRESSOR.get(), 20.0f, 25.0f, 50000, 4);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if ((this.func_145831_w().func_82737_E() & 0x1FL) == 0L) {
            int max = 20;
            this.ironBarsBeneath = 0;
            while (this.ironBarsBeneath < max && TileEntityElectrostaticCompressor.isValidGridBlock(this.func_145831_w().func_180495_p(this.func_174877_v().func_177979_c(this.ironBarsBeneath + 1)).func_177230_c())) {
                ++this.ironBarsBeneath;
            }
            this.ironBarsAbove = 0;
            while (this.ironBarsAbove < 10 && TileEntityElectrostaticCompressor.isValidGridBlock(this.func_145831_w().func_180495_p(this.func_174877_v().func_177981_b(this.ironBarsAbove + 1)).func_177230_c())) {
                ++this.ironBarsAbove;
            }
        }
        if (!this.func_145831_w().field_72995_K) {
            this.maybeLightningStrike();
            if (this.lastRedstoneState != this.shouldEmitRedstone()) {
                this.lastRedstoneState = !this.lastRedstoneState;
                this.updateNeighbours();
            }
            --this.struckByLightningCooldown;
        }
    }

    public int getStrikeChance() {
        int strikeChance = PNCConfig.Common.Machines.electrostaticLightningChance;
        if (this.func_145831_w().func_72896_J()) {
            strikeChance = (int)((double)strikeChance * 0.5);
        }
        if (this.func_145831_w().func_72911_I()) {
            strikeChance = (int)((double)strikeChance * 0.2);
        }
        strikeChance = (int)((float)strikeChance * (1.0f - 0.02f * (float)this.ironBarsAbove));
        return strikeChance;
    }

    private void maybeLightningStrike() {
        Random rnd = this.func_145831_w().field_73012_v;
        if (rnd.nextInt(this.getStrikeChance()) == 0) {
            int dist = rnd.nextInt(6);
            float angle = rnd.nextFloat() * (float)Math.PI * 2.0f;
            int x = (int)((float)this.func_174877_v().func_177958_n() + (float)dist * MathHelper.func_76126_a((float)angle));
            int z = (int)((float)this.func_174877_v().func_177952_p() + (float)dist * MathHelper.func_76134_b((float)angle));
            for (int y = this.func_174877_v().func_177956_o() + 5; y > this.func_174877_v().func_177956_o() - 5; --y) {
                BlockPos hitPos = new BlockPos(x, y, z);
                BlockState state = this.func_145831_w().func_180495_p(hitPos);
                if (!(state.func_177230_c() instanceof BlockElectrostaticCompressor) && state.func_177230_c() != Blocks.field_150411_aY) continue;
                HashSet<BlockPos> posSet = new HashSet<BlockPos>();
                this.getElectrostaticGrid(posSet, this.func_145831_w(), hitPos, null);
                List compressors = posSet.stream().filter(pos -> this.field_145850_b.func_180495_p(pos).func_177230_c() == ModBlocks.ELECTROSTATIC_COMPRESSOR.get()).map(pos -> this.field_145850_b.func_175625_s(pos)).filter(te -> te instanceof TileEntityElectrostaticCompressor).map(te -> (TileEntityElectrostaticCompressor)te).collect(Collectors.toList());
                LightningBoltEntity bolt = new LightningBoltEntity(EntityType.field_200728_aG, this.func_145831_w());
                bolt.func_70107_b((double)x, (double)y, (double)z);
                this.func_145831_w().func_217376_c((Entity)bolt);
                for (TileEntityElectrostaticCompressor compressor : compressors) {
                    compressor.addAir(200000 / compressors.size());
                    compressor.onStruckByLightning();
                }
                AxisAlignedBB box = new AxisAlignedBB(this.func_174877_v()).func_72314_b(16.0, 16.0, 16.0);
                for (LivingEntity entity : this.func_145831_w().func_175647_a(LivingEntity.class, box, EntityPredicates.field_94557_a)) {
                    BlockPos pos2 = entity.func_233580_cy_();
                    if (!posSet.contains(pos2) && !posSet.contains(pos2.func_177977_b()) || ForgeEventFactory.onEntityStruckByLightning((Entity)entity, (LightningBoltEntity)bolt)) continue;
                    entity.func_241841_a((ServerWorld)this.func_145831_w(), bolt);
                }
                break;
            }
        }
    }

    @Override
    public boolean canConnectPneumatic(Direction dir) {
        return dir != Direction.UP;
    }

    private boolean shouldEmitRedstone() {
        switch (this.redstoneMode) {
            case 0: {
                return false;
            }
            case 1: {
                return this.struckByLightningCooldown > 0;
            }
        }
        return false;
    }

    public void onStruckByLightning() {
        this.struckByLightningCooldown = 10;
        if (this.getPressure() > 20.0f) {
            int maxRedirection = 10000 * this.ironBarsBeneath;
            int tooMuchAir = (int)((this.getPressure() - 20.0f) * (float)this.airHandler.getVolume());
            this.addAir(-Math.min(maxRedirection, tooMuchAir));
        }
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, PlayerEntity player) {
        if (tag.equals("redstone")) {
            ++this.redstoneMode;
            if (this.redstoneMode > 1) {
                this.redstoneMode = 0;
            }
        }
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return null;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.redstoneMode = tag.func_74762_e("redstoneMode");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbtTagCompound) {
        super.func_189515_b(nbtTagCompound);
        nbtTagCompound.func_74768_a("redstoneMode", this.redstoneMode);
        return nbtTagCompound;
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    protected List<String> getRedstoneButtonLabels() {
        return REDSTONE_LABELS;
    }

    public void getElectrostaticGrid(Set<BlockPos> set, World world, BlockPos pos, Direction dir) {
        for (Direction d : Direction.field_199792_n) {
            BlockPos newPos;
            Block block;
            if (d == dir || !TileEntityElectrostaticCompressor.isValidGridBlock(block = world.func_180495_p(newPos = pos.func_177972_a(d)).func_177230_c()) && block != ModBlocks.ELECTROSTATIC_COMPRESSOR.get() || set.size() >= 250 || !set.add(newPos)) continue;
            this.getElectrostaticGrid(set, world, newPos, d.func_176734_d());
        }
    }

    private static boolean isValidGridBlock(Block block) {
        return block == Blocks.field_150411_aY || block == CHISELED_BARS;
    }

    public ITextComponent func_145748_c_() {
        return this.getDisplayNameInternal();
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerElectrostaticCompressor(i, playerInventory, this.func_174877_v());
    }
}

