/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import me.desht.pneumaticcraft.common.block.BlockElevatorCaller;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.tileentity.ICamouflageableTE;
import me.desht.pneumaticcraft.common.tileentity.TileEntityTickableBase;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.items.IItemHandler;

public class TileEntityElevatorCaller
extends TileEntityTickableBase
implements ICamouflageableTE {
    private ElevatorButton[] floors = new ElevatorButton[0];
    private int thisFloor;
    private boolean emittingRedstone;
    private boolean shouldUpdateNeighbors;
    private BlockState camoState;

    public TileEntityElevatorCaller() {
        super((TileEntityType)ModTileEntities.ELEVATOR_CALLER.get());
    }

    public void setEmittingRedstone(boolean emittingRedstone) {
        if (emittingRedstone != this.emittingRedstone) {
            this.emittingRedstone = emittingRedstone;
            this.shouldUpdateNeighbors = true;
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.shouldUpdateNeighbors) {
            this.updateNeighbours();
            this.shouldUpdateNeighbors = false;
        }
    }

    public boolean getEmittingRedstone() {
        return this.emittingRedstone;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.emittingRedstone = tag.func_74767_n("emittingRedstone");
        this.thisFloor = tag.func_74762_e("thisFloor");
        this.shouldUpdateNeighbors = tag.func_74767_n("shouldUpdateNeighbors");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_74757_a("emittingRedstone", this.emittingRedstone);
        tag.func_74768_a("thisFloor", this.thisFloor);
        tag.func_74757_a("shouldUpdateNeighbors", this.shouldUpdateNeighbors);
        return tag;
    }

    @Override
    public void readFromPacket(CompoundNBT tag) {
        super.readFromPacket(tag);
        int floorAmount = tag.func_74762_e("floors");
        this.floors = new ElevatorButton[floorAmount];
        for (int i = 0; i < floorAmount; ++i) {
            this.floors[i] = new ElevatorButton(tag.func_74775_l("floor" + i));
        }
        this.camoState = ICamouflageableTE.readCamo(tag);
    }

    @Override
    public void writeToPacket(CompoundNBT tag) {
        super.writeToPacket(tag);
        tag.func_74768_a("floors", this.floors.length);
        for (ElevatorButton floor : this.floors) {
            tag.func_218657_a("floor" + floor.floorNumber, (INBT)floor.writeToNBT(new CompoundNBT()));
        }
        ICamouflageableTE.writeCamo(tag, this.camoState);
    }

    @Override
    public void onNeighborBlockUpdate() {
        boolean wasPowered = this.poweredRedstone > 0;
        super.onNeighborBlockUpdate();
        if (this.poweredRedstone > 0 && !wasPowered) {
            BlockElevatorCaller.setSurroundingElevators(this.func_145831_w(), this.func_174877_v(), this.thisFloor);
        }
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return null;
    }

    void setFloors(ElevatorButton[] floors, int thisFloorLevel) {
        this.floors = floors;
        this.thisFloor = thisFloorLevel;
        this.sendDescriptionPacket();
    }

    public ElevatorButton[] getFloors() {
        return this.floors;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)(this.func_174877_v().func_177958_n() + 1), (double)(this.func_174877_v().func_177956_o() + 1), (double)(this.func_174877_v().func_177952_p() + 1));
    }

    @Override
    public BlockState getCamouflage() {
        return this.camoState;
    }

    @Override
    public void setCamouflage(BlockState state) {
        this.camoState = state;
        ICamouflageableTE.syncToClient(this);
    }

    public static class ElevatorButton {
        public final float posX;
        public final float posY;
        public final float width;
        public final float height;
        public final int floorNumber;
        public final int floorHeight;
        public float red;
        public float green;
        public float blue;
        public String buttonText;

        ElevatorButton(float posX, float posY, float width, float height, int floorNumber, int floorHeight) {
            this.posX = posX;
            this.posY = posY;
            this.width = width;
            this.height = height;
            this.floorNumber = floorNumber;
            this.floorHeight = floorHeight;
            this.buttonText = floorNumber + 1 + "";
        }

        ElevatorButton(CompoundNBT tag) {
            this.posX = tag.func_74760_g("posX");
            this.posY = tag.func_74760_g("posY");
            this.width = tag.func_74760_g("width");
            this.height = tag.func_74760_g("height");
            this.buttonText = tag.func_74779_i("buttonText");
            this.floorNumber = tag.func_74762_e("floorNumber");
            this.floorHeight = tag.func_74762_e("floorHeight");
            this.red = tag.func_74760_g("red");
            this.green = tag.func_74760_g("green");
            this.blue = tag.func_74760_g("blue");
        }

        void setColor(float red, float green, float blue) {
            this.red = red;
            this.green = green;
            this.blue = blue;
        }

        public CompoundNBT writeToNBT(CompoundNBT tag) {
            tag.func_74776_a("posX", this.posX);
            tag.func_74776_a("posY", this.posY);
            tag.func_74776_a("width", this.width);
            tag.func_74776_a("height", this.height);
            tag.func_74778_a("buttonText", this.buttonText);
            tag.func_74768_a("floorNumber", this.floorNumber);
            tag.func_74768_a("floorHeight", this.floorHeight);
            tag.func_74776_a("red", this.red);
            tag.func_74776_a("green", this.green);
            tag.func_74776_a("blue", this.blue);
            return tag;
        }
    }
}

