/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import java.util.function.BiPredicate;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.common.block.BlockPneumaticCraft;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.tileentity.ICamouflageableTE;
import me.desht.pneumaticcraft.common.tileentity.TileEntityTickableBase;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class TileEntityHeatPipe
extends TileEntityTickableBase
implements ICamouflageableTE {
    private final IHeatExchangerLogic heatExchanger = PneumaticRegistry.getInstance().getHeatRegistry().makeHeatExchangerLogic();
    private final LazyOptional<IHeatExchangerLogic> heatCap = LazyOptional.of(() -> this.heatExchanger);
    private BlockState camoState;

    public TileEntityHeatPipe() {
        super((TileEntityType)ModTileEntities.HEAT_PIPE.get());
        this.heatExchanger.setThermalResistance(0.01);
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return null;
    }

    @Override
    public LazyOptional<IHeatExchangerLogic> getHeatCap(Direction side) {
        return this.heatCap;
    }

    @Override
    protected BiPredicate<IWorld, BlockPos> heatExchangerBlockFilter() {
        return (world, pos) -> !world.func_175623_d(pos) && !(world.func_180495_p(pos).func_177230_c() instanceof FlowingFluidBlock);
    }

    @Override
    public void onNeighborBlockUpdate() {
        super.onNeighborBlockUpdate();
        BlockState state = this.func_195044_w();
        boolean changed = false;
        for (Direction dir : Direction.field_199792_n) {
            BooleanProperty prop = BlockPneumaticCraft.connectionProperty(dir);
            boolean connected = this.heatExchanger.isSideConnected(dir);
            if ((Boolean)state.func_177229_b((Property)prop) == connected) continue;
            state = (BlockState)state.func_206870_a((Property)prop, (Comparable)Boolean.valueOf(connected));
            changed = true;
        }
        if (changed) {
            this.field_145850_b.func_175656_a(this.field_174879_c, state);
        }
    }

    @Override
    public void writeToPacket(CompoundNBT tag) {
        super.writeToPacket(tag);
        ICamouflageableTE.writeCamo(tag, this.camoState);
    }

    @Override
    public void readFromPacket(CompoundNBT tag) {
        super.readFromPacket(tag);
        this.camoState = ICamouflageableTE.readCamo(tag);
    }

    @Override
    public BlockState getCamouflage() {
        return this.camoState;
    }

    @Override
    public void setCamouflage(BlockState state) {
        this.camoState = state;
        ICamouflageableTE.syncToClient(this);
    }
}

