/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.inventory.ContainerOmnidirectionalHopper;
import me.desht.pneumaticcraft.common.inventory.handler.ComparatorItemStackHandler;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAbstractHopper;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.BlockState;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileEntityOmnidirectionalHopper
extends TileEntityAbstractHopper {
    public static final int INVENTORY_SIZE = 5;
    private final ComparatorItemStackHandler itemHandler = new ComparatorItemStackHandler(this, this.getInvSize());
    private final LazyOptional<IItemHandler> invCap = LazyOptional.of(() -> this.itemHandler);
    @GuiSynced
    public boolean roundRobin;
    private int rrSlot;

    public TileEntityOmnidirectionalHopper() {
        super((TileEntityType)ModTileEntities.OMNIDIRECTIONAL_HOPPER.get());
    }

    protected int getInvSize() {
        return 5;
    }

    @Override
    protected LazyOptional<IItemHandler> getInventoryCap() {
        return this.invCap;
    }

    @Override
    protected int getComparatorValueInternal() {
        return this.itemHandler.getComparatorValue();
    }

    @Override
    protected boolean doExport(int maxItems) {
        Direction outputDir = this.getRotation();
        LazyOptional<IItemHandler> inv = IOHelper.getInventoryForTE(this.getCachedNeighbor(outputDir), outputDir.func_176734_d());
        int notExported = inv.isPresent() ? inv.map(h -> this.exportToInventory((IItemHandler)h, maxItems)).orElse(maxItems) : (PNCConfig.Common.Machines.omniHopperDispenser && this.getUpgrades(EnumUpgrade.DISPENSER) > 0 ? this.exportToInventory(new DropInWorldHandler(this.func_145831_w(), this.func_174877_v(), outputDir), maxItems) : maxItems);
        return notExported < maxItems;
    }

    private int exportToInventory(IItemHandler otherHandler, int maxItems) {
        int remaining = maxItems;
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(this.actualSlot(i));
            if (stack.func_190916_E() <= this.leaveMaterialCount) continue;
            ItemStack exportedStack = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)Math.min(stack.func_190916_E() - this.leaveMaterialCount, remaining));
            int toExport = exportedStack.func_190916_E();
            ItemStack excess = ItemHandlerHelper.insertItem((IItemHandler)otherHandler, (ItemStack)exportedStack, (boolean)false);
            int exportedCount = toExport - excess.func_190916_E();
            if (!this.isCreative) {
                stack.func_190918_g(exportedCount);
                if (exportedCount > 0) {
                    this.itemHandler.invalidateComparatorValue();
                }
            }
            if ((remaining -= exportedCount) > this.leaveMaterialCount) continue;
            if (!this.roundRobin) break;
            this.rrSlot = this.actualSlot(i) + 1;
            if (this.rrSlot < this.itemHandler.getSlots()) break;
            this.rrSlot = 0;
            break;
        }
        return remaining;
    }

    private int actualSlot(int i) {
        if (this.roundRobin) {
            int slot = this.rrSlot + i;
            if (slot >= this.itemHandler.getSlots()) {
                slot -= this.itemHandler.getSlots();
            }
            return slot;
        }
        return i;
    }

    @Override
    protected boolean doImport(int maxItems) {
        boolean success = false;
        if (this.isInventoryFull()) {
            return false;
        }
        Direction inputDir = this.getInputDirection();
        LazyOptional<IItemHandler> cap = IOHelper.getInventoryForTE(this.getCachedNeighbor(inputDir), inputDir.func_176734_d());
        if (cap.isPresent()) {
            return cap.map(otherHandler -> {
                int remaining = maxItems;
                for (int i = 0; i < otherHandler.getSlots(); ++i) {
                    if (otherHandler.getStackInSlot(i).func_190926_b()) continue;
                    ItemStack toExtract = otherHandler.extractItem(i, remaining, true);
                    ItemStack excess = ItemHandlerHelper.insertItemStacked((IItemHandler)this.itemHandler, (ItemStack)toExtract, (boolean)false);
                    int transferred = toExtract.func_190916_E() - excess.func_190916_E();
                    if (transferred <= 0) continue;
                    otherHandler.extractItem(i, transferred, false);
                    if ((remaining -= transferred) > 0) continue;
                    return true;
                }
                return remaining < maxItems;
            }).orElse(false);
        }
        BlockPos inputPos = this.field_174879_c.func_177972_a(inputDir);
        if (!PneumaticCraftUtils.blockHasSolidSide(this.field_145850_b.func_180495_p(inputPos), (IBlockReader)this.field_145850_b, inputPos, inputDir.func_176734_d())) {
            for (ItemEntity entity : this.getNeighborItems(this.inputAABB)) {
                ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)this.itemHandler, (ItemStack)entity.func_92059_d(), (boolean)false);
                if (remainder.func_190926_b()) {
                    entity.func_70106_y();
                    success = true;
                    continue;
                }
                if (remainder.func_190916_E() >= entity.func_92059_d().func_190916_E()) continue;
                entity.func_92058_a(remainder);
                success = true;
            }
        }
        return success;
    }

    private boolean isInventoryFull() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (!stack.func_190926_b() && stack.func_190916_E() >= stack.func_77976_d()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getItemTransferInterval() {
        return 8 / (1 << this.getUpgrades(EnumUpgrade.SPEED));
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_218657_a("Items", (INBT)this.itemHandler.serializeNBT());
        tag.func_74757_a("RoundRobin", this.roundRobin);
        if (this.roundRobin) {
            tag.func_74768_a("RRSlot", this.rrSlot);
        }
        return tag;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.itemHandler.deserializeNBT(tag.func_74775_l("Items"));
        this.roundRobin = tag.func_74767_n("RoundRobin");
        this.rrSlot = tag.func_74762_e("RRSlot");
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return this.itemHandler;
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerOmnidirectionalHopper(i, playerInventory, this.func_174877_v());
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, PlayerEntity player) {
        if (tag.equals("rr")) {
            this.roundRobin = !this.roundRobin;
            this.func_70296_d();
        } else {
            super.handleGUIButtonPress(tag, shiftHeld, player);
        }
    }

    private static class DropInWorldHandler
    implements IItemHandler {
        private final World world;
        private final BlockPos pos;
        private final Direction outputDir;

        public DropInWorldHandler(World world, BlockPos pos, Direction outputDir) {
            this.world = world;
            this.pos = pos.func_177972_a(outputDir);
            this.outputDir = outputDir;
        }

        public int getSlots() {
            return 1;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return ItemStack.field_190927_a;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!PneumaticCraftUtils.blockHasSolidSide(this.world.func_180495_p(this.pos), (IBlockReader)this.world, this.pos, this.outputDir.func_176734_d())) {
                if (!simulate) {
                    PneumaticCraftUtils.dropItemOnGroundPrecisely(stack, this.world, (double)this.pos.func_177958_n() + 0.5, (double)this.pos.func_177956_o() + 0.5, (double)this.pos.func_177952_p() + 0.5);
                }
                return ItemStack.field_190927_a;
            }
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return true;
        }
    }
}

