/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.thirdparty.computer_common.LuaConstant;
import me.desht.pneumaticcraft.common.thirdparty.computer_common.LuaMethod;
import me.desht.pneumaticcraft.common.thirdparty.computer_common.LuaMethodRegistry;
import me.desht.pneumaticcraft.common.tileentity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.tileentity.TileEntityTickableBase;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public abstract class TileEntityPneumaticBase
extends TileEntityTickableBase {
    @GuiSynced
    final IAirHandlerMachine airHandler;
    private final LazyOptional<IAirHandlerMachine> airHandlerCap;
    public final float dangerPressure;
    public final float criticalPressure;
    private final int defaultVolume;
    private final Map<IAirHandlerMachine, List<Direction>> airHandlerMap = new HashMap<IAirHandlerMachine, List<Direction>>();

    public TileEntityPneumaticBase(TileEntityType type, float dangerPressure, float criticalPressure, int volume, int upgradeSlots) {
        super(type, upgradeSlots);
        this.airHandler = PneumaticRegistry.getInstance().getAirHandlerMachineFactory().createAirHandler(dangerPressure, criticalPressure, volume);
        this.airHandlerCap = LazyOptional.of(() -> this.airHandler);
        this.dangerPressure = dangerPressure;
        this.criticalPressure = criticalPressure;
        this.defaultVolume = volume;
    }

    @Override
    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        this.initializeHullAirHandlers();
    }

    @Override
    protected void onFirstServerTick() {
        super.onFirstServerTick();
        this.initializeHullAirHandlers();
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.airHandlerMap.keySet().forEach(handler -> handler.tick(this));
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.airHandlerMap.forEach((handler, sides) -> {
            if (!sides.isEmpty()) {
                this.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY, (Direction)sides.get(0)).invalidate();
            }
        });
    }

    @Override
    public void onUpgradesChanged() {
        super.onUpgradesChanged();
        this.airHandler.setVolumeUpgrades(this.getUpgrades(EnumUpgrade.VOLUME));
        this.airHandler.setHasSecurityUpgrade(this.getUpgrades(EnumUpgrade.SECURITY) > 0);
        this.airHandlerMap.keySet().forEach(h -> {
            h.setVolumeUpgrades(this.getUpgrades(EnumUpgrade.VOLUME));
            h.setHasSecurityUpgrade(this.getUpgrades(EnumUpgrade.SECURITY) > 0);
        });
    }

    @Override
    public void onBlockRotated() {
        super.onBlockRotated();
        this.initializeHullAirHandlers();
        this.airHandlerMap.keySet().forEach(h -> h.setSideLeaking(null));
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY) {
            return side == null || this.canConnectPneumatic(side) ? PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY.orEmpty(cap, this.airHandlerCap) : LazyOptional.empty();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_218657_a("AirHandler", this.airHandler.serializeNBT());
        return tag;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.airHandler.deserializeNBT(tag.func_74775_l("AirHandler"));
        if (tag.func_74764_b("AirAmount")) {
            this.airHandler.addAir(tag.func_74762_e("AirAmount"));
        }
    }

    public void initializeHullAirHandlers() {
        this.airHandlerMap.clear();
        for (Direction side : Direction.field_199792_n) {
            this.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY, side).ifPresent(handler -> this.airHandlerMap.computeIfAbsent((IAirHandlerMachine)handler, k -> new ArrayList()).add(side));
        }
        this.airHandlerMap.forEach(IAirHandlerMachine::setConnectedFaces);
    }

    public void initializeHullAirHandler(Direction dir, IAirHandlerMachine handler) {
        this.airHandlerMap.clear();
        List<Direction> l = Collections.singletonList(dir);
        this.airHandlerMap.put(handler, l);
        handler.setConnectedFaces(l);
    }

    @Override
    public void onNeighborBlockUpdate() {
        super.onNeighborBlockUpdate();
        this.initializeHullAirHandlers();
    }

    @Override
    public void writeToPacket(CompoundNBT tag) {
        super.writeToPacket(tag);
        tag.func_218657_a("AirHandler", this.airHandler.serializeNBT());
    }

    @Override
    public void readFromPacket(CompoundNBT tag) {
        super.readFromPacket(tag);
        this.airHandler.deserializeNBT(tag.func_74775_l("AirHandler"));
    }

    @Override
    public void addLuaMethods(LuaMethodRegistry registry) {
        super.addLuaMethods(registry);
        registry.registerLuaMethod(new LuaMethod("getPressure"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 0, 1, "face (down/up/north/south/west/east)");
                if (args.length == 0) {
                    return new Object[]{Float.valueOf(TileEntityPneumaticBase.this.airHandler.getPressure())};
                }
                LazyOptional<IAirHandlerMachine> cap = TileEntityPneumaticBase.this.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY, this.getDirForString((String)args[0]));
                return new Object[]{cap.map(IAirHandler::getPressure).orElse(Float.valueOf(0.0f))};
            }
        });
        if (this instanceof IMinWorkingPressure) {
            final IMinWorkingPressure mwp = (IMinWorkingPressure)((Object)this);
            registry.registerLuaMethod(new LuaMethod("getMinWorkingPressure"){

                @Override
                public Object[] call(Object[] args) {
                    this.requireNoArgs(args);
                    return new Object[]{Float.valueOf(mwp.getMinWorkingPressure())};
                }
            });
        }
        registry.registerLuaMethod(new LuaConstant("getDangerPressure", this.dangerPressure));
        registry.registerLuaMethod(new LuaConstant("getCriticalPressure", this.criticalPressure));
        registry.registerLuaMethod(new LuaConstant("getDefaultVolume", this.defaultVolume));
    }

    public float getPressure() {
        return this.airHandler.getPressure();
    }

    public void addAir(int air) {
        this.airHandler.addAir(air);
    }

    public boolean canConnectPneumatic(Direction side) {
        return true;
    }

    public int getDefaultVolume() {
        return this.defaultVolume;
    }

    public void forceLeak(Direction dir) {
        this.airHandler.setSideLeaking(dir);
    }

    public boolean hasNoConnectedAirHandlers() {
        return this.airHandler.getConnectedAirHandlers(this).isEmpty();
    }
}

