/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.inventory.ContainerPneumaticDoorBase;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.LazySynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.tileentity.ICamouflageableTE;
import me.desht.pneumaticcraft.common.tileentity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControl;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticDoor;
import me.desht.pneumaticcraft.common.tileentity.TileEntitySecurityStation;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.items.IItemHandler;

public class TileEntityPneumaticDoorBase
extends TileEntityPneumaticBase
implements IRedstoneControl,
IMinWorkingPressure,
ICamouflageableTE,
INamedContainerProvider {
    private static final List<String> REDSTONE_LABELS = ImmutableList.of((Object)"pneumaticcraft.gui.tab.redstoneBehaviour.pneumaticDoor.button.playerNearby", (Object)"pneumaticcraft.gui.tab.redstoneBehaviour.pneumaticDoor.button.playerNearbyAndLooking", (Object)"pneumaticcraft.gui.tab.redstoneBehaviour.pneumaticDoor.button.woodenDoor");
    public static final int INVENTORY_SIZE = 1;
    private TileEntityPneumaticDoor door;
    private TileEntityPneumaticDoorBase doubleDoor;
    @DescSynced
    public boolean rightGoing;
    public float oldProgress;
    @DescSynced
    @LazySynced
    public float progress;
    @DescSynced
    private boolean opening;
    public boolean wasPowered;
    private BlockState camoState;
    @GuiSynced
    public int redstoneMode;
    @DescSynced
    private float speedMultiplier;

    public TileEntityPneumaticDoorBase() {
        super((TileEntityType)ModTileEntities.PNEUMATIC_DOOR_BASE.get(), 5.0f, 7.0f, 2000, 4);
    }

    @Override
    public void func_73660_a() {
        float targetProgress;
        super.func_73660_a();
        this.oldProgress = this.progress;
        if (!this.func_145831_w().field_72995_K) {
            if (this.getPressure() >= 2.0f) {
                if ((this.func_145831_w().func_82737_E() & 0x3FL) == 0L) {
                    TileEntity te = this.func_145831_w().func_175625_s(this.func_174877_v().func_177967_a(this.getRotation(), 3));
                    this.doubleDoor = te instanceof TileEntityPneumaticDoorBase ? (TileEntityPneumaticDoorBase)te : null;
                }
                this.setOpening(this.shouldOpen() || this.isNeighborOpening());
                this.setNeighborOpening(this.isOpening());
            } else {
                this.setOpening(true);
            }
            this.speedMultiplier = this.getSpeedMultiplierFromUpgrades();
        }
        float f = targetProgress = this.opening ? 1.0f : 0.0f;
        if (this.progress < targetProgress) {
            this.progress = (double)this.progress > 0.05 && this.progress < targetProgress - 0.15f ? (this.progress += 0.04f * this.speedMultiplier) : (float)((double)this.progress + Math.min(0.02, (double)(0.01f * this.speedMultiplier)));
            if (this.progress > targetProgress) {
                this.progress = targetProgress;
            }
        }
        if (this.progress > targetProgress) {
            this.progress = (double)this.progress < 0.95 && this.progress > targetProgress + 0.15f ? (this.progress -= 0.04f * this.speedMultiplier) : (float)((double)this.progress - Math.min(0.02, (double)(0.01f * this.speedMultiplier)));
            if (this.progress < targetProgress) {
                this.progress = targetProgress;
            }
        }
        if (!this.func_145831_w().field_72995_K) {
            this.addAir((int)(-Math.abs(this.oldProgress - this.progress) * 300.0f * (this.getSpeedUsageMultiplierFromUpgrades() / this.speedMultiplier)));
        }
        this.door = this.getDoor();
        if (this.door != null) {
            this.door.setRotationAngle(this.progress * 90.0f);
            if (!this.func_145831_w().field_72995_K) {
                this.rightGoing = this.door.rightGoing;
            }
        }
    }

    private boolean shouldOpen() {
        if (this.door == null) {
            return false;
        }
        switch (this.redstoneMode) {
            case 0: 
            case 1: {
                int range = 2 + this.getUpgrades(EnumUpgrade.RANGE);
                AxisAlignedBB aabb = new AxisAlignedBB(this.func_174877_v()).func_186662_g((double)range);
                for (PlayerEntity player : this.func_145831_w().func_217357_a(PlayerEntity.class, aabb)) {
                    if (TileEntitySecurityStation.getProtectingSecurityStations(player, this.func_174877_v(), false, false) > 0) continue;
                    if (this.redstoneMode == 0) {
                        return true;
                    }
                    Vector3d eyePos = player.func_174824_e(0.0f);
                    Vector3d endPos = eyePos.func_178787_e(player.func_70040_Z().func_72432_b().func_186678_a((double)((float)range * 1.4142f)));
                    return this.door.getRenderBoundingBox().func_216365_b(eyePos, endPos).isPresent();
                }
                return false;
            }
            case 2: {
                return this.opening;
            }
        }
        return false;
    }

    public void setOpening(boolean opening) {
        boolean wasOpening = this.opening;
        this.opening = opening;
        if (this.opening != wasOpening) {
            NetworkHandler.sendToAllAround(new PacketPlaySound((SoundEvent)ModSounds.PNEUMATIC_DOOR.get(), SoundCategory.BLOCKS, this.func_174877_v(), 1.0f, 1.0f, false), this.func_145831_w());
            this.sendDescriptionPacket();
        }
    }

    public boolean isOpening() {
        return this.opening;
    }

    private boolean isNeighborOpening() {
        return this.doubleDoor != null && this.doubleDoor.shouldOpen();
    }

    public void setNeighborOpening(boolean opening) {
        if (this.doubleDoor != null && this.doubleDoor.getPressure() >= 2.0f) {
            this.doubleDoor.setOpening(opening);
        }
    }

    @Override
    public boolean canConnectPneumatic(Direction side) {
        return side != Direction.UP;
    }

    private TileEntityPneumaticDoor getDoor() {
        TileEntity te = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(this.getRotation()).func_177982_a(0, -1, 0));
        if (te instanceof TileEntityPneumaticDoor) {
            TileEntityPneumaticDoor teDoor = (TileEntityPneumaticDoor)te;
            if (this.getRotation().func_176746_e() == teDoor.getRotation() && !teDoor.rightGoing) {
                return (TileEntityPneumaticDoor)te;
            }
            if (this.getRotation().func_176735_f() == teDoor.getRotation() && teDoor.rightGoing) {
                return (TileEntityPneumaticDoor)te;
            }
        }
        return null;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.progress = tag.func_74760_g("extension");
        this.opening = tag.func_74767_n("opening");
        this.redstoneMode = tag.func_74762_e("redstoneMode");
        this.rightGoing = tag.func_74767_n("rightGoing");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_74776_a("extension", this.progress);
        tag.func_74757_a("opening", this.opening);
        tag.func_74768_a("redstoneMode", this.redstoneMode);
        tag.func_74757_a("rightGoing", this.rightGoing);
        return tag;
    }

    @Override
    public void writeToPacket(CompoundNBT tag) {
        super.writeToPacket(tag);
        ICamouflageableTE.writeCamo(tag, this.camoState);
    }

    @Override
    public void readFromPacket(CompoundNBT tag) {
        super.readFromPacket(tag);
        this.camoState = ICamouflageableTE.readCamo(tag);
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, PlayerEntity player) {
        if (tag.equals("redstone")) {
            ++this.redstoneMode;
            if (this.redstoneMode > 2) {
                this.redstoneMode = 0;
            }
        }
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return null;
    }

    @Override
    public float getMinWorkingPressure() {
        return 2.0f;
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public BlockState getCamouflage() {
        return this.camoState;
    }

    @Override
    public void setCamouflage(BlockState state) {
        this.camoState = state;
        ICamouflageableTE.syncToClient(this);
    }

    @Override
    public ITextComponent getRedstoneTabTitle() {
        return PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.redstoneBehaviour.pneumaticDoor.openWhen", new Object[0]);
    }

    @Override
    protected List<String> getRedstoneButtonLabels() {
        return REDSTONE_LABELS;
    }

    public ITextComponent func_145748_c_() {
        return this.getDisplayNameInternal();
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerPneumaticDoorBase(i, playerInventory, this.func_174877_v());
    }
}

