/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.inventory.ContainerPressureChamberInterface;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.LazySynced;
import me.desht.pneumaticcraft.common.recipes.PneumaticCraftRecipeType;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControlled;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPressureChamberValve;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPressureChamberWall;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.BlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class TileEntityPressureChamberInterface
extends TileEntityPressureChamberWall
implements ITickableTileEntity,
IRedstoneControlled,
INamedContainerProvider {
    public static final int MAX_PROGRESS = 40;
    public static final int INVENTORY_SIZE = 1;
    private static final int MIN_SOUND_INTERVAL = 400;
    private final Set<Item> acceptedItemCache = new HashSet<Item>();
    @DescSynced
    private final PressureChamberInterfaceHandler inventory = new PressureChamberInterfaceHandler();
    private final LazyOptional<IItemHandler> invCap = LazyOptional.of(() -> this.inventory);
    @DescSynced
    private float doorSpeed = 0.0f;
    @DescSynced
    @LazySynced
    public float inputProgress;
    public float oldInputProgress;
    @DescSynced
    @LazySynced
    public float outputProgress;
    public float oldOutputProgress;
    @GuiSynced
    public InterfaceDirection interfaceMode = InterfaceDirection.NONE;
    @GuiSynced
    private boolean enoughAir = true;
    private boolean isOpeningInput;
    private boolean isOpeningOutput;
    private int soundTimer;
    @DescSynced
    private boolean shouldOpenInput;
    @DescSynced
    private boolean shouldOpenOutput;
    @GuiSynced
    public int redstoneMode;
    private int inputTimeOut;
    private int oldItemCount;
    @GuiSynced
    public boolean exportAny;

    public TileEntityPressureChamberInterface() {
        super((TileEntityType)ModTileEntities.PRESSURE_CHAMBER_INTERFACE.get(), 4);
    }

    public ITextComponent func_145748_c_() {
        return this.getDisplayNameInternal();
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerPressureChamberInterface(i, playerInventory, this.func_174877_v());
    }

    public void func_73660_a() {
        this.tickImpl();
        boolean wasOpeningI = this.isOpeningInput;
        boolean wasOpeningO = this.isOpeningOutput;
        this.oldInputProgress = this.inputProgress;
        this.oldOutputProgress = this.outputProgress;
        TileEntityPressureChamberValve core = this.getCore();
        if (!this.func_145831_w().field_72995_K) {
            this.doorSpeed = this.getSpeedMultiplierFromUpgrades();
            int itemCount = this.inventory.getStackInSlot(0).func_190916_E();
            if (this.oldItemCount != itemCount) {
                this.oldItemCount = itemCount;
                this.inputTimeOut = 0;
            }
            this.interfaceMode = this.getInterfaceMode(core);
            this.enoughAir = true;
            if (this.interfaceMode != InterfaceDirection.NONE) {
                if (!this.inventory.getStackInSlot(0).func_190926_b() && ++this.inputTimeOut > 10) {
                    this.shouldOpenInput = false;
                    if (this.inputProgress == 0.0f) {
                        this.shouldOpenOutput = true;
                        if (this.outputProgress == 40.0f) {
                            if (this.interfaceMode == InterfaceDirection.IMPORT) {
                                this.outputInChamber();
                            } else {
                                this.exportToInventory();
                            }
                        }
                    }
                } else {
                    this.shouldOpenOutput = false;
                    if (this.outputProgress == 0.0f) {
                        this.shouldOpenInput = true;
                        if (this.interfaceMode == InterfaceDirection.EXPORT && this.inputProgress == 40.0f && this.redstoneAllows()) {
                            this.importFromChamber(core);
                        }
                    }
                }
            } else {
                this.shouldOpenInput = false;
                this.shouldOpenOutput = false;
            }
        }
        if (this.shouldOpenInput) {
            this.inputProgress = Math.min(this.inputProgress + this.doorSpeed, 40.0f);
            this.isOpeningInput = true;
        } else {
            this.inputProgress = Math.max(this.inputProgress - this.doorSpeed, 0.0f);
            this.isOpeningInput = false;
        }
        if (this.shouldOpenOutput) {
            this.outputProgress = Math.min(this.outputProgress + this.doorSpeed, 40.0f);
            this.isOpeningOutput = true;
        } else {
            this.outputProgress = Math.max(this.outputProgress - this.doorSpeed, 0.0f);
            this.isOpeningOutput = false;
        }
        if (this.func_145831_w().field_72995_K && this.soundTimer++ >= 400 && (wasOpeningI != this.isOpeningInput || wasOpeningO != this.isOpeningOutput)) {
            this.func_145831_w().func_184134_a((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, (SoundEvent)ModSounds.INTERFACE_DOOR.get(), SoundCategory.BLOCKS, 0.5f, 1.0f, true);
            this.soundTimer = 0;
        }
    }

    public ItemStack getStackInInterface() {
        return this.inventory.getStackInSlot(0);
    }

    private void exportToInventory() {
        Direction facing = this.getRotation();
        TileEntity te = this.getCachedNeighbor(facing);
        ItemStack stack = this.inventory.getStackInSlot(0);
        if (te != null) {
            int count = stack.func_190916_E();
            ItemStack leftoverStack = IOHelper.insert(te, stack.func_77946_l(), facing.func_176734_d(), false);
            stack.func_190918_g(count - leftoverStack.func_190916_E());
        } else if (this.getUpgrades(EnumUpgrade.DISPENSER) > 0) {
            BlockPos pos = this.func_174877_v().func_177972_a(this.getRotation());
            PneumaticCraftUtils.dropItemOnGroundPrecisely(stack, this.func_145831_w(), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
            this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
        }
    }

    private void importFromChamber(TileEntityPressureChamberValve core) {
        CombinedInvWrapper chamberHandler = this.exportAny ? core.allItems : core.craftedItems;
        for (int i = 0; i < chamberHandler.getSlots(); ++i) {
            ItemStack toTransferStack;
            ItemStack excess;
            IAirHandlerMachine coreAirHandler;
            int maxAllowedItems;
            ItemStack stackInInterface;
            ItemStack chamberStack = chamberHandler.getStackInSlot(i);
            if (chamberStack.func_190926_b() || !(stackInInterface = this.inventory.getStackInSlot(0)).func_190926_b() && !stackInInterface.func_77969_a(chamberStack) || (maxAllowedItems = Math.abs((coreAirHandler = (IAirHandlerMachine)core.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY).orElseThrow(RuntimeException::new)).getAir()) / 1000) <= 0) continue;
            maxAllowedItems = Math.min(maxAllowedItems, chamberStack.func_77976_d() - stackInInterface.func_190916_E());
            int transferredItems = Math.min(chamberStack.func_190916_E(), maxAllowedItems);
            if (transferredItems <= 0 || (excess = this.inventory.insertItem(0, toTransferStack = chamberStack.func_77946_l().func_77979_a(transferredItems), true)).func_190916_E() >= toTransferStack.func_190916_E()) continue;
            transferredItems = toTransferStack.func_190916_E() - excess.func_190916_E();
            core.addAir((coreAirHandler.getAir() > 0 ? -1 : 1) * transferredItems * 1000);
            toTransferStack.func_190920_e(transferredItems);
            this.inventory.insertItem(0, toTransferStack, false);
            chamberHandler.extractItem(i, transferredItems, false);
        }
    }

    private void outputInChamber() {
        TileEntityPressureChamberValve valve = this.getCore();
        if (valve != null) {
            ItemStack inputStack = this.inventory.getStackInSlot(0);
            IAirHandlerMachine valveAirHandler = (IAirHandlerMachine)valve.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY).orElseThrow(RuntimeException::new);
            boolean bl = this.enoughAir = Math.abs(valveAirHandler.getAir()) > inputStack.func_190916_E() * 1000;
            if (this.enoughAir) {
                ItemStack excess = valve.insertItemToChamber(inputStack);
                int inserted = inputStack.func_190916_E() - excess.func_190916_E();
                valve.addAir((valveAirHandler.getAir() > 0 ? -1 : 1) * inserted * 1000);
                this.inventory.setStackInSlot(0, excess);
            }
        }
    }

    private InterfaceDirection getInterfaceMode(TileEntityPressureChamberValve core) {
        if (core != null) {
            boolean xMid = this.func_174877_v().func_177958_n() != core.multiBlockX && this.func_174877_v().func_177958_n() != core.multiBlockX + core.multiBlockSize - 1;
            boolean yMid = this.func_174877_v().func_177956_o() != core.multiBlockY && this.func_174877_v().func_177956_o() != core.multiBlockY + core.multiBlockSize - 1;
            boolean zMid = this.func_174877_v().func_177952_p() != core.multiBlockZ && this.func_174877_v().func_177952_p() != core.multiBlockZ + core.multiBlockSize - 1;
            Direction rotation = this.getRotation();
            if (xMid && yMid && rotation == Direction.NORTH || xMid && zMid && rotation == Direction.DOWN || yMid && zMid && rotation == Direction.WEST) {
                if (this.func_174877_v().func_177958_n() == core.multiBlockX || this.func_174877_v().func_177956_o() == core.multiBlockY || this.func_174877_v().func_177952_p() == core.multiBlockZ) {
                    return InterfaceDirection.EXPORT;
                }
                return InterfaceDirection.IMPORT;
            }
            if (xMid && yMid && rotation == Direction.SOUTH || xMid && zMid && rotation == Direction.UP || yMid && zMid && rotation == Direction.EAST) {
                if (this.func_174877_v().func_177958_n() == core.multiBlockX || this.func_174877_v().func_177956_o() == core.multiBlockY || this.func_174877_v().func_177952_p() == core.multiBlockZ) {
                    return InterfaceDirection.IMPORT;
                }
                return InterfaceDirection.EXPORT;
            }
        }
        return InterfaceDirection.NONE;
    }

    public List<String> getProblemStat() {
        ArrayList<String> textList = new ArrayList<String>();
        if (this.interfaceMode == InterfaceDirection.NONE) {
            textList.addAll(PneumaticCraftUtils.splitString(I18n.func_135052_a((String)"pneumaticcraft.gui.tab.problems.pressure_chamber_interface.not_formed", (Object[])new Object[0])));
        } else if (!this.enoughAir) {
            textList.addAll(PneumaticCraftUtils.splitString(I18n.func_135052_a((String)"pneumaticcraft.gui.tab.problems.pressure_chamber_interface.not_enough_pressure", (Object[])new Object[0])));
        }
        return textList;
    }

    public boolean hasEnoughPressure() {
        return this.enoughAir;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.inventory.deserializeNBT(tag.func_74775_l("Items"));
        this.outputProgress = tag.func_74760_g("outputProgress");
        this.inputProgress = tag.func_74760_g("inputProgress");
        this.interfaceMode = InterfaceDirection.values()[tag.func_74762_e("interfaceMode")];
        this.exportAny = tag.func_74767_n("exportAny");
        this.redstoneMode = tag.func_74762_e("redstoneMode");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_218657_a("Items", (INBT)this.inventory.serializeNBT());
        tag.func_74776_a("outputProgress", this.outputProgress);
        tag.func_74776_a("inputProgress", this.inputProgress);
        tag.func_74768_a("interfaceMode", this.interfaceMode.ordinal());
        tag.func_74757_a("exportAny", this.exportAny);
        tag.func_74768_a("redstoneMode", this.redstoneMode);
        return tag;
    }

    @Override
    public boolean isGuiUseableByPlayer(PlayerEntity player) {
        return this.func_145831_w().func_175625_s(this.func_174877_v()) == this && player.func_70092_e((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return this.inventory;
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, PlayerEntity player) {
        if (tag.equals("redstone")) {
            ++this.redstoneMode;
            if (this.redstoneMode > 2) {
                this.redstoneMode = 0;
            }
        } else if (tag.equals("export_mode")) {
            this.exportAny = !this.exportAny;
        }
        this.func_70296_d();
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    protected LazyOptional<IItemHandler> getInventoryCap() {
        return this.invCap;
    }

    private class PressureChamberInterfaceHandler
    extends BaseItemStackHandler {
        PressureChamberInterfaceHandler() {
            super(TileEntityPressureChamberInterface.this, 1);
        }

        @Override
        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return TileEntityPressureChamberInterface.this.inputProgress == 40.0f && this.isValidItem(stack) ? super.insertItem(slot, stack, simulate) : stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return TileEntityPressureChamberInterface.this.outputProgress == 40.0f ? super.extractItem(slot, amount, simulate) : ItemStack.field_190927_a;
        }

        private boolean isValidItem(ItemStack stack) {
            if (TileEntityPressureChamberInterface.this.interfaceMode == InterfaceDirection.IMPORT) {
                if (TileEntityPressureChamberInterface.this.acceptedItemCache.contains(stack.func_77973_b())) {
                    return true;
                }
                boolean accepted = PneumaticCraftRecipeType.PRESSURE_CHAMBER.stream(TileEntityPressureChamberInterface.this.field_145850_b).anyMatch(recipe -> recipe.isValidInputItem(stack));
                if (accepted) {
                    TileEntityPressureChamberInterface.this.acceptedItemCache.add(stack.func_77973_b());
                }
                return accepted;
            }
            return TileEntityPressureChamberInterface.this.interfaceMode == InterfaceDirection.EXPORT;
        }
    }

    public static enum InterfaceDirection {
        NONE,
        IMPORT,
        EXPORT;


        public String getTranslationKey() {
            return "pneumaticcraft.gui.pressureChamberInterface.mode." + this.toString().toLowerCase();
        }
    }
}

