/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.client.render.area.AreaRenderManager;
import me.desht.pneumaticcraft.common.block.BlockReinforcedChest;
import me.desht.pneumaticcraft.common.block.BlockSmartChest;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.inventory.ContainerSmartChest;
import me.desht.pneumaticcraft.common.inventory.handler.ComparatorItemStackHandler;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import me.desht.pneumaticcraft.common.network.PacketSyncSmartChest;
import me.desht.pneumaticcraft.common.particle.AirParticleData;
import me.desht.pneumaticcraft.common.tileentity.IComparatorSupport;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControlled;
import me.desht.pneumaticcraft.common.tileentity.SideConfigurator;
import me.desht.pneumaticcraft.common.tileentity.TileEntityTickableBase;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.ITranslatableEnum;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.BlockState;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;

public class TileEntitySmartChest
extends TileEntityTickableBase
implements INamedContainerProvider,
IRedstoneControlled,
IComparatorSupport {
    public static final int CHEST_SIZE = 72;
    private static final String NBT_ITEMS = "Items";
    private final SmartChestItemHandler inventory = new SmartChestItemHandler(this, 72){

        @Override
        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return stack.func_77973_b() != ((BlockReinforcedChest)ModBlocks.REINFORCED_CHEST.get()).func_199767_j() && super.isItemValid(slot, stack);
        }
    };
    private final LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);
    @GuiSynced
    private int redstoneMode;
    @GuiSynced
    private int pushPullModes = 0;
    @GuiSynced
    private int cooldown = 0;
    private final int[] pullSlots = new int[6];
    private final int[] pushSlots = new int[6];

    public TileEntitySmartChest() {
        super((TileEntityType)ModTileEntities.SMART_CHEST.get(), 4);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K && this.redstoneAllows() && this.field_145850_b.func_82737_E() % (long)Math.max(this.getTickRate(), this.cooldown) == 0L) {
            boolean didWork = false;
            block4: for (SideConfigurator.RelativeFace face : SideConfigurator.RelativeFace.values()) {
                switch (this.getPushPullMode(face)) {
                    case PUSH: {
                        didWork |= this.tryPush(this.getAbsoluteFacing(face, this.getRotation()));
                        continue block4;
                    }
                    case PULL: {
                        didWork |= this.tryPull(this.getAbsoluteFacing(face, this.getRotation()));
                    }
                }
            }
            int n = this.cooldown = didWork ? 0 : Math.min(this.cooldown + 4, 20);
        }
        if (this.field_145850_b.field_72995_K && this.getUpgrades(EnumUpgrade.MAGNET) == 0) {
            AreaRenderManager.getInstance().removeHandlers(this);
        }
    }

    private boolean tryPush(Direction dir) {
        TileEntity te = this.getCachedNeighbor(dir);
        if (te == null) {
            return this.tryDispense(dir);
        }
        return IOHelper.getInventoryForTE(te, dir.func_176734_d()).map(dstHandler -> {
            int idx = dir.ordinal();
            ItemStack toPush = this.findNextItem((IItemHandler)this.inventory, this.pushSlots, idx);
            if (toPush.func_190926_b()) {
                return false;
            }
            ItemStack excess = ItemHandlerHelper.insertItem((IItemHandler)dstHandler, (ItemStack)toPush, (boolean)false);
            int transferred = toPush.func_190916_E() - excess.func_190916_E();
            if (transferred > 0) {
                this.inventory.extractItem(this.pushSlots[idx], transferred, false);
                return true;
            }
            this.findNextItem((IItemHandler)this.inventory, this.pushSlots, idx);
            return false;
        }).orElse(false);
    }

    private boolean tryDispense(Direction dir) {
        ItemStack toPush;
        BlockState state;
        if (this.getUpgrades(EnumUpgrade.DISPENSER) > 0 && !PneumaticCraftUtils.blockHasSolidSide(state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(dir)), (IBlockReader)this.field_145850_b, this.field_174879_c, dir.func_176734_d()) && !(toPush = this.findNextItem((IItemHandler)this.inventory, this.pushSlots, dir.ordinal())).func_190926_b()) {
            ItemStack pushed = this.inventory.extractItem(this.pushSlots[dir.ordinal()], toPush.func_190916_E(), false);
            BlockPos dropPos = this.field_174879_c.func_177972_a(dir);
            PneumaticCraftUtils.dropItemOnGroundPrecisely(pushed, this.field_145850_b, (double)dropPos.func_177958_n() + 0.5, (double)dropPos.func_177956_o() + 0.5, (double)dropPos.func_177952_p() + 0.5);
            return true;
        }
        return false;
    }

    private boolean tryPull(Direction dir) {
        TileEntity te = this.getCachedNeighbor(dir);
        if (te == null) {
            return this.tryMagnet(dir);
        }
        return IOHelper.getInventoryForTE(this.getCachedNeighbor(dir), dir.func_176734_d()).map(srcHandler -> {
            int idx = dir.ordinal();
            ItemStack toPull = this.findNextItem((IItemHandler)srcHandler, this.pullSlots, idx);
            if (toPull.func_190926_b()) {
                return false;
            }
            ItemStack excess = ItemHandlerHelper.insertItem((IItemHandler)this.inventory, (ItemStack)toPull, (boolean)false);
            int transferred = toPull.func_190916_E() - excess.func_190916_E();
            if (transferred > 0) {
                srcHandler.extractItem(this.pullSlots[idx], transferred, false);
                return true;
            }
            this.pullSlots[idx] = this.scanForward((IItemHandler)srcHandler, this.pullSlots[idx]);
            return false;
        }).orElse(false);
    }

    private boolean tryMagnet(Direction dir) {
        if (this.getUpgrades(EnumUpgrade.MAGNET) > 0) {
            int range = this.getUpgrades(EnumUpgrade.RANGE);
            AxisAlignedBB aabb = new AxisAlignedBB(this.field_174879_c.func_177967_a(dir, range + 2)).func_186662_g((double)(range + 1));
            List items = this.field_145850_b.func_175647_a(ItemEntity.class, aabb, e -> !e.func_174874_s());
            boolean didWork = false;
            for (ItemEntity item : items) {
                ItemStack stack = item.func_92059_d();
                ItemStack excess = ItemHandlerHelper.insertItem((IItemHandler)this.inventory, (ItemStack)stack, (boolean)false);
                if (excess.func_190926_b()) {
                    item.func_70106_y();
                } else {
                    item.func_92058_a(excess);
                }
                if (excess.func_190916_E() >= stack.func_190916_E()) continue;
                NetworkHandler.sendToAllAround(new PacketSpawnParticle(AirParticleData.DENSE, item.func_226277_ct_(), item.func_226278_cu_() + 0.5, item.func_226281_cx_(), 0.0, 0.0, 0.0, 5, 0.5, 0.5, 0.5), this.field_145850_b);
                didWork = true;
            }
            return didWork;
        }
        return false;
    }

    private ItemStack findNextItem(IItemHandler handler, int[] slots, int idx) {
        if (handler.getStackInSlot(slots[idx]).func_190926_b()) {
            slots[idx] = this.scanForward(handler, slots[idx]);
        }
        return handler.extractItem(slots[idx], this.getMaxItems(), true);
    }

    private int scanForward(IItemHandler handler, int slot) {
        int limit = handler.getSlots();
        for (int i = 0; i < limit; ++i) {
            if (++slot >= limit) {
                slot = 0;
            }
            if (!handler.getStackInSlot(slot).func_190926_b()) break;
        }
        return slot;
    }

    public int getTickRate() {
        return 8 >> Math.min(3, this.getUpgrades(EnumUpgrade.SPEED));
    }

    public int getMaxItems() {
        int upgrades = this.getUpgrades(EnumUpgrade.SPEED);
        if (upgrades > 3) {
            return Math.min(1 << upgrades - 3, 256);
        }
        return 1;
    }

    public Direction getAbsoluteFacing(SideConfigurator.RelativeFace face, Direction dir) {
        switch (face) {
            case TOP: {
                return Direction.UP;
            }
            case BOTTOM: {
                return Direction.DOWN;
            }
            case FRONT: {
                return dir;
            }
            case RIGHT: {
                return dir.func_176735_f();
            }
            case LEFT: {
                return dir.func_176746_e();
            }
            case BACK: {
                return dir.func_176734_d();
            }
        }
        throw new IllegalArgumentException("impossible direction " + dir);
    }

    public PushPullMode getPushPullMode(SideConfigurator.RelativeFace face) {
        int idx = face.ordinal();
        int mask = 3 << idx * 2;
        int n = (this.pushPullModes & mask) >> idx * 2;
        return PushPullMode.values()[n];
    }

    private void setPushPullMode(SideConfigurator.RelativeFace face, PushPullMode mode) {
        int idx = face.ordinal();
        int mask = 3 << idx * 2;
        this.pushPullModes &= ~mask;
        this.pushPullModes |= mode.ordinal() << idx * 2;
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return this.inventory;
    }

    @Override
    @Nonnull
    protected LazyOptional<IItemHandler> getInventoryCap() {
        return this.inventoryCap;
    }

    public ITextComponent func_145748_c_() {
        return this.getDisplayNameInternal();
    }

    @Nullable
    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
        if (player instanceof ServerPlayerEntity) {
            NetworkHandler.sendToPlayer(new PacketSyncSmartChest(this), (ServerPlayerEntity)player);
        }
        return new ContainerSmartChest(windowId, inv, this.func_174877_v());
    }

    @Override
    public boolean shouldPreserveStateOnBreak() {
        return true;
    }

    @Override
    public void getContentsToDrop(NonNullList<ItemStack> drops) {
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_218657_a(NBT_ITEMS, (INBT)this.inventory.serializeNBT());
        tag.func_74768_a("redstoneMode", this.redstoneMode);
        tag.func_74768_a("pushPull", this.pushPullModes);
        return super.func_189515_b(tag);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.redstoneMode = tag.func_74762_e("redstoneMode");
        this.inventory.deserializeNBT(tag.func_74775_l(NBT_ITEMS));
        this.pushPullModes = tag.func_74762_e("pushPull");
    }

    @Override
    public void serializeExtraItemData(CompoundNBT blockEntityTag, boolean preserveState) {
        boolean shouldSave;
        super.serializeExtraItemData(blockEntityTag, preserveState);
        boolean bl = shouldSave = this.inventory.lastSlot < 72 || this.redstoneMode != 0;
        if (!shouldSave) {
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                if (this.inventory.getStackInSlot(i).func_190926_b() && this.inventory.filter[i].func_190926_b()) continue;
                shouldSave = true;
            }
        }
        if (shouldSave) {
            blockEntityTag.func_218657_a(NBT_ITEMS, (INBT)this.inventory.serializeNBT());
            blockEntityTag.func_74768_a("redstoneMode", this.redstoneMode);
        }
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, PlayerEntity player) {
        String[] s;
        if (tag.equals("redstone")) {
            ++this.redstoneMode;
            if (this.redstoneMode > 2) {
                this.redstoneMode = 0;
            }
        } else if (tag.startsWith("push_pull:") && (s = tag.split(":")).length == 2) {
            try {
                SideConfigurator.RelativeFace face = SideConfigurator.RelativeFace.valueOf(s[1]);
                this.cycleMode(face);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public void cycleMode(SideConfigurator.RelativeFace face) {
        this.setPushPullMode(face, this.getPushPullMode(face).cycle());
    }

    public int getLastSlot() {
        return this.inventory.getLastSlot();
    }

    public void setLastSlot(int lastSlot) {
        this.inventory.setLastSlot(lastSlot);
    }

    public List<Pair<Integer, ItemStack>> getFilter() {
        ArrayList<Pair<Integer, ItemStack>> res = new ArrayList<Pair<Integer, ItemStack>>();
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (this.inventory.filter[i].func_190926_b()) continue;
            res.add((Pair<Integer, ItemStack>)Pair.of((Object)i, (Object)this.inventory.filter[i].func_77946_l()));
        }
        return res;
    }

    public void setFilter(List<Pair<Integer, ItemStack>> l) {
        Arrays.fill(this.inventory.filter, ItemStack.field_190927_a);
        for (Pair<Integer, ItemStack> p : l) {
            this.inventory.setFilter((Integer)p.getLeft(), (ItemStack)p.getRight());
        }
    }

    public ItemStack getFilter(int slotId) {
        return this.inventory.filter[slotId];
    }

    public void setFilter(int slotId, ItemStack stack) {
        ((SmartChestItemHandler)this.inventory).filter[slotId] = stack.func_77946_l();
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public int getComparatorValue() {
        return this.inventory.getComparatorValue();
    }

    public static class SmartChestItemHandler
    extends ComparatorItemStackHandler {
        private final ItemStack[] filter = new ItemStack[72];
        private int lastSlot = 72;

        SmartChestItemHandler(TileEntity te, int size) {
            super(te, size);
            Arrays.fill(this.filter, ItemStack.field_190927_a);
        }

        public int getSlots() {
            return Math.min(72, this.lastSlot);
        }

        public int getSlotLimit(int slot) {
            return this.filter[slot].func_190926_b() ? super.getSlotLimit(slot) : this.filter[slot].func_190916_E();
        }

        int getLastSlot() {
            return this.lastSlot;
        }

        void setLastSlot(int lastSlot) {
            for (int i = lastSlot; i < this.getSlots(); ++i) {
                if (this.getStackInSlot(i).func_190926_b()) continue;
                return;
            }
            this.lastSlot = lastSlot;
        }

        public void setFilter(int slot, ItemStack stack) {
            this.filter[slot] = stack;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return slot < this.lastSlot && (this.filter[slot].func_190926_b() || this.filter[slot].func_77973_b() == stack.func_77973_b()) && stack.func_77973_b() != ((BlockReinforcedChest)ModBlocks.REINFORCED_CHEST.get()).func_199767_j() && stack.func_77973_b() != ((BlockSmartChest)ModBlocks.SMART_CHEST.get()).func_199767_j() && super.isItemValid(slot, stack);
        }

        public CompoundNBT serializeNBT() {
            CompoundNBT tag = super.serializeNBT();
            tag.func_74768_a("LastSlot", this.lastSlot);
            ListNBT l = new ListNBT();
            for (int i = 0; i < 72; ++i) {
                if (this.filter[i].func_190926_b()) continue;
                CompoundNBT subTag = new CompoundNBT();
                subTag.func_74768_a("Slot", i);
                this.filter[i].func_77955_b(subTag);
                l.add((Object)subTag);
            }
            tag.func_218657_a("Filter", (INBT)l);
            tag.func_74757_a("V2", true);
            return tag;
        }

        @Override
        public void deserializeNBT(CompoundNBT nbt) {
            super.deserializeNBT(nbt);
            this.lastSlot = nbt.func_74762_e("LastSlot");
            ListNBT l = nbt.func_150295_c("Filter", 10);
            boolean isV2 = nbt.func_74767_n("V2");
            for (int i = 0; i < l.size(); ++i) {
                CompoundNBT tag = l.func_150305_b(i);
                ItemStack stack = ItemStack.func_199557_a((CompoundNBT)tag);
                if (!isV2 && stack.func_190916_E() == 1) {
                    stack.func_190920_e(stack.func_77976_d());
                }
                this.filter[tag.func_74762_e((String)"Slot")] = stack;
            }
        }
    }

    public static enum PushPullMode implements ITranslatableEnum
    {
        NONE("none"),
        PUSH("push"),
        PULL("pull");

        private final String key;

        private PushPullMode(String key) {
            this.key = key;
        }

        @Override
        public String getTranslationKey() {
            return "pneumaticcraft.gui.tooltip.smartChest.mode." + this.key;
        }

        public PushPullMode cycle() {
            int n = this.ordinal() + 1;
            if (n >= PushPullMode.values().length) {
                n = 0;
            }
            return PushPullMode.values()[n];
        }
    }
}

