/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.client.util.TintColor;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.heat.SyncedTemperature;
import me.desht.pneumaticcraft.common.inventory.ContainerThermalCompressor;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.tileentity.IHeatTinted;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControlled;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class TileEntityThermalCompressor
extends TileEntityPneumaticBase
implements IHeatTinted,
IRedstoneControlled,
INamedContainerProvider {
    private static final double AIR_GEN_MULTIPLIER = 0.05;
    private final double[] airGenerated = new double[2];
    @GuiSynced
    private final IHeatExchangerLogic[] heatExchangers = new IHeatExchangerLogic[4];
    private final List<LazyOptional<IHeatExchangerLogic>> heatCaps = new ArrayList<LazyOptional<IHeatExchangerLogic>>(4);
    private final IHeatExchangerLogic connector1;
    private final IHeatExchangerLogic connector2;
    private final IHeatExchangerLogic dummyExchanger;
    @DescSynced
    private final SyncedTemperature[] syncedTemperatures = new SyncedTemperature[4];
    @GuiSynced
    private int redstoneMode;

    public TileEntityThermalCompressor() {
        super((TileEntityType)ModTileEntities.THERMAL_COMPRESSOR.get(), 5.0f, 7.0f, 5000, 4);
        IntStream.range(0, this.heatExchangers.length).forEach(i -> {
            this.heatExchangers[i] = PneumaticRegistry.getInstance().getHeatRegistry().makeHeatExchangerLogic();
            this.heatExchangers[i].setThermalCapacity(2.0);
            this.heatCaps.add((LazyOptional<IHeatExchangerLogic>)LazyOptional.of(() -> this.heatExchangers[i]));
        });
        for (int i2 = 0; i2 < this.syncedTemperatures.length; ++i2) {
            this.syncedTemperatures[i2] = new SyncedTemperature(this.heatExchangers[i2]);
        }
        this.connector1 = this.makeConnector(Direction.NORTH);
        this.connector2 = this.makeConnector(Direction.EAST);
        this.dummyExchanger = PneumaticRegistry.getInstance().getHeatRegistry().makeHeatExchangerLogic();
    }

    private IHeatExchangerLogic makeConnector(Direction side) {
        IHeatExchangerLogic connector = PneumaticRegistry.getInstance().getHeatRegistry().makeHeatExchangerLogic();
        connector.setThermalResistance(200.0);
        connector.addConnectedExchanger(this.getHeatExchanger(side));
        connector.addConnectedExchanger(this.getHeatExchanger(side.func_176734_d()));
        return connector;
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return null;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            for (IHeatExchangerLogic heatExchanger : this.heatExchangers) {
                heatExchanger.tick();
            }
            if (this.redstoneAllows()) {
                this.connector1.tick();
                this.connector2.tick();
                this.equaliseHeat(Direction.NORTH, this.generatePressure(Direction.NORTH));
                this.equaliseHeat(Direction.EAST, this.generatePressure(Direction.EAST));
            }
            for (int i = 0; i < this.heatExchangers.length; ++i) {
                this.syncedTemperatures[i].tick();
            }
        }
    }

    public IHeatExchangerLogic getHeatExchanger(Direction side) {
        return this.heatExchangers[side.func_176736_b()];
    }

    private void equaliseHeat(Direction side, double airProduced) {
        double heatToAdd = airProduced / 5.0;
        IHeatExchangerLogic h1 = this.getHeatExchanger(side);
        IHeatExchangerLogic h2 = this.getHeatExchanger(side.func_176734_d());
        if (h1.getTemperature() > h2.getTemperature()) {
            h1.addHeat(-heatToAdd);
            h2.addHeat(heatToAdd);
        } else {
            h1.addHeat(heatToAdd);
            h2.addHeat(-heatToAdd);
        }
    }

    public double airProduced(Direction side) {
        if (this.field_145850_b.field_72995_K) {
            double diff = Math.abs(this.getHeatExchanger(side).getTemperatureAsInt() - this.getHeatExchanger(side.func_176734_d()).getTemperatureAsInt());
            return diff < 10.0 ? 0.0 : diff * 0.05;
        }
        double diff = Math.abs(this.getHeatExchanger(side).getTemperature() - this.getHeatExchanger(side.func_176734_d()).getTemperature());
        return diff < 10.0 ? 0.0 : diff * 0.05;
    }

    private double generatePressure(Direction side) {
        int sideIdx;
        double airProduced = this.airProduced(side);
        int n = sideIdx = side.func_176740_k() == Direction.Axis.Z ? 1 : 0;
        this.airGenerated[n] = this.airGenerated[n] + airProduced;
        if (this.airGenerated[sideIdx] > 1.0) {
            int toAdd = (int)this.airGenerated[sideIdx];
            this.addAir(toAdd);
            int n2 = sideIdx;
            this.airGenerated[n2] = this.airGenerated[n2] - (double)toAdd;
        }
        return airProduced;
    }

    @Override
    public boolean canConnectPneumatic(Direction side) {
        return side.func_176740_k() == Direction.Axis.Y;
    }

    @Override
    public TintColor getColorForTintIndex(int tintIndex) {
        return HeatUtil.getColourForTemperature(this.syncedTemperatures[tintIndex].getSyncedTemp());
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        for (int i = 0; i < 4; ++i) {
            tag.func_218657_a("side" + i, this.heatExchangers[i].serializeNBT());
        }
        tag.func_218657_a("connector1", this.connector1.serializeNBT());
        tag.func_218657_a("connector2", this.connector2.serializeNBT());
        tag.func_74768_a("redstoneMode", this.redstoneMode);
        return tag;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        for (int i = 0; i < 4; ++i) {
            this.heatExchangers[i].deserializeNBT((INBT)tag.func_74775_l("side" + i));
        }
        this.connector1.deserializeNBT((INBT)tag.func_74775_l("connector1"));
        this.connector2.deserializeNBT((INBT)tag.func_74775_l("connector2"));
        this.redstoneMode = tag.func_74762_e("redstoneMode");
    }

    @Override
    protected boolean shouldRerenderChunkOnDescUpdate() {
        return true;
    }

    @Override
    public void handleGUIButtonPress(String guiID, boolean shiftHeld, PlayerEntity player) {
        if (guiID.equals("redstone")) {
            ++this.redstoneMode;
            if (this.redstoneMode > 2) {
                this.redstoneMode = 0;
            }
        }
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    public ITextComponent func_145748_c_() {
        return this.getDisplayNameInternal();
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerThermalCompressor(i, playerInventory, this.func_174877_v());
    }

    @Override
    public LazyOptional<IHeatExchangerLogic> getHeatCap(Direction side) {
        if (side == null) {
            return LazyOptional.of(() -> this.dummyExchanger);
        }
        return side.func_176740_k() == Direction.Axis.Y ? LazyOptional.empty() : this.heatCaps.get(side.func_176736_b());
    }
}

