/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.lib.Log;

public enum DeferredTaskManager {
    INSTANCE;

    private final BlockingQueue<Runnable> taskQueue = new LinkedBlockingDeque<Runnable>();

    public static DeferredTaskManager getInstance() {
        return INSTANCE;
    }

    public void scheduleTask(@Nonnull Runnable task) {
        this.taskQueue.add(Objects.requireNonNull(task));
    }

    public void runTasks() {
        while (this.taskQueue.peek() != null) {
            try {
                this.taskQueue.take().run();
            }
            catch (Exception e) {
                Log.error("Deferred task threw an expection: " + e.getMessage(), new Object[0]);
                e.printStackTrace();
            }
        }
    }
}

