/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import joptsimple.internal.Strings;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import me.desht.pneumaticcraft.common.progwidgets.IEntityProvider;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetText;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.PaintingEntity;
import net.minecraft.entity.item.minecart.MinecartEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.IForgeShearable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;

public class EntityFilter
implements Predicate<Entity>,
com.google.common.base.Predicate<Entity> {
    private static final Pattern ELEMENT_DIVIDER = Pattern.compile(";");
    private static final Pattern ELEMENT_SUBDIVIDER = Pattern.compile("[(),]");
    private static final EntityFilter ALLOW_FILTER = EntityFilter.allow();
    private static final EntityFilter DENY_FILTER = EntityFilter.deny();
    private static final Map<String, Class<?>> ENTITY_CLASSES = new HashMap();
    private final List<EntityMatcher> matchers = new ArrayList<EntityMatcher>();
    private final boolean sense;
    private final String rawFilter;
    private static final Set<String> DYE_COLORS;

    public EntityFilter(String filter) {
        if (filter.startsWith("!")) {
            filter = filter.substring(1);
            this.sense = false;
        } else {
            this.sense = true;
        }
        this.rawFilter = filter;
        if (!filter.isEmpty()) {
            Arrays.stream(ELEMENT_DIVIDER.split(filter)).map(x$0 -> new EntityMatcher((String)x$0)).forEach(this.matchers::add);
        }
    }

    public static <T extends IProgWidget & IEntityProvider> EntityFilter fromProgWidget(T widget, boolean whitelist) {
        if (widget.getParameters().size() > 1) {
            int pos = ((IEntityProvider)widget).getEntityFilterPosition();
            IProgWidget w = widget.getConnectedParameters()[whitelist ? pos : widget.getParameters().size() + pos];
            if (w instanceof ProgWidgetText) {
                ArrayList<String> l = new ArrayList<String>();
                while (w instanceof ProgWidgetText) {
                    String str = ((ProgWidgetText)w).string;
                    Validate.isTrue((!str.startsWith("!") ? 1 : 0) != 0, (String)"'!' negation can't be used here (put blacklist filters on left of widget)", (Object[])new Object[0]);
                    l.add(str);
                    w = w.getConnectedParameters()[0];
                }
                return new EntityFilter(Strings.join(l, (String)";"));
            }
        }
        return whitelist ? ALLOW_FILTER : DENY_FILTER;
    }

    public static EntityFilter fromString(String s) {
        try {
            return new EntityFilter(s);
        }
        catch (Exception e) {
            Log.warning("ignoring invalid filter: " + s, new Object[0]);
            return null;
        }
    }

    public static EntityFilter allow() {
        return new ConstantEntityFilter(true);
    }

    public static EntityFilter deny() {
        return new ConstantEntityFilter(false);
    }

    public String toString() {
        return this.sense ? this.rawFilter : "!" + this.rawFilter;
    }

    public boolean apply(@Nullable Entity input) {
        return this.test(input);
    }

    @Override
    public boolean test(Entity entity) {
        if (this.matchers.isEmpty()) {
            return true;
        }
        for (EntityMatcher m : this.matchers) {
            if (!m.test(entity)) continue;
            return this.sense;
        }
        return !this.sense;
    }

    private static String wildcardToRegex(String wildcard) {
        StringBuilder s = new StringBuilder(wildcard.length());
        s.append('^');
        int is = wildcard.length();
        block5: for (int i = 0; i < is; ++i) {
            char c = wildcard.charAt(i);
            switch (c) {
                case '*': {
                    s.append(".*");
                    continue block5;
                }
                case '?': {
                    s.append(".");
                    continue block5;
                }
                case '$': 
                case '(': 
                case ')': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    s.append("\\").append(c);
                    continue block5;
                }
                default: {
                    s.append(c);
                }
            }
        }
        s.append('$');
        return s.toString();
    }

    static /* synthetic */ Set access$100() {
        return DYE_COLORS;
    }

    static {
        ENTITY_CLASSES.put("mob", IMob.class);
        ENTITY_CLASSES.put("animal", AnimalEntity.class);
        ENTITY_CLASSES.put("living", LivingEntity.class);
        ENTITY_CLASSES.put("player", PlayerEntity.class);
        ENTITY_CLASSES.put("item", ItemEntity.class);
        ENTITY_CLASSES.put("drone", EntityDrone.class);
        ENTITY_CLASSES.put("boat", BoatEntity.class);
        ENTITY_CLASSES.put("minecart", MinecartEntity.class);
        ENTITY_CLASSES.put("painting", PaintingEntity.class);
        ENTITY_CLASSES.put("orb", ExperienceOrbEntity.class);
        DYE_COLORS = new HashSet<String>();
        for (DyeColor d : DyeColor.values()) {
            DYE_COLORS.add(d.func_176762_d());
        }
    }

    public static class ConstantEntityFilter
    extends EntityFilter {
        private final boolean allow;

        private ConstantEntityFilter(boolean allow) {
            super("");
            this.allow = allow;
        }

        @Override
        public boolean test(Entity entity) {
            return this.allow;
        }
    }

    private static class EntityMatcher
    implements Predicate<Entity> {
        private final Pattern regex;
        private final Class<?> typeClass;
        private final List<Pair<Modifier, String>> modifiers = new ArrayList<Pair<Modifier, String>>();

        private EntityMatcher(String element) {
            String[] splits = ELEMENT_SUBDIVIDER.split(element);
            for (int i = 0; i < splits.length; ++i) {
                splits[i] = splits[i].trim();
            }
            if (splits[0].startsWith("@")) {
                String sub = splits[0].substring(1);
                if (StringUtils.countMatches((CharSequence)element, (CharSequence)"(") != StringUtils.countMatches((CharSequence)element, (CharSequence)")")) {
                    throw new IllegalArgumentException("Mismatched opening/closing braces");
                }
                this.typeClass = (Class)ENTITY_CLASSES.get(sub);
                Validate.isTrue((this.typeClass != null ? 1 : 0) != 0, (String)("Unknown entity type specifier: @" + sub), (Object[])new Object[0]);
                this.regex = null;
            } else {
                this.typeClass = null;
                this.regex = Pattern.compile(EntityFilter.wildcardToRegex(splits[0]), 2);
            }
            for (int i = 1; i < splits.length; ++i) {
                Modifier m;
                String[] modifier = splits[i].split("=");
                Validate.isTrue((modifier.length == 2 ? 1 : 0) != 0, (String)("Invalid modifier syntax: " + splits[i]), (Object[])new Object[0]);
                try {
                    m = Modifier.valueOf(modifier[0].toUpperCase());
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Unknown modifier: " + modifier[0]);
                }
                Validate.isTrue((boolean)m.isValid(modifier[1]), (String)("'" + modifier[1] + "' is not a valid value for modifier '" + modifier[0] + "'.  Valid values are: " + Strings.join((Iterable)m.vals, (String)",")), (Object[])new Object[0]);
                this.modifiers.add((Pair<Modifier, String>)Pair.of((Object)((Object)m), (Object)modifier[1]));
            }
        }

        @Override
        public boolean test(Entity entity) {
            boolean ok = false;
            if (this.typeClass != null) {
                ok = this.typeClass.isAssignableFrom(entity.getClass());
            } else if (this.regex != null) {
                Matcher m = this.regex.matcher(entity.func_200200_C_().getString());
                ok = m.matches();
            }
            return ok && this.matchModifiers(entity);
        }

        private boolean matchModifiers(Entity entity) {
            for (Pair<Modifier, String> pair : this.modifiers) {
                String val;
                Modifier modifier = (Modifier)((Object)pair.getLeft());
                if (modifier.match(entity, val = (String)pair.getRight())) continue;
                return false;
            }
            return true;
        }
    }

    private static enum Modifier {
        AGE((Set<String>)ImmutableSet.of((Object)"adult", (Object)"baby")),
        BREEDABLE((Set<String>)ImmutableSet.of((Object)"yes", (Object)"no")),
        SHEARABLE((Set<String>)ImmutableSet.of((Object)"yes", (Object)"no")),
        COLOR(EntityFilter.access$100());

        private final Set<String> vals;

        private Modifier(Set<String> v) {
            this.vals = v;
        }

        boolean isValid(String s) {
            return this.vals.contains(s);
        }

        boolean match(Entity entity, String val) {
            switch (this) {
                case AGE: {
                    if (!(entity instanceof AgeableEntity)) break;
                    return ((AgeableEntity)entity).func_70874_b() >= 0 ? val.equalsIgnoreCase("adult") : val.equalsIgnoreCase("baby");
                }
                case BREEDABLE: {
                    if (!(entity instanceof AnimalEntity)) break;
                    return ((AnimalEntity)entity).func_70874_b() == 0 ? val.equalsIgnoreCase("yes") : val.equalsIgnoreCase("no");
                }
                case SHEARABLE: {
                    if (!(entity instanceof IForgeShearable)) break;
                    return ((IForgeShearable)entity).isShearable(new ItemStack((IItemProvider)Items.field_151097_aZ), entity.func_130014_f_(), entity.func_233580_cy_()) ? val.equalsIgnoreCase("yes") : val.equalsIgnoreCase("no");
                }
                case COLOR: {
                    if (entity instanceof SheepEntity) {
                        return ((SheepEntity)entity).func_175509_cj().func_176762_d().equalsIgnoreCase(val);
                    }
                    if (entity instanceof WolfEntity) {
                        return ((WolfEntity)entity).func_175546_cu().func_176762_d().equalsIgnoreCase(val);
                    }
                    if (!(entity instanceof CatEntity)) break;
                    return ((CatEntity)entity).func_213414_ei().func_176762_d().equalsIgnoreCase(val);
                }
            }
            return false;
        }
    }
}

