/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.entity.projectile.EntityTumblingBlock;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSetEntityMotion;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import me.desht.pneumaticcraft.common.particle.AirParticleData;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.ExperienceBottleEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.item.minecart.MinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.EggEntity;
import net.minecraft.entity.projectile.FireballEntity;
import net.minecraft.entity.projectile.FireworkRocketEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.entity.projectile.SmallFireballEntity;
import net.minecraft.entity.projectile.SnowballEntity;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BoatItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MinecartItem;
import net.minecraft.item.PotionItem;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.PacketDistributor;

public class ItemLaunching {
    public static void launchEntity(Entity launchedEntity, Vector3d initialPos, Vector3d velocity, boolean doSpawn) {
        World world = launchedEntity.func_130014_f_();
        if (launchedEntity.func_184187_bx() != null) {
            launchedEntity.func_184210_p();
        }
        launchedEntity.func_70107_b(initialPos.field_72450_a, initialPos.field_72448_b, initialPos.field_72449_c);
        NetworkHandler.sendToAllAround((Object)new PacketSetEntityMotion(launchedEntity, velocity), new PacketDistributor.TargetPoint(initialPos.field_72450_a, initialPos.field_72448_b, initialPos.field_72449_c, 64.0, world.func_234923_W_()));
        if (launchedEntity instanceof FireballEntity) {
            FireballEntity fireball = (FireballEntity)launchedEntity;
            fireball.field_70232_b = velocity.field_72450_a * 0.05;
            fireball.field_70233_c = velocity.field_72448_b * 0.05;
            fireball.field_70230_d = velocity.field_72449_c * 0.05;
        } else {
            launchedEntity.func_213317_d(velocity);
        }
        launchedEntity.func_230245_c_(false);
        launchedEntity.field_70123_F = false;
        launchedEntity.field_70124_G = false;
        if (doSpawn && !world.field_72995_K) {
            world.func_217376_c(launchedEntity);
        }
        for (int i = 0; i < 5; ++i) {
            double velX = velocity.field_72450_a * 0.4 + (world.field_73012_v.nextGaussian() - 0.5) * 0.05;
            double velY = velocity.field_72448_b * 0.4 + (world.field_73012_v.nextGaussian() - 0.5) * 0.05;
            double velZ = velocity.field_72449_c * 0.4 + (world.field_73012_v.nextGaussian() - 0.5) * 0.05;
            NetworkHandler.sendToAllAround(new PacketSpawnParticle(AirParticleData.DENSE, initialPos.field_72450_a, initialPos.field_72448_b, initialPos.field_72449_c, velX, velY, velZ), world);
        }
        world.func_184148_a(null, initialPos.field_72450_a, initialPos.field_72448_b, initialPos.field_72449_c, (SoundEvent)ModSounds.AIR_CANNON.get(), SoundCategory.BLOCKS, 1.0f, world.field_73012_v.nextFloat() / 4.0f + 0.75f);
    }

    public static Entity getEntityToLaunch(World world, ItemStack stack, PlayerEntity player, boolean dispenserLike, boolean fallingBlocks) {
        Item item = stack.func_77973_b();
        if (dispenserLike) {
            if (item == Blocks.field_150335_W.func_199767_j()) {
                TNTEntity tnt = new TNTEntity(world, 0.0, 0.0, 0.0, (LivingEntity)player);
                tnt.func_184534_a(80);
                return tnt;
            }
            if (item == Items.field_151062_by) {
                return new ExperienceBottleEntity(world, (LivingEntity)player);
            }
            if (item instanceof PotionItem) {
                PotionEntity potionEntity = new PotionEntity(world, (LivingEntity)player);
                potionEntity.func_213884_b(stack);
                return potionEntity;
            }
            if (item instanceof ArrowItem) {
                return ((ArrowItem)item).func_200887_a(world, stack, (LivingEntity)player);
            }
            if (item == Items.field_151110_aK) {
                return new EggEntity(world, (LivingEntity)player);
            }
            if (item == Items.field_151059_bz) {
                return new SmallFireballEntity(world, (LivingEntity)player, 0.0, 0.0, 0.0);
            }
            if (item == Items.field_151126_ay) {
                return new SnowballEntity(world, (LivingEntity)player);
            }
            if (item instanceof SpawnEggItem && world instanceof ServerWorld) {
                EntityType type = ((SpawnEggItem)item).func_208076_b(stack.func_77978_p());
                Entity e = type.func_220331_a((ServerWorld)world, stack, player, player.func_233580_cy_(), SpawnReason.SPAWN_EGG, false, false);
                if (e instanceof LivingEntity && stack.func_82837_s()) {
                    e.func_200203_b(stack.func_200301_q());
                }
                return e;
            }
            if (item instanceof MinecartItem) {
                return MinecartEntity.func_184263_a((World)world, (double)0.0, (double)0.0, (double)0.0, (AbstractMinecartEntity.Type)((MinecartItem)item).field_77841_a);
            }
            if (item instanceof BoatItem) {
                return new BoatEntity(world, 0.0, 0.0, 0.0);
            }
            if (item == Items.field_196152_dE) {
                return new FireworkRocketEntity(world, 0.0, 0.0, 0.0, stack);
            }
        }
        if (fallingBlocks && item instanceof BlockItem) {
            return new EntityTumblingBlock(world, (LivingEntity)player, 0.0, 0.0, 0.0, stack);
        }
        ItemEntity e = new ItemEntity(world, 0.0, 0.0, 0.0, stack);
        e.func_174867_a(20);
        return e;
    }
}

