/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util.fakeplayer;

import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.drone.IDrone;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.items.ItemStackHandler;

public class DroneItemHandler
extends ItemStackHandler {
    private final IDrone holder;
    private int useableSlots;
    private ItemStack prevHeldStack = ItemStack.field_190927_a;
    private boolean fakePlayerReady = false;

    public DroneItemHandler(IDrone holder, int useableSlots) {
        super(36);
        this.holder = holder;
        this.useableSlots = useableSlots;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (slot >= this.useableSlots) {
            return stack;
        }
        ItemStack res = super.insertItem(slot, stack, simulate);
        if (res.func_190916_E() != stack.func_190916_E() && !simulate) {
            this.copyItemToFakePlayer(slot);
        }
        return res;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot >= this.useableSlots) {
            return ItemStack.field_190927_a;
        }
        ItemStack res = super.extractItem(slot, amount, simulate);
        if (!res.func_190926_b() && !simulate) {
            this.copyItemToFakePlayer(slot);
        }
        return res;
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        if (slot >= this.useableSlots) {
            return;
        }
        super.setStackInSlot(slot, stack);
        this.copyItemToFakePlayer(slot);
    }

    public int getSlots() {
        return Math.min(this.useableSlots, super.getSlots());
    }

    public void setUseableSlots(int useableSlots) {
        this.useableSlots = useableSlots;
    }

    protected boolean isFakePlayerReady() {
        return this.fakePlayerReady;
    }

    public void setFakePlayerReady() {
        if (!this.fakePlayerReady && !this.holder.world().field_72995_K) {
            this.fakePlayerReady = true;
            for (int slot = 0; slot < this.getSlots(); ++slot) {
                this.copyItemToFakePlayer(slot);
            }
        }
    }

    public void copyItemToFakePlayer(int slot) {
        if (!this.fakePlayerReady) {
            return;
        }
        FakePlayer fakePlayer = this.holder.getFakePlayer();
        if (slot >= fakePlayer.field_71071_by.field_70462_a.size()) {
            return;
        }
        ItemStack newStack = this.getStackInSlot(slot);
        fakePlayer.field_71071_by.field_70462_a.set(slot, (Object)newStack);
        if (slot == fakePlayer.field_71071_by.field_70461_c) {
            fakePlayer.func_184611_a(Hand.MAIN_HAND, newStack);
            if (!this.prevHeldStack.func_190926_b()) {
                fakePlayer.func_233645_dx_().func_233785_a_(this.prevHeldStack.func_111283_C(EquipmentSlotType.MAINHAND));
            }
            if (!newStack.func_190926_b()) {
                fakePlayer.func_233645_dx_().func_233793_b_(newStack.func_111283_C(EquipmentSlotType.MAINHAND));
            }
            this.prevHeldStack = newStack.func_77946_l();
        }
    }
}

