/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util.upgrade;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.common.core.ModEntities;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.sensor.SensorHandler;
import me.desht.pneumaticcraft.common.util.upgrade.ApplicableUpgradesDB;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntityType;

public class UpgradesDBSetup {
    private static final int MAX_VOLUME = 25;
    private static final Builder DRONE_UPGRADES = new Builder().with(EnumUpgrade.VOLUME, 25).with(EnumUpgrade.INVENTORY, 35).with(EnumUpgrade.ITEM_LIFE, 10).with(EnumUpgrade.SECURITY, 3).with(EnumUpgrade.SPEED, 10).with(EnumUpgrade.MINIGUN, 1).with(EnumUpgrade.MAGNET, 6).with(EnumUpgrade.RANGE, 16);
    private static final Builder BASIC_DRONE_UPGRADES = new Builder().with(EnumUpgrade.VOLUME, 25).with(EnumUpgrade.ITEM_LIFE, 10).with(EnumUpgrade.SECURITY, 3).with(EnumUpgrade.SPEED, 10).with(EnumUpgrade.MAGNET, 6).with(EnumUpgrade.STANDBY, 1);
    private static final Builder GUARD_DRONE_UPGRADES = new Builder(BASIC_DRONE_UPGRADES).with(EnumUpgrade.MAGNET, 0).with(EnumUpgrade.MINIGUN, 1).with(EnumUpgrade.RANGE, 16);
    private static final Builder COLLECTOR_DRONE_UPGRADES = new Builder(BASIC_DRONE_UPGRADES).with(EnumUpgrade.RANGE, 16).with(EnumUpgrade.INVENTORY, 35);

    public static void init() {
        UpgradesDBSetup.initTileEntities();
        UpgradesDBSetup.initEntities();
        UpgradesDBSetup.initItems();
    }

    private static void initItems() {
        ApplicableUpgradesDB db = ApplicableUpgradesDB.getInstance();
        db.addApplicableUpgrades((Item)ModItems.DRONE.get(), DRONE_UPGRADES);
        db.addApplicableUpgrades((Item)ModItems.LOGISTICS_DRONE.get(), BASIC_DRONE_UPGRADES);
        db.addApplicableUpgrades((Item)ModItems.HARVESTING_DRONE.get(), BASIC_DRONE_UPGRADES);
        db.addApplicableUpgrades((Item)ModItems.GUARD_DRONE.get(), GUARD_DRONE_UPGRADES);
        db.addApplicableUpgrades((Item)ModItems.COLLECTOR_DRONE.get(), COLLECTOR_DRONE_UPGRADES);
        db.addApplicableUpgrades((Item)ModItems.MINIGUN.get(), new Builder().with(EnumUpgrade.SPEED, 3).with(EnumUpgrade.RANGE, 6).with(EnumUpgrade.DISPENSER, 3).with(EnumUpgrade.ITEM_LIFE, 4).with(EnumUpgrade.ENTITY_TRACKER, 4).with(EnumUpgrade.SECURITY, 1));
        db.addApplicableUpgrades((Item)ModItems.JACKHAMMER.get(), new Builder().with(EnumUpgrade.SPEED, 10).with(EnumUpgrade.VOLUME, 25));
        List<Builder> armor = Arrays.asList(new Builder(), new Builder(), new Builder(), new Builder());
        for (EquipmentSlotType slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
            ArmorUpgradeRegistry.getInstance().getHandlersForSlot(slot).forEach(handler -> Arrays.stream(handler.getRequiredUpgrades()).forEach(upgrade -> ((Builder)armor.get(slot.func_188454_b())).with((EnumUpgrade)((Object)((Object)upgrade)), handler.getMaxInstallableUpgrades((EnumUpgrade)((Object)((Object)upgrade))))));
            armor.get(slot.func_188454_b()).with(EnumUpgrade.SPEED, 10).with(EnumUpgrade.VOLUME, 25).with(EnumUpgrade.ITEM_LIFE, 5).with(EnumUpgrade.ARMOR, 4).with(EnumUpgrade.THAUMCRAFT, 1);
        }
        armor.get(EquipmentSlotType.HEAD.func_188454_b()).with(EnumUpgrade.RANGE, 5).with(EnumUpgrade.SECURITY, 64);
        armor.get(EquipmentSlotType.CHEST.func_188454_b()).with(EnumUpgrade.SECURITY, 1);
        armor.get(EquipmentSlotType.FEET.func_188454_b()).with(EnumUpgrade.FLIPPERS, 1);
        db.addApplicableUpgrades((Item)ModItems.PNEUMATIC_HELMET.get(), armor.get(EquipmentSlotType.HEAD.func_188454_b()));
        db.addApplicableUpgrades((Item)ModItems.PNEUMATIC_CHESTPLATE.get(), armor.get(EquipmentSlotType.CHEST.func_188454_b()));
        db.addApplicableUpgrades((Item)ModItems.PNEUMATIC_LEGGINGS.get(), armor.get(EquipmentSlotType.LEGS.func_188454_b()));
        db.addApplicableUpgrades((Item)ModItems.PNEUMATIC_BOOTS.get(), armor.get(EquipmentSlotType.FEET.func_188454_b()));
    }

    private static void initEntities() {
        ApplicableUpgradesDB db = ApplicableUpgradesDB.getInstance();
        db.addApplicableUpgrades((EntityType)ModEntities.DRONE.get(), DRONE_UPGRADES);
        db.addApplicableUpgrades((EntityType)ModEntities.LOGISTICS_DRONE.get(), BASIC_DRONE_UPGRADES);
        db.addApplicableUpgrades((EntityType)ModEntities.HARVESTING_DRONE.get(), BASIC_DRONE_UPGRADES);
        db.addApplicableUpgrades((EntityType)ModEntities.GUARD_DRONE.get(), BASIC_DRONE_UPGRADES);
        db.addApplicableUpgrades((EntityType)ModEntities.COLLECTOR_DRONE.get(), COLLECTOR_DRONE_UPGRADES);
    }

    private static void initTileEntities() {
        ApplicableUpgradesDB db = ApplicableUpgradesDB.getInstance();
        db.addApplicableUpgrades((TileEntityType)ModTileEntities.AIR_CANNON.get(), new Builder().with(EnumUpgrade.SECURITY, 1).with(EnumUpgrade.VOLUME, 25).with(EnumUpgrade.RANGE, 8).with(EnumUpgrade.ITEM_LIFE, 8).with(EnumUpgrade.ENTITY_TRACKER, 1).with(EnumUpgrade.BLOCK_TRACKER, 1).with(EnumUpgrade.DISPENSER, 1).with(EnumUpgrade.SPEED, 10));
        db.addApplicableUpgrades((TileEntityType)ModTileEntities.AIR_COMPRESSOR.get(), new Builder().with(EnumUpgrade.SECURITY, 1).with(EnumUpgrade.VOLUME, 25).with(EnumUpgrade.SPEED, 10));
        db.addApplicableUpgrades((TileEntityType)ModTileEntities.ADVANCED_AIR_COMPRESSOR.get(), new Builder().with(EnumUpgrade.SECURITY, 1).with(EnumUpgrade.VOLUME, 25).with(EnumUpgrade.SPEED, 10));
        db.addApplicableUpgrades((TileEntityType)ModTileEntities.ASSEMBLY_CONTROLLER.get(), new Builder().with(EnumUpgrade.SECURITY, 1).with(EnumUpgrade.VOLUME, 25).with(EnumUpgrade.SPEED, 10));
        db.addApplicableUpgrades((TileEntityType)ModTileEntities.CHARGING_STATION.get(), new Builder().with(EnumUpgrade.SECURITY, 1).with(EnumUpgrade.VOLUME, 25).with(EnumUpgrade.SPEED, 10).with(EnumUpgrade.DISPENSER, 1));
        db.addApplicableUpgrades((TileEntityType)ModTileEntities.ELEVATOR_BASE.get(), new Builder().with(EnumUpgrade.SECURITY, 1).with(EnumUpgrade.VOLUME, 25).with(EnumUpgrade.SPEED, 10).with(EnumUpgrade.CHARGING, 4));
        db.addApplicableUpgrades((TileEntityType)ModTileEntities.PNEUMATIC_DOOR_BASE.get(), new Builder().with(EnumUpgrade.SECURITY, 1).with(EnumUpgrade.VOLUME, 25).with(EnumUpgrade.SPEED, 10).with(EnumUpgrade.RANGE, 8));
        db.addApplicableUpgrades((TileEntityType)ModTileEntities.PRESSURE_CHAMBER_INTERFACE.get(), new Builder().with(EnumUpgrade.SPEED, 10).with(EnumUpgrade.DISPENSER, 1));
        db.addApplicableUpgrades((TileEntityType)ModTileEntities.PRESSURE_CHAMBER_VALVE.get(), new Builder().with(EnumUpgrade.SECURITY, 1).with(EnumUpgrade.VOLUME, 25));
        db.addApplicableUpgrades((TileEntityType)ModTileEntities.VACUUM_PUMP.get(), new Builder().with(EnumUpgrade.SECURITY, 1).with(EnumUpgrade.VOLUME, 25).with(EnumUpgrade.SPEED, 10));
        db.addApplicableUpgrades((TileEntityType)ModTileEntities.UV_LIGHT_BOX.get(), new Builder().with(EnumUpgrade.SECURITY, 1).with(EnumUpgrade.VOLUME, 25).with(EnumUpgrade.DISPENSER, 1).with(EnumUpgrade.SPEED, 10));
        db.addApplicableUpgrades((TileEntityType)ModTileEntities.SECURITY_STATION.get(), new Builder().with(EnumUpgrade.ENTITY_TRACKER, 4).with(EnumUpgrade.SECURITY, 64).with(EnumUpgrade.RANGE, 14));
        db.addApplicableUpgrades((TileEntityType)ModTileEntities.AERIAL_INTERFACE.get(), new Builder().with(EnumUpgrade.SECURITY, 1).with(EnumUpgrade.VOLUME, 25).with(EnumUpgrade.DISPENSER, 1));
        db.addApplicableUpgrades((TileEntityType)ModTileEntities.ELECTROSTATIC_COMPRESSOR.get(), new Builder().with(EnumUpgrade.SECURITY, 1).with(EnumUpgrade.VOLUME, 25));
        db.addApplicableUpgrades((TileEntityType)ModTileEntities.OMNIDIRECTIONAL_HOPPER.get(), new Builder().with(EnumUpgrade.SPEED, 11).with(EnumUpgrade.CREATIVE, 1).with(EnumUpgrade.DISPENSER, 1));
        db.addApplicableUpgrades((TileEntityType)ModTileEntities.LIQUID_HOPPER.get(), new Builder().with(EnumUpgrade.SPEED, 11).with(EnumUpgrade.CREATIVE, 1).with(EnumUpgrade.DISPENSER, 1));
        db.addApplicableUpgrades((TileEntityType)ModTileEntities.LIQUID_COMPRESSOR.get(), new Builder().with(EnumUpgrade.SECURITY, 1).with(EnumUpgrade.VOLUME, 25).with(EnumUpgrade.SPEED, 10));
        db.addApplicableUpgrades((TileEntityType)ModTileEntities.ADVANCED_LIQUID_COMPRESSOR.get(), new Builder().with(EnumUpgrade.SECURITY, 1).with(EnumUpgrade.VOLUME, 25).with(EnumUpgrade.SPEED, 10));
        db.addApplicableUpgrades((TileEntityType)ModTileEntities.PROGRAMMABLE_CONTROLLER.get(), new Builder().with(EnumUpgrade.SECURITY, 1).with(EnumUpgrade.VOLUME, 25).with(EnumUpgrade.SPEED, 10).with(EnumUpgrade.INVENTORY, 35));
        db.addApplicableUpgrades((TileEntityType)ModTileEntities.GAS_LIFT.get(), new Builder().with(EnumUpgrade.SECURITY, 1).with(EnumUpgrade.VOLUME, 25).with(EnumUpgrade.SPEED, 10).with(EnumUpgrade.DISPENSER, 1));
        db.addApplicableUpgrades((TileEntityType)ModTileEntities.THERMOPNEUMATIC_PROCESSING_PLANT.get(), new Builder().with(EnumUpgrade.SECURITY, 1).with(EnumUpgrade.VOLUME, 25).with(EnumUpgrade.DISPENSER, 1));
        db.addApplicableUpgrades((TileEntityType)ModTileEntities.SENTRY_TURRET.get(), new Builder().with(EnumUpgrade.RANGE, 16));
        db.addApplicableUpgrades((TileEntityType)ModTileEntities.FLUX_COMPRESSOR.get(), new Builder().with(EnumUpgrade.SECURITY, 1).with(EnumUpgrade.VOLUME, 25).with(EnumUpgrade.SPEED, 10));
        db.addApplicableUpgrades((TileEntityType)ModTileEntities.PNEUMATIC_DYNAMO.get(), new Builder().with(EnumUpgrade.SECURITY, 1).with(EnumUpgrade.VOLUME, 25).with(EnumUpgrade.SPEED, 10));
        db.addApplicableUpgrades((TileEntityType)ModTileEntities.THERMAL_COMPRESSOR.get(), new Builder().with(EnumUpgrade.SECURITY, 1).with(EnumUpgrade.VOLUME, 25));
        db.addApplicableUpgrades((TileEntityType)ModTileEntities.TANK_SMALL.get(), new Builder().with(EnumUpgrade.SPEED, 7).with(EnumUpgrade.DISPENSER, 1));
        db.addApplicableUpgrades((TileEntityType)ModTileEntities.TANK_MEDIUM.get(), new Builder().with(EnumUpgrade.SPEED, 7).with(EnumUpgrade.DISPENSER, 1));
        db.addApplicableUpgrades((TileEntityType)ModTileEntities.TANK_LARGE.get(), new Builder().with(EnumUpgrade.SPEED, 7).with(EnumUpgrade.DISPENSER, 1));
        db.addApplicableUpgrades((TileEntityType)ModTileEntities.SMART_CHEST.get(), new Builder().with(EnumUpgrade.SPEED, 9).with(EnumUpgrade.DISPENSER, 1).with(EnumUpgrade.MAGNET, 1).with(EnumUpgrade.RANGE, 4));
        db.addApplicableUpgrades((TileEntityType)ModTileEntities.FLUID_MIXER.get(), new Builder().with(EnumUpgrade.VOLUME, 25).with(EnumUpgrade.SECURITY, 1).with(EnumUpgrade.DISPENSER, 1));
        Builder sensorBuilder = new Builder();
        SensorHandler.getInstance().getUniversalSensorUpgrades().forEach(upgrade -> sensorBuilder.with((EnumUpgrade)((Object)upgrade), 1));
        sensorBuilder.with(EnumUpgrade.RANGE, 64).with(EnumUpgrade.SECURITY, 1).with(EnumUpgrade.VOLUME, 25);
        db.addApplicableUpgrades((TileEntityType)ModTileEntities.UNIVERSAL_SENSOR.get(), sensorBuilder);
    }

    static class Builder {
        private final List<Integer> l;

        Builder() {
            this.l = new ArrayList<Integer>(Collections.nCopies(EnumUpgrade.values().length, 0));
        }

        Builder(Builder copy) {
            this.l = new ArrayList<Integer>(copy.upgrades());
        }

        Builder with(EnumUpgrade upgrade, int amount) {
            this.l.set(upgrade.ordinal(), amount);
            return this;
        }

        List<Integer> upgrades() {
            return this.l;
        }

        public int[] build() {
            return this.l.stream().mapToInt(Integer::intValue).toArray();
        }
    }
}

