/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.villages;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.LegacySingleJigsawPiece;
import net.minecraft.world.gen.feature.structure.DesertVillagePools;
import net.minecraft.world.gen.feature.structure.PlainsVillagePools;
import net.minecraft.world.gen.feature.structure.SavannaVillagePools;
import net.minecraft.world.gen.feature.structure.SnowyVillagePools;
import net.minecraft.world.gen.feature.structure.TaigaVillagePools;
import net.minecraft.world.gen.feature.template.ProcessorLists;

public class VillageStructures {
    public static void init() {
        if (PNCConfig.Common.Villagers.addMechanicHouse) {
            PlainsVillagePools.func_214744_a();
            SavannaVillagePools.func_214745_a();
            TaigaVillagePools.func_214806_a();
            DesertVillagePools.func_222739_a();
            SnowyVillagePools.func_214746_a();
            for (String biome : new String[]{"plains", "desert", "savanna", "taiga", "snowy"}) {
                VillageStructures.addToPool(new ResourceLocation("village/" + biome + "/houses"), PneumaticCraftUtils.RL("villages/mechanic_house_" + biome), 8);
            }
        }
    }

    private static void addToPool(ResourceLocation pool, ResourceLocation toAdd, int weight) {
        JigsawPattern old = (JigsawPattern)WorldGenRegistries.field_243656_h.func_82594_a(pool);
        ImmutableList shuffled = old != null ? old.func_214943_b(new Random()) : ImmutableList.of();
        List newPieces = shuffled.stream().map(p -> new Pair(p, (Object)1)).collect(Collectors.toList());
        newPieces.add(new Pair((Object)new LegacySingleJigsawPiece(Either.left((Object)toAdd), () -> ProcessorLists.field_244101_a, JigsawPattern.PlacementBehaviour.RIGID), (Object)weight));
        ResourceLocation name = old.func_214947_b();
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243656_h, (ResourceLocation)pool, (Object)new JigsawPattern(pool, name, newPieces));
    }
}

