/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.polarizingbiomes;

import bl4ckscor3.mod.polarizingbiomes.PolarizingBiomeFeatures;
import bl4ckscor3.mod.snowundertrees.SnowUnderTrees;
import java.util.function.Supplier;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.MoodSoundAmbience;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.structure.StructureFeatures;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilders;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod(value="polarizingbiomes")
public class PolarizingBiomes {
    public static final String MODID = "polarizingbiomes";
    public static final DeferredRegister<Biome> BIOMES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BIOMES, (String)"polarizingbiomes");
    public static final RegistryObject<Biome> BIG_FROZEN_LAKES = PolarizingBiomes.registerBiome("big_frozen_lakes", () -> PolarizingBiomes.makeAbstractLakes(() -> PolarizingBiomeFeatures.BIG_FROZEN_LAKES), BiomeDictionary.Type.COLD, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.OVERWORLD);
    public static final RegistryObject<Biome> DENSE_TAIGA_FOREST = PolarizingBiomes.registerBiome("dense_taiga_forest", PolarizingBiomes::makeDenseTaigaForest, BiomeDictionary.Type.COLD, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.OVERWORLD);
    public static final RegistryObject<Biome> FROZEN_FOREST = PolarizingBiomes.registerBiome("frozen_forest", PolarizingBiomes::makeFrozenForest, BiomeDictionary.Type.COLD, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.OVERWORLD);
    public static final RegistryObject<Biome> FROZEN_LAKES = PolarizingBiomes.registerBiome("frozen_lakes", () -> PolarizingBiomes.makeAbstractLakes(() -> PolarizingBiomeFeatures.FROZEN_LAKES), BiomeDictionary.Type.COLD, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.OVERWORLD);
    public static final RegistryObject<Biome> WINTRY_MOUNTAINS = PolarizingBiomes.registerBiome("wintry_mountains", PolarizingBiomes::makeWintryMountains, BiomeDictionary.Type.COLD, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.OVERWORLD);

    public PolarizingBiomes() {
        BIOMES.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    public static RegistryObject<Biome> registerBiome(String name, Supplier<Biome> biome, BiomeDictionary.Type ... types) {
        ResourceLocation biomeLocation = new ResourceLocation(MODID, name);
        RegistryKey biomeKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)biomeLocation);
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.ICY, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(biomeKey, 10));
        BiomeDictionary.addTypes((RegistryKey)biomeKey, (BiomeDictionary.Type[])types);
        return BIOMES.register(name, biome);
    }

    public static Biome makeDenseTaigaForest() {
        MobSpawnInfo.Builder spawnInfo = new MobSpawnInfo.Builder();
        BiomeGenerationSettings.Builder generationSettings = new BiomeGenerationSettings.Builder().func_242517_a(ConfiguredSurfaceBuilders.field_244178_j).func_242516_a(StructureFeatures.field_244141_g).func_242516_a(StructureFeatures.field_244159_y);
        PolarizingBiomes.withDefaultSettings(generationSettings);
        generationSettings.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, PolarizingBiomeFeatures.SPRUCE_TREES_DENSE);
        generationSettings.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, PolarizingBiomeFeatures.SLIM_SPRUCE_TREES);
        DefaultBiomeFeatures.func_243741_e((MobSpawnInfo.Builder)spawnInfo);
        return new Biome.Builder().func_205415_a(Biome.RainType.SNOW).func_205419_a(Biome.Category.ICY).func_205421_a(0.2f).func_205420_b(0.18f).func_205414_c(-0.5f).func_205417_d(0.5f).func_235097_a_(new BiomeAmbience.Builder().func_242539_d(8364543).func_235239_a_(12638463).func_235246_b_(4159204).func_235248_c_(329011).func_235243_a_(MoodSoundAmbience.field_235027_b_).func_235238_a_()).func_242457_a(generationSettings.func_242508_a()).func_242458_a(spawnInfo.func_242577_b()).func_242455_a();
    }

    public static Biome makeFrozenForest() {
        MobSpawnInfo.Builder spawnInfo = new MobSpawnInfo.Builder();
        BiomeGenerationSettings.Builder generationSettings = new BiomeGenerationSettings.Builder().func_242517_a(ConfiguredSurfaceBuilders.field_244178_j).func_242516_a(StructureFeatures.field_244141_g).func_242516_a(StructureFeatures.field_244159_y).func_242516_a(StructureFeatures.field_244157_w).func_242516_a(StructureFeatures.field_244135_a);
        PolarizingBiomes.withDefaultSettings(generationSettings);
        DefaultBiomeFeatures.func_243690_D((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243741_e((MobSpawnInfo.Builder)spawnInfo);
        return new Biome.Builder().func_205415_a(Biome.RainType.SNOW).func_205419_a(Biome.Category.ICY).func_205421_a(0.2f).func_205420_b(0.06f).func_205414_c(-2.0f).func_205417_d(0.5f).func_235097_a_(new BiomeAmbience.Builder().func_242539_d(8364543).func_235239_a_(12638463).func_235246_b_(4159204).func_235248_c_(329011).func_242540_e(0xFEFEFE).func_242541_f(0xFEFEFE).func_235243_a_(MoodSoundAmbience.field_235027_b_).func_235238_a_()).func_242457_a(generationSettings.func_242508_a()).func_242458_a(spawnInfo.func_242577_b()).func_242455_a();
    }

    public static Biome makeAbstractLakes(Supplier<ConfiguredFeature<?, ?>> lake) {
        MobSpawnInfo.Builder spawnInfo = new MobSpawnInfo.Builder();
        BiomeGenerationSettings.Builder generationSettings = new BiomeGenerationSettings.Builder().func_242517_a(ConfiguredSurfaceBuilders.field_244178_j).func_242516_a(StructureFeatures.field_244141_g).func_242516_a(StructureFeatures.field_244159_y).func_242516_a(StructureFeatures.field_244157_w).func_242516_a(StructureFeatures.field_244135_a);
        PolarizingBiomes.withDefaultSettings(generationSettings);
        generationSettings.func_242513_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, lake.get());
        generationSettings.func_242513_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, lake.get());
        generationSettings.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, PolarizingBiomeFeatures.OAK_TREES);
        generationSettings.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, PolarizingBiomeFeatures.SPRUCE_TREES_LAKES);
        DefaultBiomeFeatures.func_243741_e((MobSpawnInfo.Builder)spawnInfo);
        return new Biome.Builder().func_205415_a(Biome.RainType.SNOW).func_205419_a(Biome.Category.ICY).func_205421_a(0.2f).func_205420_b(0.15f).func_205414_c(-2.0f).func_205417_d(0.5f).func_235097_a_(new BiomeAmbience.Builder().func_242539_d(8364543).func_235239_a_(12638463).func_235246_b_(4159204).func_235248_c_(329011).func_242540_e(0xFEFEFE).func_242541_f(0xFEFEFE).func_235243_a_(MoodSoundAmbience.field_235027_b_).func_235238_a_()).func_242457_a(generationSettings.func_242508_a()).func_242458_a(spawnInfo.func_242577_b()).func_242455_a();
    }

    public static Biome makeWintryMountains() {
        MobSpawnInfo.Builder spawnInfo = new MobSpawnInfo.Builder();
        BiomeGenerationSettings.Builder generationSettings = new BiomeGenerationSettings.Builder().func_242517_a(ConfiguredSurfaceBuilders.field_244178_j).func_242516_a(StructureFeatures.field_244141_g).func_242516_a(StructureFeatures.field_244132_C);
        PolarizingBiomes.withDefaultSettings(generationSettings);
        DefaultBiomeFeatures.func_243694_H((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243762_v((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243752_l((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243753_m((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243741_e((MobSpawnInfo.Builder)spawnInfo);
        return new Biome.Builder().func_205415_a(Biome.RainType.SNOW).func_205419_a(Biome.Category.ICY).func_205421_a(2.0f).func_205420_b(0.6f).func_205414_c(-0.5f).func_205417_d(0.5f).func_235097_a_(new BiomeAmbience.Builder().func_242539_d(8364543).func_235239_a_(12638463).func_235246_b_(4159204).func_235248_c_(329011).func_235243_a_(MoodSoundAmbience.field_235027_b_).func_235238_a_()).func_242457_a(generationSettings.func_242508_a()).func_242458_a(spawnInfo.func_242577_b()).func_242455_a();
    }

    private static final void withDefaultSettings(BiomeGenerationSettings.Builder generationSettings) {
        DefaultBiomeFeatures.func_243733_b((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243738_d((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243746_h((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243748_i((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243750_j((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243754_n((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243727_ak((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243707_U((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243701_O((BiomeGenerationSettings.Builder)generationSettings);
        DefaultBiomeFeatures.func_243730_an((BiomeGenerationSettings.Builder)generationSettings);
        generationSettings.func_242513_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, SnowUnderTrees.SNOW_UNDER_TREES);
    }
}

