/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.polarizingbiomes.biome.feature;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.LightType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.BlockStateFeatureConfig;
import net.minecraft.world.gen.feature.Feature;

public class BigLakeFeature
extends Feature<BlockStateFeatureConfig> {
    private static final BlockState AIR = Blocks.field_201941_jj.func_176223_P();

    public BigLakeFeature(Function<Dynamic<?>, ? extends BlockStateFeatureConfig> configFactory) {
        super(configFactory);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, BlockStateFeatureConfig config) {
        int y;
        int x;
        while (pos.func_177956_o() > 5 && world.func_175623_d(pos)) {
            pos = pos.func_177977_b();
        }
        if (pos.func_177956_o() <= 4) {
            return false;
        }
        pos = pos.func_177979_c(4);
        ChunkPos chunkpos = new ChunkPos(pos);
        if (!world.func_217348_a(chunkpos.field_77276_a, chunkpos.field_77275_b, ChunkStatus.field_222607_c).func_201578_b(Feature.field_214550_p.func_143025_a()).isEmpty()) {
            return false;
        }
        boolean[] shouldPlace = new boolean[Short.MAX_VALUE];
        int i = rand.nextInt(4) + 4;
        for (int j = 0; j < i; ++j) {
            double d0 = rand.nextDouble() * 12.0 + 6.0;
            double d1 = rand.nextDouble() * 8.0 + 4.0;
            double d2 = rand.nextDouble() * 12.0 + 6.0;
            double d3 = rand.nextDouble() * (32.0 - d0 - 4.0) + 2.0 + d0 / 4.0;
            double d4 = rand.nextDouble() * (16.0 - d1 - 8.0) + 1.0 + d1 / 4.0;
            double d5 = rand.nextDouble() * (32.0 - d2 - 4.0) + 2.0 + d2 / 4.0;
            for (int x2 = 1; x2 < 31; ++x2) {
                for (int z = 1; z < 31; ++z) {
                    for (int y2 = 1; y2 < 15; ++y2) {
                        double d6 = ((double)x2 - d3) / (d0 / 2.0);
                        double d7 = ((double)y2 - d4) / (d1 / 2.0);
                        double d8 = ((double)z - d5) / (d2 / 2.0);
                        double d9 = d6 * d6 + d7 * d7 + d8 * d8;
                        if (!(d9 < 1.0)) continue;
                        shouldPlace[(x2 * 32 + z) * 16 + y2] = true;
                    }
                }
            }
        }
        for (x = 0; x < 32; ++x) {
            for (int z = 0; z < 32; ++z) {
                for (y = 0; y < 16; ++y) {
                    boolean flag;
                    boolean bl = flag = !shouldPlace[(x * 32 + z) * 16 + y] && (x < 32 && shouldPlace[((x + 1) * 32 + z) * 16 + y] || x > 0 && shouldPlace[((x - 1) * 32 + z) * 16 + y] || z < 15 && shouldPlace[(x * 32 + z + 1) * 16 + y] || z > 0 && shouldPlace[(x * 32 + (z - 1)) * 16 + y] || y < 7 && shouldPlace[(x * 32 + z) * 16 + y + 1] || y > 0 && shouldPlace[(x * 32 + z) * 16 + (y - 1)]);
                    if (!flag) continue;
                    Material material = world.func_180495_p(pos.func_177982_a(x, y, z)).func_185904_a();
                    if (y >= 4 && material.func_76224_d()) {
                        return false;
                    }
                    if (y >= 4 || material.func_76220_a() || world.func_180495_p(pos.func_177982_a(x, y, z)) == config.field_227270_a_) continue;
                    return false;
                }
            }
        }
        for (x = 0; x < 32; ++x) {
            for (int z = 0; z < 32; ++z) {
                for (y = 0; y < 16; ++y) {
                    if (!shouldPlace[(x * 32 + z) * 16 + y]) continue;
                    world.func_180501_a(pos.func_177982_a(x, y, z), y >= 4 ? AIR : config.field_227270_a_, 2);
                }
            }
        }
        for (x = 0; x < 32; ++x) {
            for (int z = 0; z < 32; ++z) {
                for (y = 4; y < 16; ++y) {
                    BlockPos blockPos;
                    if (!shouldPlace[(x * 32 + z) * 16 + y] || !BigLakeFeature.func_227250_b_((Block)world.func_180495_p(blockPos = pos.func_177982_a(x, y - 1, z)).func_177230_c()) || world.func_226658_a_(LightType.SKY, pos.func_177982_a(x, y, z)) <= 0) continue;
                    Biome biome = world.func_226691_t_(blockPos);
                    if (biome.func_203944_q().func_204108_a().func_177230_c() == Blocks.field_150391_bh) {
                        world.func_180501_a(blockPos, Blocks.field_150391_bh.func_176223_P(), 2);
                        continue;
                    }
                    world.func_180501_a(blockPos, Blocks.field_196658_i.func_176223_P(), 2);
                }
            }
        }
        return true;
    }
}

