/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.command.CommandSource;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.WorkbenchContainer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.polymorph.api.PolymorphApi;
import top.theillusivec4.polymorph.client.ClientEventHandler;
import top.theillusivec4.polymorph.common.integrations.craftingstation.CraftingStationModule;
import top.theillusivec4.polymorph.common.integrations.fastbench.FastWorkbenchModule;
import top.theillusivec4.polymorph.common.integrations.jei.PolymorphJeiPlugin;
import top.theillusivec4.polymorph.common.integrations.silentgear.SilentGearModule;
import top.theillusivec4.polymorph.common.integrations.storagenetwork.StorageNetworkModule;
import top.theillusivec4.polymorph.common.network.NetworkHandler;
import top.theillusivec4.polymorph.common.provider.InventoryProvider;
import top.theillusivec4.polymorph.common.provider.WorkbenchProvider;
import top.theillusivec4.polymorph.server.PolymorphCommand;

@Mod(value="polymorph")
public class Polymorph {
    public static final String MODID = "polymorph";
    public static final Logger LOGGER = LogManager.getLogger();
    public static boolean isFastBenchLoaded = false;
    public static boolean isCraftingStationLoaded = false;
    public static boolean isJeiLoaded = false;
    public static boolean isSilentGearLoaded = false;
    public static boolean isStorageNetworkLoaded = false;

    public Polymorph() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::setup);
        eventBus.addListener(this::clientSetup);
        MinecraftForge.EVENT_BUS.addListener(this::serverStarting);
        ModList modList = ModList.get();
        isFastBenchLoaded = modList.isLoaded("fastbench");
        isCraftingStationLoaded = modList.isLoaded("craftingstation");
        isJeiLoaded = modList.isLoaded("jei");
        isSilentGearLoaded = modList.isLoaded("silentgear");
        isStorageNetworkLoaded = modList.isLoaded("storagenetwork");
    }

    private void setup(FMLCommonSetupEvent evt) {
        NetworkHandler.register();
        PolymorphApi.addProvider(WorkbenchContainer.class, WorkbenchProvider::new);
        PolymorphApi.addProvider(PlayerContainer.class, InventoryProvider::new);
        if (isFastBenchLoaded) {
            FastWorkbenchModule.setup();
        }
        if (isCraftingStationLoaded) {
            CraftingStationModule.setup();
        }
        if (isSilentGearLoaded) {
            SilentGearModule.setup();
        }
        if (isStorageNetworkLoaded) {
            StorageNetworkModule.setup();
        }
    }

    private void clientSetup(FMLClientSetupEvent evt) {
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
        if (isJeiLoaded) {
            PolymorphJeiPlugin.clientSetup();
        }
    }

    private void serverStarting(FMLServerStartingEvent evt) {
        PolymorphCommand.register((CommandDispatcher<CommandSource>)evt.getCommandDispatcher());
    }
}

