/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.api;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;

public class PolymorphApi {
    private static final Map<Class<? extends Container>, Function<? extends Container, IProvider>> providerFunctions = new HashMap<Class<? extends Container>, Function<? extends Container, IProvider>>();

    public static <T extends Container> void addProvider(Class<T> clazz, Function<T, IProvider> providerFunction) {
        providerFunctions.put(clazz, providerFunction);
    }

    public static <T extends Container> Optional<IProvider> getProvider(T container) {
        Function<? extends Container, IProvider> providerFunction = providerFunctions.get(container.getClass());
        return providerFunction != null ? Optional.of(providerFunction.apply(container)) : Optional.empty();
    }

    public static interface IProvider {
        public Container getContainer();

        default public CraftingInventory getCraftingInventory() {
            for (Slot slot : this.getContainer().field_75151_b) {
                if (!(slot.field_75224_c instanceof CraftingInventory)) continue;
                return (CraftingInventory)slot.field_75224_c;
            }
            return null;
        }

        default public Slot getOutputSlot() {
            for (Slot slot : this.getContainer().field_75151_b) {
                if (!(slot.field_75224_c instanceof CraftResultInventory)) continue;
                return slot;
            }
            return (Slot)this.getContainer().field_75151_b.get(0);
        }

        public int getXOffset();

        public int getYOffset();
    }
}

