/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.client;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.recipebook.IRecipeShownListener;
import net.minecraft.client.gui.recipebook.RecipeBookGui;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.client.util.InputMappings;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeBook;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.network.PacketDistributor;
import top.theillusivec4.polymorph.Polymorph;
import top.theillusivec4.polymorph.api.PolymorphApi;
import top.theillusivec4.polymorph.client.RecipeOutputWrapper;
import top.theillusivec4.polymorph.client.gui.RecipeSelectionGui;
import top.theillusivec4.polymorph.client.gui.ToggleOutputButton;
import top.theillusivec4.polymorph.common.network.NetworkHandler;
import top.theillusivec4.polymorph.common.network.client.CPacketSetRecipe;
import top.theillusivec4.polymorph.common.network.client.CPacketTransferRecipe;

public class RecipeConflictManager {
    private static final ResourceLocation TOGGLE = new ResourceLocation("polymorph", "textures/gui/toggle.png");
    private static final Field RECIPE_BOOK = ObfuscationReflectionHelper.findField(RecipeBookGui.class, (String)"field_193964_s");
    private static RecipeConflictManager instance;
    private static ItemStack preferredStack;
    private RecipeSelectionGui recipeSelectionGui;
    private CraftingInventory currentCraftingMatrix;
    private IRecipe<CraftingInventory> lastPlacedRecipe;
    private List<ICraftingRecipe> lastRecipesList;
    private IRecipe<CraftingInventory> lastSelectedRecipe;
    private ImageButton switchButton;
    private boolean resultChanged;
    private boolean positionChanged;
    private boolean lockUpdates;
    private ContainerScreen<?> parent;
    private PolymorphApi.IProvider provider;
    private static final int GLFW_LEFT_SHIFT = 340;
    private static final int GLFW_RIGHT_SHIFT = 344;

    public RecipeConflictManager(ContainerScreen<?> screen, PolymorphApi.IProvider provider) {
        this.parent = screen;
        this.provider = provider;
        int x = screen.width / 2;
        int y = screen.height / 2;
        this.recipeSelectionGui = new RecipeSelectionGui(this, (x += provider.getXOffset()) - 4, (y += provider.getYOffset()) - 32);
        this.switchButton = new ToggleOutputButton(x, y, 16, 16, 0, 0, 17, TOGGLE, clickWidget -> this.recipeSelectionGui.setVisible(!this.recipeSelectionGui.isVisible()));
        this.switchButton.visible = this.recipeSelectionGui.getButtons().size() > 1;
        this.currentCraftingMatrix = provider.getCraftingInventory();
    }

    public static Optional<RecipeConflictManager> getInstance() {
        return Optional.ofNullable(instance);
    }

    public static RecipeConflictManager refreshInstance(ContainerScreen<?> screen, PolymorphApi.IProvider provider) {
        instance = new RecipeConflictManager(screen, provider);
        return instance;
    }

    public static void clearInstance() {
        instance = null;
    }

    public static ItemStack getPreferredStack() {
        return preferredStack;
    }

    public static void setPreferredStack(ItemStack stack) {
        preferredStack = stack.func_77946_l();
    }

    public void markPositionChanged() {
        this.positionChanged = true;
    }

    public void tick() {
        if (this.positionChanged) {
            this.positionChanged = false;
            int x = this.parent.width / 2;
            int y = this.parent.height / 2;
            x += this.provider.getXOffset();
            y += this.provider.getYOffset();
            if (this.parent instanceof IRecipeShownListener) {
                IRecipeShownListener recipeShownListener = (IRecipeShownListener)this.parent;
                RecipeBookGui recipeBookGui = recipeShownListener.func_194310_f();
                RecipeBook recipeBook = null;
                try {
                    recipeBook = (RecipeBook)RECIPE_BOOK.get(recipeBookGui);
                }
                catch (IllegalAccessException e) {
                    Polymorph.LOGGER.error("Something went wrong while accessing recipe book!");
                }
                if (recipeBook != null && recipeBookGui.func_191878_b()) {
                    x += 77;
                }
            }
            this.recipeSelectionGui.setPosition(x - 4, y - 32);
            this.switchButton.func_191746_c(x, y);
        }
        if (this.resultChanged) {
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            this.resultChanged = false;
            if (world != null) {
                this.getCurrentCraftingMatrix().ifPresent(craftingInventory -> {
                    List recipesList = this.getLastPlacedRecipe().map(recipe -> {
                        if (recipe.func_77569_a((IInventory)craftingInventory, (World)world)) {
                            return this.getLastRecipesList().orElse(new ArrayList());
                        }
                        return null;
                    }).orElseGet(() -> this.fetchRecipes((CraftingInventory)craftingInventory, (World)world));
                    this.recipeSelectionGui.setRecipes(recipesList);
                    if (!preferredStack.func_190926_b()) {
                        for (ICraftingRecipe craftingRecipe : recipesList) {
                            if (craftingRecipe.func_77572_b((IInventory)craftingInventory).func_77973_b() != preferredStack.func_77973_b()) continue;
                            this.setLastSelectedRecipe((IRecipe<CraftingInventory>)craftingRecipe);
                            break;
                        }
                        preferredStack = ItemStack.field_190927_a;
                    }
                    this.getLastSelectedRecipe().ifPresent(recipe -> {
                        if (recipe.func_77569_a((IInventory)craftingInventory, (World)world)) {
                            ClientPlayerEntity playerEntity = Minecraft.func_71410_x().field_71439_g;
                            this.lockUpdates = true;
                            if (playerEntity != null) {
                                NetworkHandler.INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new CPacketSetRecipe(recipe.func_199560_c().toString()));
                            }
                        }
                    });
                });
            }
        }
    }

    private List<ICraftingRecipe> fetchRecipes(CraftingInventory craftingInventory, World world) {
        List<Object> recipes = new ArrayList<ICraftingRecipe>();
        boolean isCraftingEmpty = true;
        for (int i = 0; i < craftingInventory.func_70302_i_(); ++i) {
            if (craftingInventory.func_70301_a(i).func_190926_b()) continue;
            isCraftingEmpty = false;
            break;
        }
        if (!isCraftingEmpty) {
            HashSet recipeOutputs = new HashSet();
            try {
                recipes = world.func_199532_z().func_215370_b(IRecipeType.field_222149_a, (IInventory)craftingInventory, world);
            }
            catch (Exception e) {
                ArrayList<String> stacks = new ArrayList<String>();
                for (int i = 0; i < craftingInventory.func_70302_i_(); ++i) {
                    stacks.add(craftingInventory.func_70301_a(i).toString());
                }
                Polymorph.LOGGER.error("Attempted to craft using " + Arrays.toString(stacks.toArray()) + " but an error occurred while fetching recipes!", (Throwable)e);
            }
            recipes.removeIf(rec -> !recipeOutputs.add(new RecipeOutputWrapper(rec.func_77572_b((IInventory)craftingInventory))));
            if (!recipes.isEmpty()) {
                ICraftingRecipe defaultRecipe = (ICraftingRecipe)recipes.get(0);
                this.setLastSelectedRecipe((IRecipe<CraftingInventory>)defaultRecipe);
                this.setLastPlacedRecipe((IRecipe<CraftingInventory>)defaultRecipe);
                this.setLastRecipesList(recipes);
            }
        }
        return recipes;
    }

    public void renderRecipeSelectionGui(int mouseX, int mouseY, float partialTicks) {
        this.recipeSelectionGui.render(mouseX, mouseY, partialTicks);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.recipeSelectionGui.mouseClicked(mouseX, mouseY, button)) {
            this.recipeSelectionGui.setVisible(false);
            return true;
        }
        if (this.recipeSelectionGui.isVisible()) {
            if (!this.switchButton.mouseClicked(mouseX, mouseY, button)) {
                this.recipeSelectionGui.setVisible(false);
            }
            return true;
        }
        Slot slot = this.provider.getOutputSlot();
        if (this.getSwitchButton().visible && slot == this.parent.getSlotUnderMouse() && RecipeConflictManager.isShiftKeyDown()) {
            return this.getLastSelectedRecipe().map(recipe -> this.getCurrentCraftingMatrix().map(craftingInventory -> {
                NetworkHandler.INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new CPacketTransferRecipe(recipe.func_199560_c().toString()));
                return true;
            }).orElse(false)).orElse(false);
        }
        return false;
    }

    public void selectRecipe(IRecipe<CraftingInventory> recipe) {
        this.setLastSelectedRecipe(recipe);
        ClientPlayerEntity playerEntity = Minecraft.func_71410_x().field_71439_g;
        if (playerEntity != null) {
            this.getCurrentCraftingMatrix().ifPresent(craftingInventory -> {
                ItemStack stack = recipe.func_77572_b((IInventory)craftingInventory);
                this.provider.getOutputSlot().func_75215_d(stack.func_77946_l());
                NetworkHandler.INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new CPacketSetRecipe(recipe.func_199560_c().toString()));
            });
        }
    }

    public boolean canUpdate() {
        return !this.lockUpdates;
    }

    public void unlockUpdates() {
        this.lockUpdates = false;
    }

    public Optional<List<ICraftingRecipe>> getLastRecipesList() {
        return Optional.ofNullable(this.lastRecipesList);
    }

    public void setLastRecipesList(List<ICraftingRecipe> recipesList) {
        this.lastRecipesList = recipesList;
    }

    public Optional<IRecipe<CraftingInventory>> getLastPlacedRecipe() {
        return Optional.ofNullable(this.lastPlacedRecipe);
    }

    public void setLastPlacedRecipe(IRecipe<CraftingInventory> recipe) {
        this.lastPlacedRecipe = recipe;
    }

    public Optional<IRecipe<CraftingInventory>> getLastSelectedRecipe() {
        return Optional.ofNullable(this.lastSelectedRecipe);
    }

    public void setLastSelectedRecipe(IRecipe<CraftingInventory> recipe) {
        this.lastSelectedRecipe = recipe;
    }

    public Optional<CraftingInventory> getCurrentCraftingMatrix() {
        return Optional.ofNullable(this.currentCraftingMatrix);
    }

    public ImageButton getSwitchButton() {
        return this.switchButton;
    }

    public void markResultChanged() {
        this.resultChanged = true;
    }

    private static boolean isShiftKeyDown() {
        long handle = Minecraft.func_71410_x().func_228018_at_().func_198092_i();
        return InputMappings.func_216506_a((long)handle, (int)340) || InputMappings.func_216506_a((long)handle, (int)344);
    }

    static {
        preferredStack = ItemStack.field_190927_a;
    }
}

