/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.client.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.IRenderable;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import top.theillusivec4.polymorph.client.RecipeConflictManager;
import top.theillusivec4.polymorph.client.gui.RecipeSelectWidget;

public class RecipeSelectionGui
extends AbstractGui
implements IRenderable,
IGuiEventListener {
    private final RecipeConflictManager conflictManager;
    private List<RecipeSelectWidget> buttons = new ArrayList<RecipeSelectWidget>();
    private RecipeSelectWidget hoveredButton;
    private boolean visible = false;
    private int x;
    private int y;
    private List<ICraftingRecipe> recipes = new ArrayList<ICraftingRecipe>();

    public RecipeSelectionGui(RecipeConflictManager conflictManager, int x, int y) {
        this.conflictManager = conflictManager;
        this.x = x;
        this.y = y;
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
        this.updateButtonPositions();
    }

    private void updateButtonPositions() {
        int size = this.recipes.size();
        int xOffset = (int)(-25.0 * Math.floor((float)size / 2.0f));
        if (size % 2 == 0) {
            xOffset += 13;
        }
        int[] pos = new int[]{this.x + xOffset, this.y};
        this.buttons.forEach(button -> {
            button.setPosition(pos[0], pos[1]);
            pos[0] = pos[0] + 25;
        });
    }

    public List<RecipeSelectWidget> getButtons() {
        return this.buttons;
    }

    public void setRecipes(List<ICraftingRecipe> recipes) {
        this.recipes = recipes;
        this.buttons.clear();
        this.conflictManager.getCurrentCraftingMatrix().ifPresent(craftingInventory -> recipes.forEach(recipe -> this.buttons.add(new RecipeSelectWidget((CraftingInventory)craftingInventory, (IRecipe<CraftingInventory>)recipe))));
        this.updateButtonPositions();
        this.conflictManager.getSwitchButton().visible = recipes.size() > 1;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void renderTooltip(int p_193721_1_, int p_193721_2_) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r != null && this.hoveredButton != null) {
            mc.field_71462_r.renderTooltip(this.hoveredButton.getTooltipText(mc.field_71462_r), p_193721_1_, p_193721_2_);
        }
    }

    public void render(int p_render_1_, int p_render_2_, float p_render_3_) {
        if (this.isVisible()) {
            this.hoveredButton = null;
            this.buttons.forEach(button -> {
                button.render(p_render_1_, p_render_2_, p_render_3_);
                if (button.visible && button.isHovered()) {
                    this.hoveredButton = button;
                }
            });
            this.renderTooltip(p_render_1_, p_render_2_);
        }
    }

    public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        if (this.isVisible()) {
            for (RecipeSelectWidget button : this.buttons) {
                if (!button.mouseClicked(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_)) continue;
                this.conflictManager.selectRecipe(button.recipe);
                return true;
            }
        }
        return false;
    }
}

