/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.common.network.client;

import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import top.theillusivec4.polymorph.Polymorph;
import top.theillusivec4.polymorph.api.PolymorphApi;
import top.theillusivec4.polymorph.common.integrations.fastbench.FastWorkbenchModule;
import top.theillusivec4.polymorph.common.integrations.storagenetwork.StorageNetworkModule;
import top.theillusivec4.polymorph.common.network.NetworkHandler;
import top.theillusivec4.polymorph.common.network.server.SPacketSyncOutput;

public class CPacketTransferRecipe {
    private final String recipe;

    public CPacketTransferRecipe(String recipe) {
        this.recipe = recipe;
    }

    public static void encode(CPacketTransferRecipe msg, PacketBuffer buf) {
        buf.func_180714_a(msg.recipe);
    }

    public static CPacketTransferRecipe decode(PacketBuffer buf) {
        return new CPacketTransferRecipe(buf.func_150789_c(Short.MAX_VALUE));
    }

    public static void handle(CPacketTransferRecipe msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (sender != null) {
                Container container = sender.field_71070_bA;
                PolymorphApi.getProvider(container).ifPresent(provider -> {
                    Slot slot = provider.getOutputSlot();
                    Optional result = sender.func_71121_q().func_199532_z().func_215367_a(new ResourceLocation(msg.recipe));
                    CraftingInventory finalCraftingInventory = provider.getCraftingInventory();
                    result.ifPresent(res -> {
                        if (res instanceof ICraftingRecipe && finalCraftingInventory != null) {
                            ICraftingRecipe craftingRecipe = (ICraftingRecipe)res;
                            if (Polymorph.isFastBenchLoaded) {
                                FastWorkbenchModule.setLastRecipe(container, (IRecipe<CraftingInventory>)craftingRecipe);
                            }
                            if (Polymorph.isStorageNetworkLoaded && StorageNetworkModule.isNetworkContainer(container)) {
                                StorageNetworkModule.transferStackInSlot(container, (PlayerEntity)sender, slot.field_75222_d, craftingRecipe);
                            } else {
                                ItemStack itemstack = container.func_82846_b((PlayerEntity)sender, slot.field_75222_d);
                                if (craftingRecipe.func_77569_a((IInventory)finalCraftingInventory, sender.field_70170_p)) {
                                    slot.func_75215_d(craftingRecipe.func_77572_b((IInventory)finalCraftingInventory));
                                    while (!itemstack.func_190926_b() && ItemStack.func_179545_c((ItemStack)slot.func_75211_c(), (ItemStack)itemstack)) {
                                        itemstack = container.func_82846_b((PlayerEntity)sender, slot.field_75222_d);
                                        if (!craftingRecipe.func_77569_a((IInventory)finalCraftingInventory, sender.field_70170_p)) continue;
                                        slot.func_75215_d(craftingRecipe.func_77572_b((IInventory)finalCraftingInventory));
                                    }
                                }
                            }
                        }
                    });
                });
                NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> sender), (Object)new SPacketSyncOutput(ItemStack.field_190927_a));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

