/*
 * Decompiled with CFR 0.152.
 */
package com.mitchellmarsden.portableworkbench.keyboard;

import com.mitchellmarsden.portableworkbench.keyboard.KeyHandler;
import java.util.HashSet;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3675;

@Environment(value=EnvType.CLIENT)
public class Key {
    private int keyCode;
    private KeyHandler onKeyPress;
    private final Set<Key> subKeys = new HashSet<Key>();
    private boolean triggeredSincePress;
    private int pressDuration = 0;

    Key(int keyCode) {
        this.keyCode = keyCode;
    }

    public Key onKeyPressHandler(KeyHandler onKeyPress) {
        this.onKeyPress = onKeyPress;
        return this;
    }

    void updateKeyCode(int keyCode) {
        this.keyCode = keyCode;
    }

    private void runHandler(KeyHandler onKeyPress) {
        this.triggeredSincePress = true;
        onKeyPress.handle();
    }

    private void press() {
        if (this.onKeyPress != null) {
            this.runHandler(this.onKeyPress);
        }
    }

    private void release() {
    }

    boolean handleKeyEvent(int keyCode, boolean isPressed) {
        if (this.keyCode == keyCode) {
            if (isPressed) {
                this.press();
            } else {
                this.release();
            }
            return true;
        }
        if (this.pressDuration > 0) {
            for (Key subKey : this.subKeys) {
                if (!subKey.handleKeyEvent(keyCode, isPressed)) continue;
                return true;
            }
        }
        return false;
    }

    public Key register(String keyName) {
        class_3675.class_306 input = class_3675.method_15981((String)keyName);
        Key key = new Key(input.method_1444());
        this.subKeys.add(key);
        return key;
    }
}

