/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.qolq.powershot;

import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public final class PowerableCapability {
    public static final ResourceLocation KEY = new ResourceLocation("powershot", "powerable");
    @CapabilityInject(value=IPowerable.class)
    public static Capability<IPowerable> instance = null;

    public static class Serializer
    implements Capability.IStorage<IPowerable> {
        private static final String POWER_KEY = "power";

        public INBT writeNBT(Capability<IPowerable> capability, IPowerable powerable, Direction side) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74776_a(POWER_KEY, powerable.getPower());
            return nbt;
        }

        public void readNBT(Capability<IPowerable> capability, IPowerable powerable, Direction side, INBT nbt) {
            if (nbt instanceof CompoundNBT) {
                powerable.setPower(((CompoundNBT)nbt).func_74760_g(POWER_KEY));
            }
        }
    }

    public static class Powerable
    implements IPowerable,
    ICapabilitySerializable<CompoundNBT> {
        private float power = 0.0f;

        @Override
        public float getPower() {
            return this.power;
        }

        @Override
        public void setPower(float power) {
            this.power = power;
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction side) {
            return capability == instance ? LazyOptional.of(() -> this).cast() : LazyOptional.empty();
        }

        public CompoundNBT serializeNBT() {
            return (CompoundNBT)instance.getStorage().writeNBT(instance, (Object)this, null);
        }

        public void deserializeNBT(CompoundNBT nbt) {
            instance.getStorage().readNBT(instance, (Object)this, null, (INBT)nbt);
        }
    }

    public static interface IPowerable {
        public float getPower();

        public void setPower(float var1);
    }
}

